<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Anulacion ServiceType
 * @subpackage Services
 */
class Anulacion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AnulacionLRFacturasEmitidas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BajaLRFacturasEmitidas $anulacionLRFacturasEmitidas
     * @return \StructType\RespuestaLRBajaFEmitidasType|bool
     */
    public function AnulacionLRFacturasEmitidas(\StructType\BajaLRFacturasEmitidas $anulacionLRFacturasEmitidas)
    {
        try {
            $this->setResult(self::getSoapClient()->AnulacionLRFacturasEmitidas($anulacionLRFacturasEmitidas));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaLRBajaFEmitidasType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
