<?php

namespace EnumType;

/**
 * This class stands for VersionSiiType EnumType
 * @subpackage Enumerations
 */
class VersionSiiType
{
    /**
     * Constant for value '0.5'
     * @return string '0.5'
     */
    const VALUE_0_5 = '0.5';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_0_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_0_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
