<?php

namespace EnumType;

/**
 * This class stands for ResultadoConsultaType EnumType
 * @subpackage Enumerations
 */
class ResultadoConsultaType
{
    /**
     * Constant for value 'ConDatos'
     * @return string 'ConDatos'
     */
    const VALUE_CON_DATOS = 'ConDatos';
    /**
     * Constant for value 'SinDatos'
     * @return string 'SinDatos'
     */
    const VALUE_SIN_DATOS = 'SinDatos';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CON_DATOS
     * @uses self::VALUE_SIN_DATOS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CON_DATOS,
            self::VALUE_SIN_DATOS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
