<?php

namespace EnumType;

/**
 * This class stands for ErrorEnvioType EnumType
 * @subpackage Enumerations
 */
class ErrorEnvioType
{
    /**
     * Constant for value 'ERR01'
     * @return string 'ERR01'
     */
    const VALUE_ERR_01 = 'ERR01';
    /**
     * Constant for value 'ERR03'
     * @return string 'ERR03'
     */
    const VALUE_ERR_03 = 'ERR03';
    /**
     * Constant for value 'ERR04'
     * @return string 'ERR04'
     */
    const VALUE_ERR_04 = 'ERR04';
    /**
     * Constant for value 'ERR05'
     * @return string 'ERR05'
     */
    const VALUE_ERR_05 = 'ERR05';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERR_01
     * @uses self::VALUE_ERR_03
     * @uses self::VALUE_ERR_04
     * @uses self::VALUE_ERR_05
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERR_01,
            self::VALUE_ERR_03,
            self::VALUE_ERR_04,
            self::VALUE_ERR_05,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
