<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VehicleModel
 * @subpackage Structs
 */
class VehicleModel extends AbstractStructBase
{
    /**
     * The MSRP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MSRP;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModelName;
    /**
     * The TrimRecommended
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TrimRecommended;
    /**
     * The VehicleMakeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleMakeId;
    /**
     * The VehicleModelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleModelId;
    /**
     * Constructor method for VehicleModel
     * @uses VehicleModel::setMSRP()
     * @uses VehicleModel::setModelName()
     * @uses VehicleModel::setTrimRecommended()
     * @uses VehicleModel::setVehicleMakeId()
     * @uses VehicleModel::setVehicleModelId()
     * @param float $mSRP
     * @param string $modelName
     * @param bool $trimRecommended
     * @param int $vehicleMakeId
     * @param int $vehicleModelId
     */
    public function __construct($mSRP = null, $modelName = null, $trimRecommended = null, $vehicleMakeId = null, $vehicleModelId = null)
    {
        $this
            ->setMSRP($mSRP)
            ->setModelName($modelName)
            ->setTrimRecommended($trimRecommended)
            ->setVehicleMakeId($vehicleMakeId)
            ->setVehicleModelId($vehicleModelId);
    }
    /**
     * Get MSRP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMSRP()
    {
        return isset($this->MSRP) ? $this->MSRP : null;
    }
    /**
     * Set MSRP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mSRP
     * @return \StructType\VehicleModel
     */
    public function setMSRP($mSRP = null)
    {
        // validation for constraint: float
        if (!is_null($mSRP) && !(is_float($mSRP) || is_numeric($mSRP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mSRP, true), gettype($mSRP)), __LINE__);
        }
        if (is_null($mSRP) || (is_array($mSRP) && empty($mSRP))) {
            unset($this->MSRP);
        } else {
            $this->MSRP = $mSRP;
        }
        return $this;
    }
    /**
     * Get ModelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModelName()
    {
        return isset($this->ModelName) ? $this->ModelName : null;
    }
    /**
     * Set ModelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modelName
     * @return \StructType\VehicleModel
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelName, true), gettype($modelName)), __LINE__);
        }
        if (is_null($modelName) || (is_array($modelName) && empty($modelName))) {
            unset($this->ModelName);
        } else {
            $this->ModelName = $modelName;
        }
        return $this;
    }
    /**
     * Get TrimRecommended value
     * @return bool|null
     */
    public function getTrimRecommended()
    {
        return $this->TrimRecommended;
    }
    /**
     * Set TrimRecommended value
     * @param bool $trimRecommended
     * @return \StructType\VehicleModel
     */
    public function setTrimRecommended($trimRecommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($trimRecommended) && !is_bool($trimRecommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trimRecommended, true), gettype($trimRecommended)), __LINE__);
        }
        $this->TrimRecommended = $trimRecommended;
        return $this;
    }
    /**
     * Get VehicleMakeId value
     * @return int|null
     */
    public function getVehicleMakeId()
    {
        return $this->VehicleMakeId;
    }
    /**
     * Set VehicleMakeId value
     * @param int $vehicleMakeId
     * @return \StructType\VehicleModel
     */
    public function setVehicleMakeId($vehicleMakeId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleMakeId) && !(is_int($vehicleMakeId) || ctype_digit($vehicleMakeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleMakeId, true), gettype($vehicleMakeId)), __LINE__);
        }
        $this->VehicleMakeId = $vehicleMakeId;
        return $this;
    }
    /**
     * Get VehicleModelId value
     * @return int|null
     */
    public function getVehicleModelId()
    {
        return $this->VehicleModelId;
    }
    /**
     * Set VehicleModelId value
     * @param int $vehicleModelId
     * @return \StructType\VehicleModel
     */
    public function setVehicleModelId($vehicleModelId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleModelId) && !(is_int($vehicleModelId) || ctype_digit($vehicleModelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleModelId, true), gettype($vehicleModelId)), __LINE__);
        }
        $this->VehicleModelId = $vehicleModelId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
