<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleMake StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VehicleMake
 * @subpackage Structs
 */
class VehicleMake extends AbstractStructBase
{
    /**
     * The Ethnicity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ethnicity;
    /**
     * The MakeAbbrev
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MakeAbbrev;
    /**
     * The MakeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MakeName;
    /**
     * The VehicleMakeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleMakeId;
    /**
     * Constructor method for VehicleMake
     * @uses VehicleMake::setEthnicity()
     * @uses VehicleMake::setMakeAbbrev()
     * @uses VehicleMake::setMakeName()
     * @uses VehicleMake::setVehicleMakeId()
     * @param string $ethnicity
     * @param string $makeAbbrev
     * @param string $makeName
     * @param int $vehicleMakeId
     */
    public function __construct($ethnicity = null, $makeAbbrev = null, $makeName = null, $vehicleMakeId = null)
    {
        $this
            ->setEthnicity($ethnicity)
            ->setMakeAbbrev($makeAbbrev)
            ->setMakeName($makeName)
            ->setVehicleMakeId($vehicleMakeId);
    }
    /**
     * Get Ethnicity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEthnicity()
    {
        return isset($this->Ethnicity) ? $this->Ethnicity : null;
    }
    /**
     * Set Ethnicity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ethnicity
     * @return \StructType\VehicleMake
     */
    public function setEthnicity($ethnicity = null)
    {
        // validation for constraint: string
        if (!is_null($ethnicity) && !is_string($ethnicity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ethnicity, true), gettype($ethnicity)), __LINE__);
        }
        if (is_null($ethnicity) || (is_array($ethnicity) && empty($ethnicity))) {
            unset($this->Ethnicity);
        } else {
            $this->Ethnicity = $ethnicity;
        }
        return $this;
    }
    /**
     * Get MakeAbbrev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMakeAbbrev()
    {
        return isset($this->MakeAbbrev) ? $this->MakeAbbrev : null;
    }
    /**
     * Set MakeAbbrev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $makeAbbrev
     * @return \StructType\VehicleMake
     */
    public function setMakeAbbrev($makeAbbrev = null)
    {
        // validation for constraint: string
        if (!is_null($makeAbbrev) && !is_string($makeAbbrev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makeAbbrev, true), gettype($makeAbbrev)), __LINE__);
        }
        if (is_null($makeAbbrev) || (is_array($makeAbbrev) && empty($makeAbbrev))) {
            unset($this->MakeAbbrev);
        } else {
            $this->MakeAbbrev = $makeAbbrev;
        }
        return $this;
    }
    /**
     * Get MakeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMakeName()
    {
        return isset($this->MakeName) ? $this->MakeName : null;
    }
    /**
     * Set MakeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $makeName
     * @return \StructType\VehicleMake
     */
    public function setMakeName($makeName = null)
    {
        // validation for constraint: string
        if (!is_null($makeName) && !is_string($makeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makeName, true), gettype($makeName)), __LINE__);
        }
        if (is_null($makeName) || (is_array($makeName) && empty($makeName))) {
            unset($this->MakeName);
        } else {
            $this->MakeName = $makeName;
        }
        return $this;
    }
    /**
     * Get VehicleMakeId value
     * @return int|null
     */
    public function getVehicleMakeId()
    {
        return $this->VehicleMakeId;
    }
    /**
     * Set VehicleMakeId value
     * @param int $vehicleMakeId
     * @return \StructType\VehicleMake
     */
    public function setVehicleMakeId($vehicleMakeId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleMakeId) && !(is_int($vehicleMakeId) || ctype_digit($vehicleMakeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleMakeId, true), gettype($vehicleMakeId)), __LINE__);
        }
        $this->VehicleMakeId = $vehicleMakeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleMake
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
