<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellQuote StructType
 * @subpackage Structs
 */
class SellQuote extends AbstractStructBase
{
    /**
     * The quoteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quoteId;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $policyNumber;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $effectiveDate;
    /**
     * Constructor method for SellQuote
     * @uses SellQuote::setQuoteId()
     * @uses SellQuote::setPolicyNumber()
     * @uses SellQuote::setEffectiveDate()
     * @param int $quoteId
     * @param string $policyNumber
     * @param string $effectiveDate
     */
    public function __construct($quoteId = null, $policyNumber = null, $effectiveDate = null)
    {
        $this
            ->setQuoteId($quoteId)
            ->setPolicyNumber($policyNumber)
            ->setEffectiveDate($effectiveDate);
    }
    /**
     * Get quoteId value
     * @return int|null
     */
    public function getQuoteId()
    {
        return $this->quoteId;
    }
    /**
     * Set quoteId value
     * @param int $quoteId
     * @return \StructType\SellQuote
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !(is_int($quoteId) || ctype_digit($quoteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        $this->quoteId = $quoteId;
        return $this;
    }
    /**
     * Get policyNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return isset($this->policyNumber) ? $this->policyNumber : null;
    }
    /**
     * Set policyNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $policyNumber
     * @return \StructType\SellQuote
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        if (is_null($policyNumber) || (is_array($policyNumber) && empty($policyNumber))) {
            unset($this->policyNumber);
        } else {
            $this->policyNumber = $policyNumber;
        }
        return $this;
    }
    /**
     * Get effectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return isset($this->effectiveDate) ? $this->effectiveDate : null;
    }
    /**
     * Set effectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveDate
     * @return \StructType\SellQuote
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->effectiveDate);
        } else {
            $this->effectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SellQuote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
