<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for secureWebService.ImportQuotePayment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:secureWebService.ImportQuotePayment
 * @subpackage Structs
 */
class SecureWebService_ImportQuotePayment extends AbstractStructBase
{
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PaymentAmount;
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Processed;
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuoteId;
    /**
     * The QuotePaymentSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public $QuotePaymentSource;
    /**
     * Constructor method for secureWebService.ImportQuotePayment
     * @uses SecureWebService_ImportQuotePayment::setPaymentAmount()
     * @uses SecureWebService_ImportQuotePayment::setProcessed()
     * @uses SecureWebService_ImportQuotePayment::setQuoteId()
     * @uses SecureWebService_ImportQuotePayment::setQuotePaymentSource()
     * @param float $paymentAmount
     * @param bool $processed
     * @param int $quoteId
     * @param \StructType\SecureWebService_ImportQuotePaymentSource $quotePaymentSource
     */
    public function __construct($paymentAmount = null, $processed = null, $quoteId = null, \StructType\SecureWebService_ImportQuotePaymentSource $quotePaymentSource = null)
    {
        $this
            ->setPaymentAmount($paymentAmount)
            ->setProcessed($processed)
            ->setQuoteId($quoteId)
            ->setQuotePaymentSource($quotePaymentSource);
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\SecureWebService_ImportQuotePayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get Processed value
     * @return bool|null
     */
    public function getProcessed()
    {
        return $this->Processed;
    }
    /**
     * Set Processed value
     * @param bool $processed
     * @return \StructType\SecureWebService_ImportQuotePayment
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: boolean
        if (!is_null($processed) && !is_bool($processed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        $this->Processed = $processed;
        return $this;
    }
    /**
     * Get QuoteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuoteId()
    {
        return isset($this->QuoteId) ? $this->QuoteId : null;
    }
    /**
     * Set QuoteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quoteId
     * @return \StructType\SecureWebService_ImportQuotePayment
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !(is_int($quoteId) || ctype_digit($quoteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        if (is_null($quoteId) || (is_array($quoteId) && empty($quoteId))) {
            unset($this->QuoteId);
        } else {
            $this->QuoteId = $quoteId;
        }
        return $this;
    }
    /**
     * Get QuotePaymentSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_ImportQuotePaymentSource|null
     */
    public function getQuotePaymentSource()
    {
        return isset($this->QuotePaymentSource) ? $this->QuotePaymentSource : null;
    }
    /**
     * Set QuotePaymentSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_ImportQuotePaymentSource $quotePaymentSource
     * @return \StructType\SecureWebService_ImportQuotePayment
     */
    public function setQuotePaymentSource(\StructType\SecureWebService_ImportQuotePaymentSource $quotePaymentSource = null)
    {
        if (is_null($quotePaymentSource) || (is_array($quotePaymentSource) && empty($quotePaymentSource))) {
            unset($this->QuotePaymentSource);
        } else {
            $this->QuotePaymentSource = $quotePaymentSource;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecureWebService_ImportQuotePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
