<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for secureWebService.ImportQuoteOption StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:secureWebService.ImportQuoteOption
 * @subpackage Structs
 */
class SecureWebService_ImportQuoteOption extends AbstractStructBase
{
    /**
     * The CoverageOptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CoverageOptionId;
    /**
     * The OptionCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OptionCost;
    /**
     * The OptionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptionName;
    /**
     * Constructor method for secureWebService.ImportQuoteOption
     * @uses SecureWebService_ImportQuoteOption::setCoverageOptionId()
     * @uses SecureWebService_ImportQuoteOption::setOptionCost()
     * @uses SecureWebService_ImportQuoteOption::setOptionName()
     * @param int $coverageOptionId
     * @param float $optionCost
     * @param string $optionName
     */
    public function __construct($coverageOptionId = null, $optionCost = null, $optionName = null)
    {
        $this
            ->setCoverageOptionId($coverageOptionId)
            ->setOptionCost($optionCost)
            ->setOptionName($optionName);
    }
    /**
     * Get CoverageOptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCoverageOptionId()
    {
        return isset($this->CoverageOptionId) ? $this->CoverageOptionId : null;
    }
    /**
     * Set CoverageOptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $coverageOptionId
     * @return \StructType\SecureWebService_ImportQuoteOption
     */
    public function setCoverageOptionId($coverageOptionId = null)
    {
        // validation for constraint: int
        if (!is_null($coverageOptionId) && !(is_int($coverageOptionId) || ctype_digit($coverageOptionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coverageOptionId, true), gettype($coverageOptionId)), __LINE__);
        }
        if (is_null($coverageOptionId) || (is_array($coverageOptionId) && empty($coverageOptionId))) {
            unset($this->CoverageOptionId);
        } else {
            $this->CoverageOptionId = $coverageOptionId;
        }
        return $this;
    }
    /**
     * Get OptionCost value
     * @return float|null
     */
    public function getOptionCost()
    {
        return $this->OptionCost;
    }
    /**
     * Set OptionCost value
     * @param float $optionCost
     * @return \StructType\SecureWebService_ImportQuoteOption
     */
    public function setOptionCost($optionCost = null)
    {
        // validation for constraint: float
        if (!is_null($optionCost) && !(is_float($optionCost) || is_numeric($optionCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionCost, true), gettype($optionCost)), __LINE__);
        }
        $this->OptionCost = $optionCost;
        return $this;
    }
    /**
     * Get OptionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionName()
    {
        return isset($this->OptionName) ? $this->OptionName : null;
    }
    /**
     * Set OptionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionName
     * @return \StructType\SecureWebService_ImportQuoteOption
     */
    public function setOptionName($optionName = null)
    {
        // validation for constraint: string
        if (!is_null($optionName) && !is_string($optionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionName, true), gettype($optionName)), __LINE__);
        }
        if (is_null($optionName) || (is_array($optionName) && empty($optionName))) {
            unset($this->OptionName);
        } else {
            $this->OptionName = $optionName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecureWebService_ImportQuoteOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
