<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordQueueEntry StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RecordQueueEntry
 * @subpackage Structs
 */
class RecordQueueEntry extends AbstractStructBase
{
    /**
     * The AssignedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignedTime;
    /**
     * The AssignedUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignedUserId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The CustomData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomData;
    /**
     * The EntryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntryId;
    /**
     * The EntryOpenTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntryOpenTime;
    /**
     * The EntryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntryType;
    /**
     * The RecordQueueEntryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordQueueEntryId;
    /**
     * The RecordQueueId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordQueueId;
    /**
     * Constructor method for RecordQueueEntry
     * @uses RecordQueueEntry::setAssignedTime()
     * @uses RecordQueueEntry::setAssignedUserId()
     * @uses RecordQueueEntry::setCreateDate()
     * @uses RecordQueueEntry::setCreateUserId()
     * @uses RecordQueueEntry::setCustomData()
     * @uses RecordQueueEntry::setEntryId()
     * @uses RecordQueueEntry::setEntryOpenTime()
     * @uses RecordQueueEntry::setEntryType()
     * @uses RecordQueueEntry::setRecordQueueEntryId()
     * @uses RecordQueueEntry::setRecordQueueId()
     * @param string $assignedTime
     * @param string $assignedUserId
     * @param string $createDate
     * @param string $createUserId
     * @param string $customData
     * @param int $entryId
     * @param string $entryOpenTime
     * @param string $entryType
     * @param int $recordQueueEntryId
     * @param int $recordQueueId
     */
    public function __construct($assignedTime = null, $assignedUserId = null, $createDate = null, $createUserId = null, $customData = null, $entryId = null, $entryOpenTime = null, $entryType = null, $recordQueueEntryId = null, $recordQueueId = null)
    {
        $this
            ->setAssignedTime($assignedTime)
            ->setAssignedUserId($assignedUserId)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setCustomData($customData)
            ->setEntryId($entryId)
            ->setEntryOpenTime($entryOpenTime)
            ->setEntryType($entryType)
            ->setRecordQueueEntryId($recordQueueEntryId)
            ->setRecordQueueId($recordQueueId);
    }
    /**
     * Get AssignedTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedTime()
    {
        return isset($this->AssignedTime) ? $this->AssignedTime : null;
    }
    /**
     * Set AssignedTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedTime
     * @return \StructType\RecordQueueEntry
     */
    public function setAssignedTime($assignedTime = null)
    {
        // validation for constraint: string
        if (!is_null($assignedTime) && !is_string($assignedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedTime, true), gettype($assignedTime)), __LINE__);
        }
        if (is_null($assignedTime) || (is_array($assignedTime) && empty($assignedTime))) {
            unset($this->AssignedTime);
        } else {
            $this->AssignedTime = $assignedTime;
        }
        return $this;
    }
    /**
     * Get AssignedUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedUserId()
    {
        return isset($this->AssignedUserId) ? $this->AssignedUserId : null;
    }
    /**
     * Set AssignedUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedUserId
     * @return \StructType\RecordQueueEntry
     */
    public function setAssignedUserId($assignedUserId = null)
    {
        // validation for constraint: string
        if (!is_null($assignedUserId) && !is_string($assignedUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedUserId, true), gettype($assignedUserId)), __LINE__);
        }
        if (is_null($assignedUserId) || (is_array($assignedUserId) && empty($assignedUserId))) {
            unset($this->AssignedUserId);
        } else {
            $this->AssignedUserId = $assignedUserId;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\RecordQueueEntry
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\RecordQueueEntry
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get CustomData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomData()
    {
        return isset($this->CustomData) ? $this->CustomData : null;
    }
    /**
     * Set CustomData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customData
     * @return \StructType\RecordQueueEntry
     */
    public function setCustomData($customData = null)
    {
        // validation for constraint: string
        if (!is_null($customData) && !is_string($customData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customData, true), gettype($customData)), __LINE__);
        }
        if (is_null($customData) || (is_array($customData) && empty($customData))) {
            unset($this->CustomData);
        } else {
            $this->CustomData = $customData;
        }
        return $this;
    }
    /**
     * Get EntryId value
     * @return int|null
     */
    public function getEntryId()
    {
        return $this->EntryId;
    }
    /**
     * Set EntryId value
     * @param int $entryId
     * @return \StructType\RecordQueueEntry
     */
    public function setEntryId($entryId = null)
    {
        // validation for constraint: int
        if (!is_null($entryId) && !(is_int($entryId) || ctype_digit($entryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entryId, true), gettype($entryId)), __LINE__);
        }
        $this->EntryId = $entryId;
        return $this;
    }
    /**
     * Get EntryOpenTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntryOpenTime()
    {
        return isset($this->EntryOpenTime) ? $this->EntryOpenTime : null;
    }
    /**
     * Set EntryOpenTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entryOpenTime
     * @return \StructType\RecordQueueEntry
     */
    public function setEntryOpenTime($entryOpenTime = null)
    {
        // validation for constraint: string
        if (!is_null($entryOpenTime) && !is_string($entryOpenTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryOpenTime, true), gettype($entryOpenTime)), __LINE__);
        }
        if (is_null($entryOpenTime) || (is_array($entryOpenTime) && empty($entryOpenTime))) {
            unset($this->EntryOpenTime);
        } else {
            $this->EntryOpenTime = $entryOpenTime;
        }
        return $this;
    }
    /**
     * Get EntryType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntryType()
    {
        return isset($this->EntryType) ? $this->EntryType : null;
    }
    /**
     * Set EntryType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entryType
     * @return \StructType\RecordQueueEntry
     */
    public function setEntryType($entryType = null)
    {
        // validation for constraint: string
        if (!is_null($entryType) && !is_string($entryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryType, true), gettype($entryType)), __LINE__);
        }
        if (is_null($entryType) || (is_array($entryType) && empty($entryType))) {
            unset($this->EntryType);
        } else {
            $this->EntryType = $entryType;
        }
        return $this;
    }
    /**
     * Get RecordQueueEntryId value
     * @return int|null
     */
    public function getRecordQueueEntryId()
    {
        return $this->RecordQueueEntryId;
    }
    /**
     * Set RecordQueueEntryId value
     * @param int $recordQueueEntryId
     * @return \StructType\RecordQueueEntry
     */
    public function setRecordQueueEntryId($recordQueueEntryId = null)
    {
        // validation for constraint: int
        if (!is_null($recordQueueEntryId) && !(is_int($recordQueueEntryId) || ctype_digit($recordQueueEntryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordQueueEntryId, true), gettype($recordQueueEntryId)), __LINE__);
        }
        $this->RecordQueueEntryId = $recordQueueEntryId;
        return $this;
    }
    /**
     * Get RecordQueueId value
     * @return int|null
     */
    public function getRecordQueueId()
    {
        return $this->RecordQueueId;
    }
    /**
     * Set RecordQueueId value
     * @param int $recordQueueId
     * @return \StructType\RecordQueueEntry
     */
    public function setRecordQueueId($recordQueueId = null)
    {
        // validation for constraint: int
        if (!is_null($recordQueueId) && !(is_int($recordQueueId) || ctype_digit($recordQueueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordQueueId, true), gettype($recordQueueId)), __LINE__);
        }
        $this->RecordQueueId = $recordQueueId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecordQueueEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
