<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Quote
 * @subpackage Structs
 */
class Quote extends AbstractStructBase
{
    /**
     * The AdminAgentCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdminAgentCommission;
    /**
     * The AdminBaseSupplement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdminBaseSupplement;
    /**
     * The AffiliateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AffiliateId;
    /**
     * The BasePremiumPlusTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BasePremiumPlusTax;
    /**
     * The CampaignFixedMarkupAdj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CampaignFixedMarkupAdj;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CampaignId;
    /**
     * The ClassCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClassCode;
    /**
     * The ClassSurcharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ClassSurcharge;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContactId;
    /**
     * The CoverageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CoverageId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The Deductible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Deductible;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DownPaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DownPaymentAmount;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeRateCode;
    /**
     * The ExchangeRateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * The ExchangeRateLocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExchangeRateLocked;
    /**
     * The FinanceAPR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FinanceAPR;
    /**
     * The FinanceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FinanceAmount;
    /**
     * The FinanceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FinanceCharge;
    /**
     * The FinancePaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FinancePaymentAmount;
    /**
     * The FinancePaymentMethodId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FinancePaymentMethodId;
    /**
     * The FinancePaymentSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinancePaymentSource;
    /**
     * The FinanceStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinanceStartDate;
    /**
     * The FinanceTerm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FinanceTerm;
    /**
     * The FixedMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FixedMarkup;
    /**
     * The GrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GrossProfit;
    /**
     * The LeadSourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LeadSourceId;
    /**
     * The MarketerSettingId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MarketerSettingId;
    /**
     * The ModelYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ModelYear;
    /**
     * The NewOrUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewOrUsed;
    /**
     * The OptionCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OptionCost;
    /**
     * The OptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptionList;
    /**
     * The OverrideUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverrideUserId;
    /**
     * The Premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Premium;
    /**
     * The PremiumPlusTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PremiumPlusTax;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuoteId;
    /**
     * The RateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RateCode;
    /**
     * The RateCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RateCost;
    /**
     * The RateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateDate;
    /**
     * The RateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RateId;
    /**
     * The RateTermMiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RateTermMiles;
    /**
     * The RateTermMonths
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RateTermMonths;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The ReverseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReverseDate;
    /**
     * The ReverseReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReverseReason;
    /**
     * The ReversedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReversedBy;
    /**
     * The ReversedEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReversedEffectiveDate;
    /**
     * The SecondUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondUserId;
    /**
     * The ShowInPortal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShowInPortal;
    /**
     * The StateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateProvince;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SurchargeCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SurchargeCost;
    /**
     * The SurchargeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SurchargeList;
    /**
     * The SystemCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SystemCharge;
    /**
     * The TargetResponseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TargetResponseId;
    /**
     * The TargetStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetStartDate;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxRate;
    /**
     * The ThirdUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThirdUserId;
    /**
     * The TotalRateCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalRateCost;
    /**
     * The VariableMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkup;
    /**
     * The VehicleClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VehicleClass;
    /**
     * The VehicleEndOdometer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleEndOdometer;
    /**
     * The VehicleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleId;
    /**
     * The VehicleOdometer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleOdometer;
    /**
     * The VehicleTrimId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VehicleTrimId;
    /**
     * The VehicleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VehicleType;
    /**
     * The VinVerified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VinVerified;
    /**
     * The WaitingPeriodDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WaitingPeriodDays;
    /**
     * The WaitingPeriodMiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WaitingPeriodMiles;
    /**
     * Constructor method for Quote
     * @uses Quote::setAdminAgentCommission()
     * @uses Quote::setAdminBaseSupplement()
     * @uses Quote::setAffiliateId()
     * @uses Quote::setBasePremiumPlusTax()
     * @uses Quote::setCampaignFixedMarkupAdj()
     * @uses Quote::setCampaignId()
     * @uses Quote::setClassCode()
     * @uses Quote::setClassSurcharge()
     * @uses Quote::setContactId()
     * @uses Quote::setCoverageId()
     * @uses Quote::setCreateDate()
     * @uses Quote::setCreateUserId()
     * @uses Quote::setDeductible()
     * @uses Quote::setDescription()
     * @uses Quote::setDownPaymentAmount()
     * @uses Quote::setExchangeRate()
     * @uses Quote::setExchangeRateCode()
     * @uses Quote::setExchangeRateDate()
     * @uses Quote::setExchangeRateLocked()
     * @uses Quote::setFinanceAPR()
     * @uses Quote::setFinanceAmount()
     * @uses Quote::setFinanceCharge()
     * @uses Quote::setFinancePaymentAmount()
     * @uses Quote::setFinancePaymentMethodId()
     * @uses Quote::setFinancePaymentSource()
     * @uses Quote::setFinanceStartDate()
     * @uses Quote::setFinanceTerm()
     * @uses Quote::setFixedMarkup()
     * @uses Quote::setGrossProfit()
     * @uses Quote::setLeadSourceId()
     * @uses Quote::setMarketerSettingId()
     * @uses Quote::setModelYear()
     * @uses Quote::setNewOrUsed()
     * @uses Quote::setOptionCost()
     * @uses Quote::setOptionList()
     * @uses Quote::setOverrideUserId()
     * @uses Quote::setPremium()
     * @uses Quote::setPremiumPlusTax()
     * @uses Quote::setProductId()
     * @uses Quote::setQuoteId()
     * @uses Quote::setRateCode()
     * @uses Quote::setRateCost()
     * @uses Quote::setRateDate()
     * @uses Quote::setRateId()
     * @uses Quote::setRateTermMiles()
     * @uses Quote::setRateTermMonths()
     * @uses Quote::setResponseCode()
     * @uses Quote::setReverseDate()
     * @uses Quote::setReverseReason()
     * @uses Quote::setReversedBy()
     * @uses Quote::setReversedEffectiveDate()
     * @uses Quote::setSecondUserId()
     * @uses Quote::setShowInPortal()
     * @uses Quote::setStateProvince()
     * @uses Quote::setStatus()
     * @uses Quote::setSurchargeCost()
     * @uses Quote::setSurchargeList()
     * @uses Quote::setSystemCharge()
     * @uses Quote::setTargetResponseId()
     * @uses Quote::setTargetStartDate()
     * @uses Quote::setTaxAmount()
     * @uses Quote::setTaxRate()
     * @uses Quote::setThirdUserId()
     * @uses Quote::setTotalRateCost()
     * @uses Quote::setVariableMarkup()
     * @uses Quote::setVehicleClass()
     * @uses Quote::setVehicleEndOdometer()
     * @uses Quote::setVehicleId()
     * @uses Quote::setVehicleOdometer()
     * @uses Quote::setVehicleTrimId()
     * @uses Quote::setVehicleType()
     * @uses Quote::setVinVerified()
     * @uses Quote::setWaitingPeriodDays()
     * @uses Quote::setWaitingPeriodMiles()
     * @param float $adminAgentCommission
     * @param float $adminBaseSupplement
     * @param int $affiliateId
     * @param float $basePremiumPlusTax
     * @param float $campaignFixedMarkupAdj
     * @param int $campaignId
     * @param string $classCode
     * @param float $classSurcharge
     * @param int $contactId
     * @param int $coverageId
     * @param string $createDate
     * @param string $createUserId
     * @param float $deductible
     * @param string $description
     * @param float $downPaymentAmount
     * @param float $exchangeRate
     * @param string $exchangeRateCode
     * @param string $exchangeRateDate
     * @param bool $exchangeRateLocked
     * @param float $financeAPR
     * @param float $financeAmount
     * @param float $financeCharge
     * @param float $financePaymentAmount
     * @param int $financePaymentMethodId
     * @param string $financePaymentSource
     * @param string $financeStartDate
     * @param int $financeTerm
     * @param float $fixedMarkup
     * @param float $grossProfit
     * @param int $leadSourceId
     * @param int $marketerSettingId
     * @param int $modelYear
     * @param string $newOrUsed
     * @param float $optionCost
     * @param string $optionList
     * @param string $overrideUserId
     * @param float $premium
     * @param float $premiumPlusTax
     * @param int $productId
     * @param int $quoteId
     * @param string $rateCode
     * @param float $rateCost
     * @param string $rateDate
     * @param int $rateId
     * @param int $rateTermMiles
     * @param int $rateTermMonths
     * @param string $responseCode
     * @param string $reverseDate
     * @param string $reverseReason
     * @param string $reversedBy
     * @param string $reversedEffectiveDate
     * @param string $secondUserId
     * @param bool $showInPortal
     * @param string $stateProvince
     * @param string $status
     * @param float $surchargeCost
     * @param string $surchargeList
     * @param float $systemCharge
     * @param int $targetResponseId
     * @param string $targetStartDate
     * @param float $taxAmount
     * @param float $taxRate
     * @param string $thirdUserId
     * @param float $totalRateCost
     * @param float $variableMarkup
     * @param string $vehicleClass
     * @param int $vehicleEndOdometer
     * @param int $vehicleId
     * @param int $vehicleOdometer
     * @param int $vehicleTrimId
     * @param string $vehicleType
     * @param bool $vinVerified
     * @param int $waitingPeriodDays
     * @param int $waitingPeriodMiles
     */
    public function __construct($adminAgentCommission = null, $adminBaseSupplement = null, $affiliateId = null, $basePremiumPlusTax = null, $campaignFixedMarkupAdj = null, $campaignId = null, $classCode = null, $classSurcharge = null, $contactId = null, $coverageId = null, $createDate = null, $createUserId = null, $deductible = null, $description = null, $downPaymentAmount = null, $exchangeRate = null, $exchangeRateCode = null, $exchangeRateDate = null, $exchangeRateLocked = null, $financeAPR = null, $financeAmount = null, $financeCharge = null, $financePaymentAmount = null, $financePaymentMethodId = null, $financePaymentSource = null, $financeStartDate = null, $financeTerm = null, $fixedMarkup = null, $grossProfit = null, $leadSourceId = null, $marketerSettingId = null, $modelYear = null, $newOrUsed = null, $optionCost = null, $optionList = null, $overrideUserId = null, $premium = null, $premiumPlusTax = null, $productId = null, $quoteId = null, $rateCode = null, $rateCost = null, $rateDate = null, $rateId = null, $rateTermMiles = null, $rateTermMonths = null, $responseCode = null, $reverseDate = null, $reverseReason = null, $reversedBy = null, $reversedEffectiveDate = null, $secondUserId = null, $showInPortal = null, $stateProvince = null, $status = null, $surchargeCost = null, $surchargeList = null, $systemCharge = null, $targetResponseId = null, $targetStartDate = null, $taxAmount = null, $taxRate = null, $thirdUserId = null, $totalRateCost = null, $variableMarkup = null, $vehicleClass = null, $vehicleEndOdometer = null, $vehicleId = null, $vehicleOdometer = null, $vehicleTrimId = null, $vehicleType = null, $vinVerified = null, $waitingPeriodDays = null, $waitingPeriodMiles = null)
    {
        $this
            ->setAdminAgentCommission($adminAgentCommission)
            ->setAdminBaseSupplement($adminBaseSupplement)
            ->setAffiliateId($affiliateId)
            ->setBasePremiumPlusTax($basePremiumPlusTax)
            ->setCampaignFixedMarkupAdj($campaignFixedMarkupAdj)
            ->setCampaignId($campaignId)
            ->setClassCode($classCode)
            ->setClassSurcharge($classSurcharge)
            ->setContactId($contactId)
            ->setCoverageId($coverageId)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setDeductible($deductible)
            ->setDescription($description)
            ->setDownPaymentAmount($downPaymentAmount)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateCode($exchangeRateCode)
            ->setExchangeRateDate($exchangeRateDate)
            ->setExchangeRateLocked($exchangeRateLocked)
            ->setFinanceAPR($financeAPR)
            ->setFinanceAmount($financeAmount)
            ->setFinanceCharge($financeCharge)
            ->setFinancePaymentAmount($financePaymentAmount)
            ->setFinancePaymentMethodId($financePaymentMethodId)
            ->setFinancePaymentSource($financePaymentSource)
            ->setFinanceStartDate($financeStartDate)
            ->setFinanceTerm($financeTerm)
            ->setFixedMarkup($fixedMarkup)
            ->setGrossProfit($grossProfit)
            ->setLeadSourceId($leadSourceId)
            ->setMarketerSettingId($marketerSettingId)
            ->setModelYear($modelYear)
            ->setNewOrUsed($newOrUsed)
            ->setOptionCost($optionCost)
            ->setOptionList($optionList)
            ->setOverrideUserId($overrideUserId)
            ->setPremium($premium)
            ->setPremiumPlusTax($premiumPlusTax)
            ->setProductId($productId)
            ->setQuoteId($quoteId)
            ->setRateCode($rateCode)
            ->setRateCost($rateCost)
            ->setRateDate($rateDate)
            ->setRateId($rateId)
            ->setRateTermMiles($rateTermMiles)
            ->setRateTermMonths($rateTermMonths)
            ->setResponseCode($responseCode)
            ->setReverseDate($reverseDate)
            ->setReverseReason($reverseReason)
            ->setReversedBy($reversedBy)
            ->setReversedEffectiveDate($reversedEffectiveDate)
            ->setSecondUserId($secondUserId)
            ->setShowInPortal($showInPortal)
            ->setStateProvince($stateProvince)
            ->setStatus($status)
            ->setSurchargeCost($surchargeCost)
            ->setSurchargeList($surchargeList)
            ->setSystemCharge($systemCharge)
            ->setTargetResponseId($targetResponseId)
            ->setTargetStartDate($targetStartDate)
            ->setTaxAmount($taxAmount)
            ->setTaxRate($taxRate)
            ->setThirdUserId($thirdUserId)
            ->setTotalRateCost($totalRateCost)
            ->setVariableMarkup($variableMarkup)
            ->setVehicleClass($vehicleClass)
            ->setVehicleEndOdometer($vehicleEndOdometer)
            ->setVehicleId($vehicleId)
            ->setVehicleOdometer($vehicleOdometer)
            ->setVehicleTrimId($vehicleTrimId)
            ->setVehicleType($vehicleType)
            ->setVinVerified($vinVerified)
            ->setWaitingPeriodDays($waitingPeriodDays)
            ->setWaitingPeriodMiles($waitingPeriodMiles);
    }
    /**
     * Get AdminAgentCommission value
     * @return float|null
     */
    public function getAdminAgentCommission()
    {
        return $this->AdminAgentCommission;
    }
    /**
     * Set AdminAgentCommission value
     * @param float $adminAgentCommission
     * @return \StructType\Quote
     */
    public function setAdminAgentCommission($adminAgentCommission = null)
    {
        // validation for constraint: float
        if (!is_null($adminAgentCommission) && !(is_float($adminAgentCommission) || is_numeric($adminAgentCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adminAgentCommission, true), gettype($adminAgentCommission)), __LINE__);
        }
        $this->AdminAgentCommission = $adminAgentCommission;
        return $this;
    }
    /**
     * Get AdminBaseSupplement value
     * @return float|null
     */
    public function getAdminBaseSupplement()
    {
        return $this->AdminBaseSupplement;
    }
    /**
     * Set AdminBaseSupplement value
     * @param float $adminBaseSupplement
     * @return \StructType\Quote
     */
    public function setAdminBaseSupplement($adminBaseSupplement = null)
    {
        // validation for constraint: float
        if (!is_null($adminBaseSupplement) && !(is_float($adminBaseSupplement) || is_numeric($adminBaseSupplement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adminBaseSupplement, true), gettype($adminBaseSupplement)), __LINE__);
        }
        $this->AdminBaseSupplement = $adminBaseSupplement;
        return $this;
    }
    /**
     * Get AffiliateId value
     * @return int|null
     */
    public function getAffiliateId()
    {
        return $this->AffiliateId;
    }
    /**
     * Set AffiliateId value
     * @param int $affiliateId
     * @return \StructType\Quote
     */
    public function setAffiliateId($affiliateId = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateId) && !(is_int($affiliateId) || ctype_digit($affiliateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateId, true), gettype($affiliateId)), __LINE__);
        }
        $this->AffiliateId = $affiliateId;
        return $this;
    }
    /**
     * Get BasePremiumPlusTax value
     * @return float|null
     */
    public function getBasePremiumPlusTax()
    {
        return $this->BasePremiumPlusTax;
    }
    /**
     * Set BasePremiumPlusTax value
     * @param float $basePremiumPlusTax
     * @return \StructType\Quote
     */
    public function setBasePremiumPlusTax($basePremiumPlusTax = null)
    {
        // validation for constraint: float
        if (!is_null($basePremiumPlusTax) && !(is_float($basePremiumPlusTax) || is_numeric($basePremiumPlusTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePremiumPlusTax, true), gettype($basePremiumPlusTax)), __LINE__);
        }
        $this->BasePremiumPlusTax = $basePremiumPlusTax;
        return $this;
    }
    /**
     * Get CampaignFixedMarkupAdj value
     * @return float|null
     */
    public function getCampaignFixedMarkupAdj()
    {
        return $this->CampaignFixedMarkupAdj;
    }
    /**
     * Set CampaignFixedMarkupAdj value
     * @param float $campaignFixedMarkupAdj
     * @return \StructType\Quote
     */
    public function setCampaignFixedMarkupAdj($campaignFixedMarkupAdj = null)
    {
        // validation for constraint: float
        if (!is_null($campaignFixedMarkupAdj) && !(is_float($campaignFixedMarkupAdj) || is_numeric($campaignFixedMarkupAdj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($campaignFixedMarkupAdj, true), gettype($campaignFixedMarkupAdj)), __LINE__);
        }
        $this->CampaignFixedMarkupAdj = $campaignFixedMarkupAdj;
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $campaignId
     * @return \StructType\Quote
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassCode()
    {
        return isset($this->ClassCode) ? $this->ClassCode : null;
    }
    /**
     * Set ClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classCode
     * @return \StructType\Quote
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: string
        if (!is_null($classCode) && !is_string($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classCode, true), gettype($classCode)), __LINE__);
        }
        if (is_null($classCode) || (is_array($classCode) && empty($classCode))) {
            unset($this->ClassCode);
        } else {
            $this->ClassCode = $classCode;
        }
        return $this;
    }
    /**
     * Get ClassSurcharge value
     * @return float|null
     */
    public function getClassSurcharge()
    {
        return $this->ClassSurcharge;
    }
    /**
     * Set ClassSurcharge value
     * @param float $classSurcharge
     * @return \StructType\Quote
     */
    public function setClassSurcharge($classSurcharge = null)
    {
        // validation for constraint: float
        if (!is_null($classSurcharge) && !(is_float($classSurcharge) || is_numeric($classSurcharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($classSurcharge, true), gettype($classSurcharge)), __LINE__);
        }
        $this->ClassSurcharge = $classSurcharge;
        return $this;
    }
    /**
     * Get ContactId value
     * @return int|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param int $contactId
     * @return \StructType\Quote
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get CoverageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCoverageId()
    {
        return isset($this->CoverageId) ? $this->CoverageId : null;
    }
    /**
     * Set CoverageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $coverageId
     * @return \StructType\Quote
     */
    public function setCoverageId($coverageId = null)
    {
        // validation for constraint: int
        if (!is_null($coverageId) && !(is_int($coverageId) || ctype_digit($coverageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coverageId, true), gettype($coverageId)), __LINE__);
        }
        if (is_null($coverageId) || (is_array($coverageId) && empty($coverageId))) {
            unset($this->CoverageId);
        } else {
            $this->CoverageId = $coverageId;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Quote
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\Quote
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get Deductible value
     * @return float|null
     */
    public function getDeductible()
    {
        return $this->Deductible;
    }
    /**
     * Set Deductible value
     * @param float $deductible
     * @return \StructType\Quote
     */
    public function setDeductible($deductible = null)
    {
        // validation for constraint: float
        if (!is_null($deductible) && !(is_float($deductible) || is_numeric($deductible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deductible, true), gettype($deductible)), __LINE__);
        }
        $this->Deductible = $deductible;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Quote
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DownPaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDownPaymentAmount()
    {
        return isset($this->DownPaymentAmount) ? $this->DownPaymentAmount : null;
    }
    /**
     * Set DownPaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $downPaymentAmount
     * @return \StructType\Quote
     */
    public function setDownPaymentAmount($downPaymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($downPaymentAmount) && !(is_float($downPaymentAmount) || is_numeric($downPaymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($downPaymentAmount, true), gettype($downPaymentAmount)), __LINE__);
        }
        if (is_null($downPaymentAmount) || (is_array($downPaymentAmount) && empty($downPaymentAmount))) {
            unset($this->DownPaymentAmount);
        } else {
            $this->DownPaymentAmount = $downPaymentAmount;
        }
        return $this;
    }
    /**
     * Get ExchangeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExchangeRate()
    {
        return isset($this->ExchangeRate) ? $this->ExchangeRate : null;
    }
    /**
     * Set ExchangeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $exchangeRate
     * @return \StructType\Quote
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        if (is_null($exchangeRate) || (is_array($exchangeRate) && empty($exchangeRate))) {
            unset($this->ExchangeRate);
        } else {
            $this->ExchangeRate = $exchangeRate;
        }
        return $this;
    }
    /**
     * Get ExchangeRateCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeRateCode()
    {
        return isset($this->ExchangeRateCode) ? $this->ExchangeRateCode : null;
    }
    /**
     * Set ExchangeRateCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeRateCode
     * @return \StructType\Quote
     */
    public function setExchangeRateCode($exchangeRateCode = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateCode) && !is_string($exchangeRateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateCode, true), gettype($exchangeRateCode)), __LINE__);
        }
        if (is_null($exchangeRateCode) || (is_array($exchangeRateCode) && empty($exchangeRateCode))) {
            unset($this->ExchangeRateCode);
        } else {
            $this->ExchangeRateCode = $exchangeRateCode;
        }
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return isset($this->ExchangeRateDate) ? $this->ExchangeRateDate : null;
    }
    /**
     * Set ExchangeRateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeRateDate
     * @return \StructType\Quote
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        if (is_null($exchangeRateDate) || (is_array($exchangeRateDate) && empty($exchangeRateDate))) {
            unset($this->ExchangeRateDate);
        } else {
            $this->ExchangeRateDate = $exchangeRateDate;
        }
        return $this;
    }
    /**
     * Get ExchangeRateLocked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExchangeRateLocked()
    {
        return isset($this->ExchangeRateLocked) ? $this->ExchangeRateLocked : null;
    }
    /**
     * Set ExchangeRateLocked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exchangeRateLocked
     * @return \StructType\Quote
     */
    public function setExchangeRateLocked($exchangeRateLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchangeRateLocked) && !is_bool($exchangeRateLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchangeRateLocked, true), gettype($exchangeRateLocked)), __LINE__);
        }
        if (is_null($exchangeRateLocked) || (is_array($exchangeRateLocked) && empty($exchangeRateLocked))) {
            unset($this->ExchangeRateLocked);
        } else {
            $this->ExchangeRateLocked = $exchangeRateLocked;
        }
        return $this;
    }
    /**
     * Get FinanceAPR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFinanceAPR()
    {
        return isset($this->FinanceAPR) ? $this->FinanceAPR : null;
    }
    /**
     * Set FinanceAPR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $financeAPR
     * @return \StructType\Quote
     */
    public function setFinanceAPR($financeAPR = null)
    {
        // validation for constraint: float
        if (!is_null($financeAPR) && !(is_float($financeAPR) || is_numeric($financeAPR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($financeAPR, true), gettype($financeAPR)), __LINE__);
        }
        if (is_null($financeAPR) || (is_array($financeAPR) && empty($financeAPR))) {
            unset($this->FinanceAPR);
        } else {
            $this->FinanceAPR = $financeAPR;
        }
        return $this;
    }
    /**
     * Get FinanceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFinanceAmount()
    {
        return isset($this->FinanceAmount) ? $this->FinanceAmount : null;
    }
    /**
     * Set FinanceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $financeAmount
     * @return \StructType\Quote
     */
    public function setFinanceAmount($financeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($financeAmount) && !(is_float($financeAmount) || is_numeric($financeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($financeAmount, true), gettype($financeAmount)), __LINE__);
        }
        if (is_null($financeAmount) || (is_array($financeAmount) && empty($financeAmount))) {
            unset($this->FinanceAmount);
        } else {
            $this->FinanceAmount = $financeAmount;
        }
        return $this;
    }
    /**
     * Get FinanceCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFinanceCharge()
    {
        return isset($this->FinanceCharge) ? $this->FinanceCharge : null;
    }
    /**
     * Set FinanceCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $financeCharge
     * @return \StructType\Quote
     */
    public function setFinanceCharge($financeCharge = null)
    {
        // validation for constraint: float
        if (!is_null($financeCharge) && !(is_float($financeCharge) || is_numeric($financeCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($financeCharge, true), gettype($financeCharge)), __LINE__);
        }
        if (is_null($financeCharge) || (is_array($financeCharge) && empty($financeCharge))) {
            unset($this->FinanceCharge);
        } else {
            $this->FinanceCharge = $financeCharge;
        }
        return $this;
    }
    /**
     * Get FinancePaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFinancePaymentAmount()
    {
        return isset($this->FinancePaymentAmount) ? $this->FinancePaymentAmount : null;
    }
    /**
     * Set FinancePaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $financePaymentAmount
     * @return \StructType\Quote
     */
    public function setFinancePaymentAmount($financePaymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($financePaymentAmount) && !(is_float($financePaymentAmount) || is_numeric($financePaymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($financePaymentAmount, true), gettype($financePaymentAmount)), __LINE__);
        }
        if (is_null($financePaymentAmount) || (is_array($financePaymentAmount) && empty($financePaymentAmount))) {
            unset($this->FinancePaymentAmount);
        } else {
            $this->FinancePaymentAmount = $financePaymentAmount;
        }
        return $this;
    }
    /**
     * Get FinancePaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFinancePaymentMethodId()
    {
        return isset($this->FinancePaymentMethodId) ? $this->FinancePaymentMethodId : null;
    }
    /**
     * Set FinancePaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $financePaymentMethodId
     * @return \StructType\Quote
     */
    public function setFinancePaymentMethodId($financePaymentMethodId = null)
    {
        // validation for constraint: int
        if (!is_null($financePaymentMethodId) && !(is_int($financePaymentMethodId) || ctype_digit($financePaymentMethodId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($financePaymentMethodId, true), gettype($financePaymentMethodId)), __LINE__);
        }
        if (is_null($financePaymentMethodId) || (is_array($financePaymentMethodId) && empty($financePaymentMethodId))) {
            unset($this->FinancePaymentMethodId);
        } else {
            $this->FinancePaymentMethodId = $financePaymentMethodId;
        }
        return $this;
    }
    /**
     * Get FinancePaymentSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinancePaymentSource()
    {
        return isset($this->FinancePaymentSource) ? $this->FinancePaymentSource : null;
    }
    /**
     * Set FinancePaymentSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $financePaymentSource
     * @return \StructType\Quote
     */
    public function setFinancePaymentSource($financePaymentSource = null)
    {
        // validation for constraint: string
        if (!is_null($financePaymentSource) && !is_string($financePaymentSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financePaymentSource, true), gettype($financePaymentSource)), __LINE__);
        }
        if (is_null($financePaymentSource) || (is_array($financePaymentSource) && empty($financePaymentSource))) {
            unset($this->FinancePaymentSource);
        } else {
            $this->FinancePaymentSource = $financePaymentSource;
        }
        return $this;
    }
    /**
     * Get FinanceStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinanceStartDate()
    {
        return isset($this->FinanceStartDate) ? $this->FinanceStartDate : null;
    }
    /**
     * Set FinanceStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $financeStartDate
     * @return \StructType\Quote
     */
    public function setFinanceStartDate($financeStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($financeStartDate) && !is_string($financeStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financeStartDate, true), gettype($financeStartDate)), __LINE__);
        }
        if (is_null($financeStartDate) || (is_array($financeStartDate) && empty($financeStartDate))) {
            unset($this->FinanceStartDate);
        } else {
            $this->FinanceStartDate = $financeStartDate;
        }
        return $this;
    }
    /**
     * Get FinanceTerm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFinanceTerm()
    {
        return isset($this->FinanceTerm) ? $this->FinanceTerm : null;
    }
    /**
     * Set FinanceTerm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $financeTerm
     * @return \StructType\Quote
     */
    public function setFinanceTerm($financeTerm = null)
    {
        // validation for constraint: int
        if (!is_null($financeTerm) && !(is_int($financeTerm) || ctype_digit($financeTerm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($financeTerm, true), gettype($financeTerm)), __LINE__);
        }
        if (is_null($financeTerm) || (is_array($financeTerm) && empty($financeTerm))) {
            unset($this->FinanceTerm);
        } else {
            $this->FinanceTerm = $financeTerm;
        }
        return $this;
    }
    /**
     * Get FixedMarkup value
     * @return float|null
     */
    public function getFixedMarkup()
    {
        return $this->FixedMarkup;
    }
    /**
     * Set FixedMarkup value
     * @param float $fixedMarkup
     * @return \StructType\Quote
     */
    public function setFixedMarkup($fixedMarkup = null)
    {
        // validation for constraint: float
        if (!is_null($fixedMarkup) && !(is_float($fixedMarkup) || is_numeric($fixedMarkup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedMarkup, true), gettype($fixedMarkup)), __LINE__);
        }
        $this->FixedMarkup = $fixedMarkup;
        return $this;
    }
    /**
     * Get GrossProfit value
     * @return float|null
     */
    public function getGrossProfit()
    {
        return $this->GrossProfit;
    }
    /**
     * Set GrossProfit value
     * @param float $grossProfit
     * @return \StructType\Quote
     */
    public function setGrossProfit($grossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($grossProfit) && !(is_float($grossProfit) || is_numeric($grossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossProfit, true), gettype($grossProfit)), __LINE__);
        }
        $this->GrossProfit = $grossProfit;
        return $this;
    }
    /**
     * Get LeadSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeadSourceId()
    {
        return isset($this->LeadSourceId) ? $this->LeadSourceId : null;
    }
    /**
     * Set LeadSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leadSourceId
     * @return \StructType\Quote
     */
    public function setLeadSourceId($leadSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceId) && !(is_int($leadSourceId) || ctype_digit($leadSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadSourceId, true), gettype($leadSourceId)), __LINE__);
        }
        if (is_null($leadSourceId) || (is_array($leadSourceId) && empty($leadSourceId))) {
            unset($this->LeadSourceId);
        } else {
            $this->LeadSourceId = $leadSourceId;
        }
        return $this;
    }
    /**
     * Get MarketerSettingId value
     * @return int|null
     */
    public function getMarketerSettingId()
    {
        return $this->MarketerSettingId;
    }
    /**
     * Set MarketerSettingId value
     * @param int $marketerSettingId
     * @return \StructType\Quote
     */
    public function setMarketerSettingId($marketerSettingId = null)
    {
        // validation for constraint: int
        if (!is_null($marketerSettingId) && !(is_int($marketerSettingId) || ctype_digit($marketerSettingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($marketerSettingId, true), gettype($marketerSettingId)), __LINE__);
        }
        $this->MarketerSettingId = $marketerSettingId;
        return $this;
    }
    /**
     * Get ModelYear value
     * @return int|null
     */
    public function getModelYear()
    {
        return $this->ModelYear;
    }
    /**
     * Set ModelYear value
     * @param int $modelYear
     * @return \StructType\Quote
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->ModelYear = $modelYear;
        return $this;
    }
    /**
     * Get NewOrUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOrUsed()
    {
        return isset($this->NewOrUsed) ? $this->NewOrUsed : null;
    }
    /**
     * Set NewOrUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOrUsed
     * @return \StructType\Quote
     */
    public function setNewOrUsed($newOrUsed = null)
    {
        // validation for constraint: string
        if (!is_null($newOrUsed) && !is_string($newOrUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOrUsed, true), gettype($newOrUsed)), __LINE__);
        }
        if (is_null($newOrUsed) || (is_array($newOrUsed) && empty($newOrUsed))) {
            unset($this->NewOrUsed);
        } else {
            $this->NewOrUsed = $newOrUsed;
        }
        return $this;
    }
    /**
     * Get OptionCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOptionCost()
    {
        return isset($this->OptionCost) ? $this->OptionCost : null;
    }
    /**
     * Set OptionCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $optionCost
     * @return \StructType\Quote
     */
    public function setOptionCost($optionCost = null)
    {
        // validation for constraint: float
        if (!is_null($optionCost) && !(is_float($optionCost) || is_numeric($optionCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionCost, true), gettype($optionCost)), __LINE__);
        }
        if (is_null($optionCost) || (is_array($optionCost) && empty($optionCost))) {
            unset($this->OptionCost);
        } else {
            $this->OptionCost = $optionCost;
        }
        return $this;
    }
    /**
     * Get OptionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionList()
    {
        return isset($this->OptionList) ? $this->OptionList : null;
    }
    /**
     * Set OptionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionList
     * @return \StructType\Quote
     */
    public function setOptionList($optionList = null)
    {
        // validation for constraint: string
        if (!is_null($optionList) && !is_string($optionList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionList, true), gettype($optionList)), __LINE__);
        }
        if (is_null($optionList) || (is_array($optionList) && empty($optionList))) {
            unset($this->OptionList);
        } else {
            $this->OptionList = $optionList;
        }
        return $this;
    }
    /**
     * Get OverrideUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideUserId()
    {
        return isset($this->OverrideUserId) ? $this->OverrideUserId : null;
    }
    /**
     * Set OverrideUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideUserId
     * @return \StructType\Quote
     */
    public function setOverrideUserId($overrideUserId = null)
    {
        // validation for constraint: string
        if (!is_null($overrideUserId) && !is_string($overrideUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideUserId, true), gettype($overrideUserId)), __LINE__);
        }
        if (is_null($overrideUserId) || (is_array($overrideUserId) && empty($overrideUserId))) {
            unset($this->OverrideUserId);
        } else {
            $this->OverrideUserId = $overrideUserId;
        }
        return $this;
    }
    /**
     * Get Premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param float $premium
     * @return \StructType\Quote
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get PremiumPlusTax value
     * @return float|null
     */
    public function getPremiumPlusTax()
    {
        return $this->PremiumPlusTax;
    }
    /**
     * Set PremiumPlusTax value
     * @param float $premiumPlusTax
     * @return \StructType\Quote
     */
    public function setPremiumPlusTax($premiumPlusTax = null)
    {
        // validation for constraint: float
        if (!is_null($premiumPlusTax) && !(is_float($premiumPlusTax) || is_numeric($premiumPlusTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premiumPlusTax, true), gettype($premiumPlusTax)), __LINE__);
        }
        $this->PremiumPlusTax = $premiumPlusTax;
        return $this;
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\Quote
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get QuoteId value
     * @return int|null
     */
    public function getQuoteId()
    {
        return $this->QuoteId;
    }
    /**
     * Set QuoteId value
     * @param int $quoteId
     * @return \StructType\Quote
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !(is_int($quoteId) || ctype_digit($quoteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        $this->QuoteId = $quoteId;
        return $this;
    }
    /**
     * Get RateCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRateCode()
    {
        return isset($this->RateCode) ? $this->RateCode : null;
    }
    /**
     * Set RateCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rateCode
     * @return \StructType\Quote
     */
    public function setRateCode($rateCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateCode) && !is_string($rateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCode, true), gettype($rateCode)), __LINE__);
        }
        if (is_null($rateCode) || (is_array($rateCode) && empty($rateCode))) {
            unset($this->RateCode);
        } else {
            $this->RateCode = $rateCode;
        }
        return $this;
    }
    /**
     * Get RateCost value
     * @return float|null
     */
    public function getRateCost()
    {
        return $this->RateCost;
    }
    /**
     * Set RateCost value
     * @param float $rateCost
     * @return \StructType\Quote
     */
    public function setRateCost($rateCost = null)
    {
        // validation for constraint: float
        if (!is_null($rateCost) && !(is_float($rateCost) || is_numeric($rateCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateCost, true), gettype($rateCost)), __LINE__);
        }
        $this->RateCost = $rateCost;
        return $this;
    }
    /**
     * Get RateDate value
     * @return string|null
     */
    public function getRateDate()
    {
        return $this->RateDate;
    }
    /**
     * Set RateDate value
     * @param string $rateDate
     * @return \StructType\Quote
     */
    public function setRateDate($rateDate = null)
    {
        // validation for constraint: string
        if (!is_null($rateDate) && !is_string($rateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateDate, true), gettype($rateDate)), __LINE__);
        }
        $this->RateDate = $rateDate;
        return $this;
    }
    /**
     * Get RateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRateId()
    {
        return isset($this->RateId) ? $this->RateId : null;
    }
    /**
     * Set RateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rateId
     * @return \StructType\Quote
     */
    public function setRateId($rateId = null)
    {
        // validation for constraint: int
        if (!is_null($rateId) && !(is_int($rateId) || ctype_digit($rateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rateId, true), gettype($rateId)), __LINE__);
        }
        if (is_null($rateId) || (is_array($rateId) && empty($rateId))) {
            unset($this->RateId);
        } else {
            $this->RateId = $rateId;
        }
        return $this;
    }
    /**
     * Get RateTermMiles value
     * @return int|null
     */
    public function getRateTermMiles()
    {
        return $this->RateTermMiles;
    }
    /**
     * Set RateTermMiles value
     * @param int $rateTermMiles
     * @return \StructType\Quote
     */
    public function setRateTermMiles($rateTermMiles = null)
    {
        // validation for constraint: int
        if (!is_null($rateTermMiles) && !(is_int($rateTermMiles) || ctype_digit($rateTermMiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rateTermMiles, true), gettype($rateTermMiles)), __LINE__);
        }
        $this->RateTermMiles = $rateTermMiles;
        return $this;
    }
    /**
     * Get RateTermMonths value
     * @return int|null
     */
    public function getRateTermMonths()
    {
        return $this->RateTermMonths;
    }
    /**
     * Set RateTermMonths value
     * @param int $rateTermMonths
     * @return \StructType\Quote
     */
    public function setRateTermMonths($rateTermMonths = null)
    {
        // validation for constraint: int
        if (!is_null($rateTermMonths) && !(is_int($rateTermMonths) || ctype_digit($rateTermMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rateTermMonths, true), gettype($rateTermMonths)), __LINE__);
        }
        $this->RateTermMonths = $rateTermMonths;
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\Quote
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get ReverseDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReverseDate()
    {
        return isset($this->ReverseDate) ? $this->ReverseDate : null;
    }
    /**
     * Set ReverseDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reverseDate
     * @return \StructType\Quote
     */
    public function setReverseDate($reverseDate = null)
    {
        // validation for constraint: string
        if (!is_null($reverseDate) && !is_string($reverseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reverseDate, true), gettype($reverseDate)), __LINE__);
        }
        if (is_null($reverseDate) || (is_array($reverseDate) && empty($reverseDate))) {
            unset($this->ReverseDate);
        } else {
            $this->ReverseDate = $reverseDate;
        }
        return $this;
    }
    /**
     * Get ReverseReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReverseReason()
    {
        return isset($this->ReverseReason) ? $this->ReverseReason : null;
    }
    /**
     * Set ReverseReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reverseReason
     * @return \StructType\Quote
     */
    public function setReverseReason($reverseReason = null)
    {
        // validation for constraint: string
        if (!is_null($reverseReason) && !is_string($reverseReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reverseReason, true), gettype($reverseReason)), __LINE__);
        }
        if (is_null($reverseReason) || (is_array($reverseReason) && empty($reverseReason))) {
            unset($this->ReverseReason);
        } else {
            $this->ReverseReason = $reverseReason;
        }
        return $this;
    }
    /**
     * Get ReversedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReversedBy()
    {
        return isset($this->ReversedBy) ? $this->ReversedBy : null;
    }
    /**
     * Set ReversedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reversedBy
     * @return \StructType\Quote
     */
    public function setReversedBy($reversedBy = null)
    {
        // validation for constraint: string
        if (!is_null($reversedBy) && !is_string($reversedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reversedBy, true), gettype($reversedBy)), __LINE__);
        }
        if (is_null($reversedBy) || (is_array($reversedBy) && empty($reversedBy))) {
            unset($this->ReversedBy);
        } else {
            $this->ReversedBy = $reversedBy;
        }
        return $this;
    }
    /**
     * Get ReversedEffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReversedEffectiveDate()
    {
        return isset($this->ReversedEffectiveDate) ? $this->ReversedEffectiveDate : null;
    }
    /**
     * Set ReversedEffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reversedEffectiveDate
     * @return \StructType\Quote
     */
    public function setReversedEffectiveDate($reversedEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($reversedEffectiveDate) && !is_string($reversedEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reversedEffectiveDate, true), gettype($reversedEffectiveDate)), __LINE__);
        }
        if (is_null($reversedEffectiveDate) || (is_array($reversedEffectiveDate) && empty($reversedEffectiveDate))) {
            unset($this->ReversedEffectiveDate);
        } else {
            $this->ReversedEffectiveDate = $reversedEffectiveDate;
        }
        return $this;
    }
    /**
     * Get SecondUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondUserId()
    {
        return isset($this->SecondUserId) ? $this->SecondUserId : null;
    }
    /**
     * Set SecondUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondUserId
     * @return \StructType\Quote
     */
    public function setSecondUserId($secondUserId = null)
    {
        // validation for constraint: string
        if (!is_null($secondUserId) && !is_string($secondUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondUserId, true), gettype($secondUserId)), __LINE__);
        }
        if (is_null($secondUserId) || (is_array($secondUserId) && empty($secondUserId))) {
            unset($this->SecondUserId);
        } else {
            $this->SecondUserId = $secondUserId;
        }
        return $this;
    }
    /**
     * Get ShowInPortal value
     * @return bool|null
     */
    public function getShowInPortal()
    {
        return $this->ShowInPortal;
    }
    /**
     * Set ShowInPortal value
     * @param bool $showInPortal
     * @return \StructType\Quote
     */
    public function setShowInPortal($showInPortal = null)
    {
        // validation for constraint: boolean
        if (!is_null($showInPortal) && !is_bool($showInPortal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showInPortal, true), gettype($showInPortal)), __LINE__);
        }
        $this->ShowInPortal = $showInPortal;
        return $this;
    }
    /**
     * Get StateProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateProvince()
    {
        return isset($this->StateProvince) ? $this->StateProvince : null;
    }
    /**
     * Set StateProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateProvince
     * @return \StructType\Quote
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        if (is_null($stateProvince) || (is_array($stateProvince) && empty($stateProvince))) {
            unset($this->StateProvince);
        } else {
            $this->StateProvince = $stateProvince;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\Quote
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SurchargeCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSurchargeCost()
    {
        return isset($this->SurchargeCost) ? $this->SurchargeCost : null;
    }
    /**
     * Set SurchargeCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $surchargeCost
     * @return \StructType\Quote
     */
    public function setSurchargeCost($surchargeCost = null)
    {
        // validation for constraint: float
        if (!is_null($surchargeCost) && !(is_float($surchargeCost) || is_numeric($surchargeCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surchargeCost, true), gettype($surchargeCost)), __LINE__);
        }
        if (is_null($surchargeCost) || (is_array($surchargeCost) && empty($surchargeCost))) {
            unset($this->SurchargeCost);
        } else {
            $this->SurchargeCost = $surchargeCost;
        }
        return $this;
    }
    /**
     * Get SurchargeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSurchargeList()
    {
        return isset($this->SurchargeList) ? $this->SurchargeList : null;
    }
    /**
     * Set SurchargeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $surchargeList
     * @return \StructType\Quote
     */
    public function setSurchargeList($surchargeList = null)
    {
        // validation for constraint: string
        if (!is_null($surchargeList) && !is_string($surchargeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surchargeList, true), gettype($surchargeList)), __LINE__);
        }
        if (is_null($surchargeList) || (is_array($surchargeList) && empty($surchargeList))) {
            unset($this->SurchargeList);
        } else {
            $this->SurchargeList = $surchargeList;
        }
        return $this;
    }
    /**
     * Get SystemCharge value
     * @return float|null
     */
    public function getSystemCharge()
    {
        return $this->SystemCharge;
    }
    /**
     * Set SystemCharge value
     * @param float $systemCharge
     * @return \StructType\Quote
     */
    public function setSystemCharge($systemCharge = null)
    {
        // validation for constraint: float
        if (!is_null($systemCharge) && !(is_float($systemCharge) || is_numeric($systemCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($systemCharge, true), gettype($systemCharge)), __LINE__);
        }
        $this->SystemCharge = $systemCharge;
        return $this;
    }
    /**
     * Get TargetResponseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTargetResponseId()
    {
        return isset($this->TargetResponseId) ? $this->TargetResponseId : null;
    }
    /**
     * Set TargetResponseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $targetResponseId
     * @return \StructType\Quote
     */
    public function setTargetResponseId($targetResponseId = null)
    {
        // validation for constraint: int
        if (!is_null($targetResponseId) && !(is_int($targetResponseId) || ctype_digit($targetResponseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($targetResponseId, true), gettype($targetResponseId)), __LINE__);
        }
        if (is_null($targetResponseId) || (is_array($targetResponseId) && empty($targetResponseId))) {
            unset($this->TargetResponseId);
        } else {
            $this->TargetResponseId = $targetResponseId;
        }
        return $this;
    }
    /**
     * Get TargetStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetStartDate()
    {
        return isset($this->TargetStartDate) ? $this->TargetStartDate : null;
    }
    /**
     * Set TargetStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetStartDate
     * @return \StructType\Quote
     */
    public function setTargetStartDate($targetStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetStartDate) && !is_string($targetStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetStartDate, true), gettype($targetStartDate)), __LINE__);
        }
        if (is_null($targetStartDate) || (is_array($targetStartDate) && empty($targetStartDate))) {
            unset($this->TargetStartDate);
        } else {
            $this->TargetStartDate = $targetStartDate;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\Quote
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \StructType\Quote
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get ThirdUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThirdUserId()
    {
        return isset($this->ThirdUserId) ? $this->ThirdUserId : null;
    }
    /**
     * Set ThirdUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thirdUserId
     * @return \StructType\Quote
     */
    public function setThirdUserId($thirdUserId = null)
    {
        // validation for constraint: string
        if (!is_null($thirdUserId) && !is_string($thirdUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdUserId, true), gettype($thirdUserId)), __LINE__);
        }
        if (is_null($thirdUserId) || (is_array($thirdUserId) && empty($thirdUserId))) {
            unset($this->ThirdUserId);
        } else {
            $this->ThirdUserId = $thirdUserId;
        }
        return $this;
    }
    /**
     * Get TotalRateCost value
     * @return float|null
     */
    public function getTotalRateCost()
    {
        return $this->TotalRateCost;
    }
    /**
     * Set TotalRateCost value
     * @param float $totalRateCost
     * @return \StructType\Quote
     */
    public function setTotalRateCost($totalRateCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalRateCost) && !(is_float($totalRateCost) || is_numeric($totalRateCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalRateCost, true), gettype($totalRateCost)), __LINE__);
        }
        $this->TotalRateCost = $totalRateCost;
        return $this;
    }
    /**
     * Get VariableMarkup value
     * @return float|null
     */
    public function getVariableMarkup()
    {
        return $this->VariableMarkup;
    }
    /**
     * Set VariableMarkup value
     * @param float $variableMarkup
     * @return \StructType\Quote
     */
    public function setVariableMarkup($variableMarkup = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkup) && !(is_float($variableMarkup) || is_numeric($variableMarkup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkup, true), gettype($variableMarkup)), __LINE__);
        }
        $this->VariableMarkup = $variableMarkup;
        return $this;
    }
    /**
     * Get VehicleClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVehicleClass()
    {
        return isset($this->VehicleClass) ? $this->VehicleClass : null;
    }
    /**
     * Set VehicleClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vehicleClass
     * @return \StructType\Quote
     */
    public function setVehicleClass($vehicleClass = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleClass) && !is_string($vehicleClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleClass, true), gettype($vehicleClass)), __LINE__);
        }
        if (is_null($vehicleClass) || (is_array($vehicleClass) && empty($vehicleClass))) {
            unset($this->VehicleClass);
        } else {
            $this->VehicleClass = $vehicleClass;
        }
        return $this;
    }
    /**
     * Get VehicleEndOdometer value
     * @return int|null
     */
    public function getVehicleEndOdometer()
    {
        return $this->VehicleEndOdometer;
    }
    /**
     * Set VehicleEndOdometer value
     * @param int $vehicleEndOdometer
     * @return \StructType\Quote
     */
    public function setVehicleEndOdometer($vehicleEndOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleEndOdometer) && !(is_int($vehicleEndOdometer) || ctype_digit($vehicleEndOdometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleEndOdometer, true), gettype($vehicleEndOdometer)), __LINE__);
        }
        $this->VehicleEndOdometer = $vehicleEndOdometer;
        return $this;
    }
    /**
     * Get VehicleId value
     * @return int|null
     */
    public function getVehicleId()
    {
        return $this->VehicleId;
    }
    /**
     * Set VehicleId value
     * @param int $vehicleId
     * @return \StructType\Quote
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        $this->VehicleId = $vehicleId;
        return $this;
    }
    /**
     * Get VehicleOdometer value
     * @return int|null
     */
    public function getVehicleOdometer()
    {
        return $this->VehicleOdometer;
    }
    /**
     * Set VehicleOdometer value
     * @param int $vehicleOdometer
     * @return \StructType\Quote
     */
    public function setVehicleOdometer($vehicleOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleOdometer) && !(is_int($vehicleOdometer) || ctype_digit($vehicleOdometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleOdometer, true), gettype($vehicleOdometer)), __LINE__);
        }
        $this->VehicleOdometer = $vehicleOdometer;
        return $this;
    }
    /**
     * Get VehicleTrimId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVehicleTrimId()
    {
        return isset($this->VehicleTrimId) ? $this->VehicleTrimId : null;
    }
    /**
     * Set VehicleTrimId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vehicleTrimId
     * @return \StructType\Quote
     */
    public function setVehicleTrimId($vehicleTrimId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleTrimId) && !(is_int($vehicleTrimId) || ctype_digit($vehicleTrimId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleTrimId, true), gettype($vehicleTrimId)), __LINE__);
        }
        if (is_null($vehicleTrimId) || (is_array($vehicleTrimId) && empty($vehicleTrimId))) {
            unset($this->VehicleTrimId);
        } else {
            $this->VehicleTrimId = $vehicleTrimId;
        }
        return $this;
    }
    /**
     * Get VehicleType value
     * @return string|null
     */
    public function getVehicleType()
    {
        return $this->VehicleType;
    }
    /**
     * Set VehicleType value
     * @uses \EnumType\VehicleType::valueIsValid()
     * @uses \EnumType\VehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleType
     * @return \StructType\Quote
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleType::valueIsValid($vehicleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehicleType', is_array($vehicleType) ? implode(', ', $vehicleType) : var_export($vehicleType, true), implode(', ', \EnumType\VehicleType::getValidValues())), __LINE__);
        }
        $this->VehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get VinVerified value
     * @return bool|null
     */
    public function getVinVerified()
    {
        return $this->VinVerified;
    }
    /**
     * Set VinVerified value
     * @param bool $vinVerified
     * @return \StructType\Quote
     */
    public function setVinVerified($vinVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($vinVerified) && !is_bool($vinVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vinVerified, true), gettype($vinVerified)), __LINE__);
        }
        $this->VinVerified = $vinVerified;
        return $this;
    }
    /**
     * Get WaitingPeriodDays value
     * @return int|null
     */
    public function getWaitingPeriodDays()
    {
        return $this->WaitingPeriodDays;
    }
    /**
     * Set WaitingPeriodDays value
     * @param int $waitingPeriodDays
     * @return \StructType\Quote
     */
    public function setWaitingPeriodDays($waitingPeriodDays = null)
    {
        // validation for constraint: int
        if (!is_null($waitingPeriodDays) && !(is_int($waitingPeriodDays) || ctype_digit($waitingPeriodDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitingPeriodDays, true), gettype($waitingPeriodDays)), __LINE__);
        }
        $this->WaitingPeriodDays = $waitingPeriodDays;
        return $this;
    }
    /**
     * Get WaitingPeriodMiles value
     * @return int|null
     */
    public function getWaitingPeriodMiles()
    {
        return $this->WaitingPeriodMiles;
    }
    /**
     * Set WaitingPeriodMiles value
     * @param int $waitingPeriodMiles
     * @return \StructType\Quote
     */
    public function setWaitingPeriodMiles($waitingPeriodMiles = null)
    {
        // validation for constraint: int
        if (!is_null($waitingPeriodMiles) && !(is_int($waitingPeriodMiles) || ctype_digit($waitingPeriodMiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitingPeriodMiles, true), gettype($waitingPeriodMiles)), __LINE__);
        }
        $this->WaitingPeriodMiles = $waitingPeriodMiles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Quote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
