<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PickList
 * @subpackage Structs
 */
class PickList extends AbstractStructBase
{
    /**
     * The ItemText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemText;
    /**
     * The ItemValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemValue;
    /**
     * The ListName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListName;
    /**
     * The PickListId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickListId;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for PickList
     * @uses PickList::setItemText()
     * @uses PickList::setItemValue()
     * @uses PickList::setListName()
     * @uses PickList::setPickListId()
     * @uses PickList::setSortOrder()
     * @param string $itemText
     * @param string $itemValue
     * @param string $listName
     * @param int $pickListId
     * @param int $sortOrder
     */
    public function __construct($itemText = null, $itemValue = null, $listName = null, $pickListId = null, $sortOrder = null)
    {
        $this
            ->setItemText($itemText)
            ->setItemValue($itemValue)
            ->setListName($listName)
            ->setPickListId($pickListId)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get ItemText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemText()
    {
        return isset($this->ItemText) ? $this->ItemText : null;
    }
    /**
     * Set ItemText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemText
     * @return \StructType\PickList
     */
    public function setItemText($itemText = null)
    {
        // validation for constraint: string
        if (!is_null($itemText) && !is_string($itemText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemText, true), gettype($itemText)), __LINE__);
        }
        if (is_null($itemText) || (is_array($itemText) && empty($itemText))) {
            unset($this->ItemText);
        } else {
            $this->ItemText = $itemText;
        }
        return $this;
    }
    /**
     * Get ItemValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemValue()
    {
        return isset($this->ItemValue) ? $this->ItemValue : null;
    }
    /**
     * Set ItemValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemValue
     * @return \StructType\PickList
     */
    public function setItemValue($itemValue = null)
    {
        // validation for constraint: string
        if (!is_null($itemValue) && !is_string($itemValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemValue, true), gettype($itemValue)), __LINE__);
        }
        if (is_null($itemValue) || (is_array($itemValue) && empty($itemValue))) {
            unset($this->ItemValue);
        } else {
            $this->ItemValue = $itemValue;
        }
        return $this;
    }
    /**
     * Get ListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListName()
    {
        return isset($this->ListName) ? $this->ListName : null;
    }
    /**
     * Set ListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listName
     * @return \StructType\PickList
     */
    public function setListName($listName = null)
    {
        // validation for constraint: string
        if (!is_null($listName) && !is_string($listName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listName, true), gettype($listName)), __LINE__);
        }
        if (is_null($listName) || (is_array($listName) && empty($listName))) {
            unset($this->ListName);
        } else {
            $this->ListName = $listName;
        }
        return $this;
    }
    /**
     * Get PickListId value
     * @return int|null
     */
    public function getPickListId()
    {
        return $this->PickListId;
    }
    /**
     * Set PickListId value
     * @param int $pickListId
     * @return \StructType\PickList
     */
    public function setPickListId($pickListId = null)
    {
        // validation for constraint: int
        if (!is_null($pickListId) && !(is_int($pickListId) || ctype_digit($pickListId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickListId, true), gettype($pickListId)), __LINE__);
        }
        $this->PickListId = $pickListId;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\PickList
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !(is_int($sortOrder) || ctype_digit($sortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PickList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
