<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The AuthorizedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizedBy;
    /**
     * The AuthorizedConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizedConfirmation;
    /**
     * The AuthorizedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizedDate;
    /**
     * The CheckNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckNumber;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The ManuallyProcessed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ManuallyProcessed;
    /**
     * The ModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifyDate;
    /**
     * The ModifyUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyUserId;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PaymentAmount;
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDate;
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodName;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * The ProcessedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessedBy;
    /**
     * The ProcessedConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessedConfirmation;
    /**
     * The ProcessedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessedDate;
    /**
     * The ProcessorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessorId;
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuoteId;
    /**
     * The Settled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Settled;
    /**
     * The SettledDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettledDate;
    /**
     * The TransferPolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransferPolicyId;
    /**
     * Constructor method for Payment
     * @uses Payment::setAuthorizedBy()
     * @uses Payment::setAuthorizedConfirmation()
     * @uses Payment::setAuthorizedDate()
     * @uses Payment::setCheckNumber()
     * @uses Payment::setCreateDate()
     * @uses Payment::setCreateUserId()
     * @uses Payment::setManuallyProcessed()
     * @uses Payment::setModifyDate()
     * @uses Payment::setModifyUserId()
     * @uses Payment::setPaymentAmount()
     * @uses Payment::setPaymentDate()
     * @uses Payment::setPaymentId()
     * @uses Payment::setPaymentMethodId()
     * @uses Payment::setPaymentMethodName()
     * @uses Payment::setPaymentStatus()
     * @uses Payment::setPaymentType()
     * @uses Payment::setProcessedBy()
     * @uses Payment::setProcessedConfirmation()
     * @uses Payment::setProcessedDate()
     * @uses Payment::setProcessorId()
     * @uses Payment::setQuoteId()
     * @uses Payment::setSettled()
     * @uses Payment::setSettledDate()
     * @uses Payment::setTransferPolicyId()
     * @param string $authorizedBy
     * @param string $authorizedConfirmation
     * @param string $authorizedDate
     * @param string $checkNumber
     * @param string $createDate
     * @param string $createUserId
     * @param bool $manuallyProcessed
     * @param string $modifyDate
     * @param string $modifyUserId
     * @param float $paymentAmount
     * @param string $paymentDate
     * @param int $paymentId
     * @param int $paymentMethodId
     * @param string $paymentMethodName
     * @param string $paymentStatus
     * @param string $paymentType
     * @param string $processedBy
     * @param string $processedConfirmation
     * @param string $processedDate
     * @param int $processorId
     * @param int $quoteId
     * @param bool $settled
     * @param string $settledDate
     * @param int $transferPolicyId
     */
    public function __construct($authorizedBy = null, $authorizedConfirmation = null, $authorizedDate = null, $checkNumber = null, $createDate = null, $createUserId = null, $manuallyProcessed = null, $modifyDate = null, $modifyUserId = null, $paymentAmount = null, $paymentDate = null, $paymentId = null, $paymentMethodId = null, $paymentMethodName = null, $paymentStatus = null, $paymentType = null, $processedBy = null, $processedConfirmation = null, $processedDate = null, $processorId = null, $quoteId = null, $settled = null, $settledDate = null, $transferPolicyId = null)
    {
        $this
            ->setAuthorizedBy($authorizedBy)
            ->setAuthorizedConfirmation($authorizedConfirmation)
            ->setAuthorizedDate($authorizedDate)
            ->setCheckNumber($checkNumber)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setManuallyProcessed($manuallyProcessed)
            ->setModifyDate($modifyDate)
            ->setModifyUserId($modifyUserId)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentDate($paymentDate)
            ->setPaymentId($paymentId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentStatus($paymentStatus)
            ->setPaymentType($paymentType)
            ->setProcessedBy($processedBy)
            ->setProcessedConfirmation($processedConfirmation)
            ->setProcessedDate($processedDate)
            ->setProcessorId($processorId)
            ->setQuoteId($quoteId)
            ->setSettled($settled)
            ->setSettledDate($settledDate)
            ->setTransferPolicyId($transferPolicyId);
    }
    /**
     * Get AuthorizedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizedBy()
    {
        return isset($this->AuthorizedBy) ? $this->AuthorizedBy : null;
    }
    /**
     * Set AuthorizedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizedBy
     * @return \StructType\Payment
     */
    public function setAuthorizedBy($authorizedBy = null)
    {
        // validation for constraint: string
        if (!is_null($authorizedBy) && !is_string($authorizedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizedBy, true), gettype($authorizedBy)), __LINE__);
        }
        if (is_null($authorizedBy) || (is_array($authorizedBy) && empty($authorizedBy))) {
            unset($this->AuthorizedBy);
        } else {
            $this->AuthorizedBy = $authorizedBy;
        }
        return $this;
    }
    /**
     * Get AuthorizedConfirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizedConfirmation()
    {
        return isset($this->AuthorizedConfirmation) ? $this->AuthorizedConfirmation : null;
    }
    /**
     * Set AuthorizedConfirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizedConfirmation
     * @return \StructType\Payment
     */
    public function setAuthorizedConfirmation($authorizedConfirmation = null)
    {
        // validation for constraint: string
        if (!is_null($authorizedConfirmation) && !is_string($authorizedConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizedConfirmation, true), gettype($authorizedConfirmation)), __LINE__);
        }
        if (is_null($authorizedConfirmation) || (is_array($authorizedConfirmation) && empty($authorizedConfirmation))) {
            unset($this->AuthorizedConfirmation);
        } else {
            $this->AuthorizedConfirmation = $authorizedConfirmation;
        }
        return $this;
    }
    /**
     * Get AuthorizedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizedDate()
    {
        return isset($this->AuthorizedDate) ? $this->AuthorizedDate : null;
    }
    /**
     * Set AuthorizedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizedDate
     * @return \StructType\Payment
     */
    public function setAuthorizedDate($authorizedDate = null)
    {
        // validation for constraint: string
        if (!is_null($authorizedDate) && !is_string($authorizedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizedDate, true), gettype($authorizedDate)), __LINE__);
        }
        if (is_null($authorizedDate) || (is_array($authorizedDate) && empty($authorizedDate))) {
            unset($this->AuthorizedDate);
        } else {
            $this->AuthorizedDate = $authorizedDate;
        }
        return $this;
    }
    /**
     * Get CheckNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckNumber()
    {
        return isset($this->CheckNumber) ? $this->CheckNumber : null;
    }
    /**
     * Set CheckNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkNumber
     * @return \StructType\Payment
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        if (is_null($checkNumber) || (is_array($checkNumber) && empty($checkNumber))) {
            unset($this->CheckNumber);
        } else {
            $this->CheckNumber = $checkNumber;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Payment
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\Payment
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get ManuallyProcessed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getManuallyProcessed()
    {
        return isset($this->ManuallyProcessed) ? $this->ManuallyProcessed : null;
    }
    /**
     * Set ManuallyProcessed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $manuallyProcessed
     * @return \StructType\Payment
     */
    public function setManuallyProcessed($manuallyProcessed = null)
    {
        // validation for constraint: boolean
        if (!is_null($manuallyProcessed) && !is_bool($manuallyProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manuallyProcessed, true), gettype($manuallyProcessed)), __LINE__);
        }
        if (is_null($manuallyProcessed) || (is_array($manuallyProcessed) && empty($manuallyProcessed))) {
            unset($this->ManuallyProcessed);
        } else {
            $this->ManuallyProcessed = $manuallyProcessed;
        }
        return $this;
    }
    /**
     * Get ModifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->ModifyDate;
    }
    /**
     * Set ModifyDate value
     * @param string $modifyDate
     * @return \StructType\Payment
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        $this->ModifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get ModifyUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyUserId()
    {
        return isset($this->ModifyUserId) ? $this->ModifyUserId : null;
    }
    /**
     * Set ModifyUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyUserId
     * @return \StructType\Payment
     */
    public function setModifyUserId($modifyUserId = null)
    {
        // validation for constraint: string
        if (!is_null($modifyUserId) && !is_string($modifyUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyUserId, true), gettype($modifyUserId)), __LINE__);
        }
        if (is_null($modifyUserId) || (is_array($modifyUserId) && empty($modifyUserId))) {
            unset($this->ModifyUserId);
        } else {
            $this->ModifyUserId = $modifyUserId;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return isset($this->PaymentAmount) ? $this->PaymentAmount : null;
    }
    /**
     * Set PaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $paymentAmount
     * @return \StructType\Payment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        if (is_null($paymentAmount) || (is_array($paymentAmount) && empty($paymentAmount))) {
            unset($this->PaymentAmount);
        } else {
            $this->PaymentAmount = $paymentAmount;
        }
        return $this;
    }
    /**
     * Get PaymentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDate()
    {
        return isset($this->PaymentDate) ? $this->PaymentDate : null;
    }
    /**
     * Set PaymentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDate
     * @return \StructType\Payment
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        if (is_null($paymentDate) || (is_array($paymentDate) && empty($paymentDate))) {
            unset($this->PaymentDate);
        } else {
            $this->PaymentDate = $paymentDate;
        }
        return $this;
    }
    /**
     * Get PaymentId value
     * @return int|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param int $paymentId
     * @return \StructType\Payment
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !(is_int($paymentId) || ctype_digit($paymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentMethodId
     * @return \StructType\Payment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMethodId) && !(is_int($paymentMethodId) || ctype_digit($paymentMethodId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodName
     * @return \StructType\Payment
     */
    public function setPaymentMethodName($paymentMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodName) && !is_string($paymentMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodName, true), gettype($paymentMethodName)), __LINE__);
        }
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentStatus
     * @return \StructType\Payment
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatus) && !is_string($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatus, true), gettype($paymentStatus)), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentType
     * @return \StructType\Payment
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Get ProcessedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedBy()
    {
        return isset($this->ProcessedBy) ? $this->ProcessedBy : null;
    }
    /**
     * Set ProcessedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedBy
     * @return \StructType\Payment
     */
    public function setProcessedBy($processedBy = null)
    {
        // validation for constraint: string
        if (!is_null($processedBy) && !is_string($processedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedBy, true), gettype($processedBy)), __LINE__);
        }
        if (is_null($processedBy) || (is_array($processedBy) && empty($processedBy))) {
            unset($this->ProcessedBy);
        } else {
            $this->ProcessedBy = $processedBy;
        }
        return $this;
    }
    /**
     * Get ProcessedConfirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedConfirmation()
    {
        return isset($this->ProcessedConfirmation) ? $this->ProcessedConfirmation : null;
    }
    /**
     * Set ProcessedConfirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedConfirmation
     * @return \StructType\Payment
     */
    public function setProcessedConfirmation($processedConfirmation = null)
    {
        // validation for constraint: string
        if (!is_null($processedConfirmation) && !is_string($processedConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedConfirmation, true), gettype($processedConfirmation)), __LINE__);
        }
        if (is_null($processedConfirmation) || (is_array($processedConfirmation) && empty($processedConfirmation))) {
            unset($this->ProcessedConfirmation);
        } else {
            $this->ProcessedConfirmation = $processedConfirmation;
        }
        return $this;
    }
    /**
     * Get ProcessedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedDate()
    {
        return isset($this->ProcessedDate) ? $this->ProcessedDate : null;
    }
    /**
     * Set ProcessedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedDate
     * @return \StructType\Payment
     */
    public function setProcessedDate($processedDate = null)
    {
        // validation for constraint: string
        if (!is_null($processedDate) && !is_string($processedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedDate, true), gettype($processedDate)), __LINE__);
        }
        if (is_null($processedDate) || (is_array($processedDate) && empty($processedDate))) {
            unset($this->ProcessedDate);
        } else {
            $this->ProcessedDate = $processedDate;
        }
        return $this;
    }
    /**
     * Get ProcessorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessorId()
    {
        return isset($this->ProcessorId) ? $this->ProcessorId : null;
    }
    /**
     * Set ProcessorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processorId
     * @return \StructType\Payment
     */
    public function setProcessorId($processorId = null)
    {
        // validation for constraint: int
        if (!is_null($processorId) && !(is_int($processorId) || ctype_digit($processorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processorId, true), gettype($processorId)), __LINE__);
        }
        if (is_null($processorId) || (is_array($processorId) && empty($processorId))) {
            unset($this->ProcessorId);
        } else {
            $this->ProcessorId = $processorId;
        }
        return $this;
    }
    /**
     * Get QuoteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuoteId()
    {
        return isset($this->QuoteId) ? $this->QuoteId : null;
    }
    /**
     * Set QuoteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quoteId
     * @return \StructType\Payment
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !(is_int($quoteId) || ctype_digit($quoteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        if (is_null($quoteId) || (is_array($quoteId) && empty($quoteId))) {
            unset($this->QuoteId);
        } else {
            $this->QuoteId = $quoteId;
        }
        return $this;
    }
    /**
     * Get Settled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSettled()
    {
        return isset($this->Settled) ? $this->Settled : null;
    }
    /**
     * Set Settled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $settled
     * @return \StructType\Payment
     */
    public function setSettled($settled = null)
    {
        // validation for constraint: boolean
        if (!is_null($settled) && !is_bool($settled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($settled, true), gettype($settled)), __LINE__);
        }
        if (is_null($settled) || (is_array($settled) && empty($settled))) {
            unset($this->Settled);
        } else {
            $this->Settled = $settled;
        }
        return $this;
    }
    /**
     * Get SettledDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettledDate()
    {
        return isset($this->SettledDate) ? $this->SettledDate : null;
    }
    /**
     * Set SettledDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settledDate
     * @return \StructType\Payment
     */
    public function setSettledDate($settledDate = null)
    {
        // validation for constraint: string
        if (!is_null($settledDate) && !is_string($settledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settledDate, true), gettype($settledDate)), __LINE__);
        }
        if (is_null($settledDate) || (is_array($settledDate) && empty($settledDate))) {
            unset($this->SettledDate);
        } else {
            $this->SettledDate = $settledDate;
        }
        return $this;
    }
    /**
     * Get TransferPolicyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransferPolicyId()
    {
        return isset($this->TransferPolicyId) ? $this->TransferPolicyId : null;
    }
    /**
     * Set TransferPolicyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transferPolicyId
     * @return \StructType\Payment
     */
    public function setTransferPolicyId($transferPolicyId = null)
    {
        // validation for constraint: int
        if (!is_null($transferPolicyId) && !(is_int($transferPolicyId) || ctype_digit($transferPolicyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transferPolicyId, true), gettype($transferPolicyId)), __LINE__);
        }
        if (is_null($transferPolicyId) || (is_array($transferPolicyId) && empty($transferPolicyId))) {
            unset($this->TransferPolicyId);
        } else {
            $this->TransferPolicyId = $transferPolicyId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
