<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertPolicyPayment StructType
 * @subpackage Structs
 */
class InsertPolicyPayment extends AbstractStructBase
{
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Payment
     */
    public $payment;
    /**
     * Constructor method for InsertPolicyPayment
     * @uses InsertPolicyPayment::setPayment()
     * @param \StructType\Payment $payment
     */
    public function __construct(\StructType\Payment $payment = null)
    {
        $this
            ->setPayment($payment);
    }
    /**
     * Get payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Payment|null
     */
    public function getPayment()
    {
        return isset($this->payment) ? $this->payment : null;
    }
    /**
     * Set payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Payment $payment
     * @return \StructType\InsertPolicyPayment
     */
    public function setPayment(\StructType\Payment $payment = null)
    {
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->payment);
        } else {
            $this->payment = $payment;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertPolicyPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
