<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertPhoneCall StructType
 * @subpackage Structs
 */
class InsertPhoneCall extends AbstractStructBase
{
    /**
     * The call
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PhoneCall
     */
    public $call;
    /**
     * The userMatchField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $userMatchField;
    /**
     * Constructor method for InsertPhoneCall
     * @uses InsertPhoneCall::setCall()
     * @uses InsertPhoneCall::setUserMatchField()
     * @param \StructType\PhoneCall $call
     * @param int $userMatchField
     */
    public function __construct(\StructType\PhoneCall $call = null, $userMatchField = null)
    {
        $this
            ->setCall($call)
            ->setUserMatchField($userMatchField);
    }
    /**
     * Get call value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PhoneCall|null
     */
    public function getCall()
    {
        return isset($this->call) ? $this->call : null;
    }
    /**
     * Set call value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PhoneCall $call
     * @return \StructType\InsertPhoneCall
     */
    public function setCall(\StructType\PhoneCall $call = null)
    {
        if (is_null($call) || (is_array($call) && empty($call))) {
            unset($this->call);
        } else {
            $this->call = $call;
        }
        return $this;
    }
    /**
     * Get userMatchField value
     * @return int|null
     */
    public function getUserMatchField()
    {
        return $this->userMatchField;
    }
    /**
     * Set userMatchField value
     * @param int $userMatchField
     * @return \StructType\InsertPhoneCall
     */
    public function setUserMatchField($userMatchField = null)
    {
        // validation for constraint: int
        if (!is_null($userMatchField) && !(is_int($userMatchField) || ctype_digit($userMatchField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userMatchField, true), gettype($userMatchField)), __LINE__);
        }
        $this->userMatchField = $userMatchField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertPhoneCall
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
