<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertCampaignTarget StructType
 * @subpackage Structs
 */
class InsertCampaignTarget extends AbstractStructBase
{
    /**
     * The target
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CampaignTarget
     */
    public $target;
    /**
     * The responded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $responded;
    /**
     * Constructor method for InsertCampaignTarget
     * @uses InsertCampaignTarget::setTarget()
     * @uses InsertCampaignTarget::setResponded()
     * @param \StructType\CampaignTarget $target
     * @param bool $responded
     */
    public function __construct(\StructType\CampaignTarget $target = null, $responded = null)
    {
        $this
            ->setTarget($target)
            ->setResponded($responded);
    }
    /**
     * Get target value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CampaignTarget|null
     */
    public function getTarget()
    {
        return isset($this->target) ? $this->target : null;
    }
    /**
     * Set target value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CampaignTarget $target
     * @return \StructType\InsertCampaignTarget
     */
    public function setTarget(\StructType\CampaignTarget $target = null)
    {
        if (is_null($target) || (is_array($target) && empty($target))) {
            unset($this->target);
        } else {
            $this->target = $target;
        }
        return $this;
    }
    /**
     * Get responded value
     * @return bool|null
     */
    public function getResponded()
    {
        return $this->responded;
    }
    /**
     * Set responded value
     * @param bool $responded
     * @return \StructType\InsertCampaignTarget
     */
    public function setResponded($responded = null)
    {
        // validation for constraint: boolean
        if (!is_null($responded) && !is_bool($responded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($responded, true), gettype($responded)), __LINE__);
        }
        $this->responded = $responded;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertCampaignTarget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
