<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:History
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContactId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The HistoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HistoryId;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for History
     * @uses History::setCategory()
     * @uses History::setContactId()
     * @uses History::setCreateDate()
     * @uses History::setCreateUserId()
     * @uses History::setDescription()
     * @uses History::setHistoryId()
     * @uses History::setNotes()
     * @param string $category
     * @param int $contactId
     * @param string $createDate
     * @param string $createUserId
     * @param string $description
     * @param int $historyId
     * @param string $notes
     */
    public function __construct($category = null, $contactId = null, $createDate = null, $createUserId = null, $description = null, $historyId = null, $notes = null)
    {
        $this
            ->setCategory($category)
            ->setContactId($contactId)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setDescription($description)
            ->setHistoryId($historyId)
            ->setNotes($notes);
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\HistoryCategory::valueIsValid()
     * @uses \EnumType\HistoryCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\History
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HistoryCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HistoryCategory', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \EnumType\HistoryCategory::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ContactId value
     * @return int|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param int $contactId
     * @return \StructType\History
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\History
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\History
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\History
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HistoryId value
     * @return int|null
     */
    public function getHistoryId()
    {
        return $this->HistoryId;
    }
    /**
     * Set HistoryId value
     * @param int $historyId
     * @return \StructType\History
     */
    public function setHistoryId($historyId = null)
    {
        // validation for constraint: int
        if (!is_null($historyId) && !(is_int($historyId) || ctype_digit($historyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historyId, true), gettype($historyId)), __LINE__);
        }
        $this->HistoryId = $historyId;
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \StructType\History
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\History
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
