<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWarrantyRates_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetWarrantyRates_Result
 * @subpackage Structs
 */
class GetWarrantyRates_Result extends AbstractStructBase
{
    /**
     * The APRFinanceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $APRFinanceCharge;
    /**
     * The AddWaiting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AddWaiting;
    /**
     * The AdminBaseSupplement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdminBaseSupplement;
    /**
     * The AdminMarketerCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdminMarketerCommission;
    /**
     * The AdministratorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdministratorId;
    /**
     * The AdministratorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdministratorName;
    /**
     * The AllowPIF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowPIF;
    /**
     * The AllowSelfFinance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowSelfFinance;
    /**
     * The ApplySalesTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ApplySalesTax;
    /**
     * The CampaignFixedMarkupAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CampaignFixedMarkupAdjustment;
    /**
     * The ClassCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClassCode;
    /**
     * The ClassSurcharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ClassSurcharge;
    /**
     * The CoverageColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageColor;
    /**
     * The CoverageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CoverageId;
    /**
     * The CoverageName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageName;
    /**
     * The CoveragePriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CoveragePriority;
    /**
     * The CoverageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageType;
    /**
     * The Deductible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Deductible;
    /**
     * The DefaultDeductible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DefaultDeductible;
    /**
     * The FinanceProgramId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FinanceProgramId;
    /**
     * The FixedMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FixedMarkup;
    /**
     * The NewOrUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewOrUsed;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductName;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The RateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RateCode;
    /**
     * The RateCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RateCost;
    /**
     * The RateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateDate;
    /**
     * The RateGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RateGroupCode;
    /**
     * The StateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateProvince;
    /**
     * The SurchargeCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SurchargeCost;
    /**
     * The SystemCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SystemCharge;
    /**
     * The TermMiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TermMiles;
    /**
     * The TermMonths
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TermMonths;
    /**
     * The TermsDocId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TermsDocId;
    /**
     * The VariableMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkup;
    /**
     * The VariableMarkupMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkupMax;
    /**
     * The VariableMarkupMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkupMin;
    /**
     * The VehicleClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VehicleClass;
    /**
     * The WaitingDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WaitingDays;
    /**
     * The WaitingMiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WaitingMiles;
    /**
     * The WarrantyRateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WarrantyRateId;
    /**
     * Constructor method for GetWarrantyRates_Result
     * @uses GetWarrantyRates_Result::setAPRFinanceCharge()
     * @uses GetWarrantyRates_Result::setAddWaiting()
     * @uses GetWarrantyRates_Result::setAdminBaseSupplement()
     * @uses GetWarrantyRates_Result::setAdminMarketerCommission()
     * @uses GetWarrantyRates_Result::setAdministratorId()
     * @uses GetWarrantyRates_Result::setAdministratorName()
     * @uses GetWarrantyRates_Result::setAllowPIF()
     * @uses GetWarrantyRates_Result::setAllowSelfFinance()
     * @uses GetWarrantyRates_Result::setApplySalesTax()
     * @uses GetWarrantyRates_Result::setCampaignFixedMarkupAdjustment()
     * @uses GetWarrantyRates_Result::setClassCode()
     * @uses GetWarrantyRates_Result::setClassSurcharge()
     * @uses GetWarrantyRates_Result::setCoverageColor()
     * @uses GetWarrantyRates_Result::setCoverageId()
     * @uses GetWarrantyRates_Result::setCoverageName()
     * @uses GetWarrantyRates_Result::setCoveragePriority()
     * @uses GetWarrantyRates_Result::setCoverageType()
     * @uses GetWarrantyRates_Result::setDeductible()
     * @uses GetWarrantyRates_Result::setDefaultDeductible()
     * @uses GetWarrantyRates_Result::setFinanceProgramId()
     * @uses GetWarrantyRates_Result::setFixedMarkup()
     * @uses GetWarrantyRates_Result::setNewOrUsed()
     * @uses GetWarrantyRates_Result::setProductId()
     * @uses GetWarrantyRates_Result::setProductName()
     * @uses GetWarrantyRates_Result::setProductType()
     * @uses GetWarrantyRates_Result::setRateCode()
     * @uses GetWarrantyRates_Result::setRateCost()
     * @uses GetWarrantyRates_Result::setRateDate()
     * @uses GetWarrantyRates_Result::setRateGroupCode()
     * @uses GetWarrantyRates_Result::setStateProvince()
     * @uses GetWarrantyRates_Result::setSurchargeCost()
     * @uses GetWarrantyRates_Result::setSystemCharge()
     * @uses GetWarrantyRates_Result::setTermMiles()
     * @uses GetWarrantyRates_Result::setTermMonths()
     * @uses GetWarrantyRates_Result::setTermsDocId()
     * @uses GetWarrantyRates_Result::setVariableMarkup()
     * @uses GetWarrantyRates_Result::setVariableMarkupMax()
     * @uses GetWarrantyRates_Result::setVariableMarkupMin()
     * @uses GetWarrantyRates_Result::setVehicleClass()
     * @uses GetWarrantyRates_Result::setWaitingDays()
     * @uses GetWarrantyRates_Result::setWaitingMiles()
     * @uses GetWarrantyRates_Result::setWarrantyRateId()
     * @param bool $aPRFinanceCharge
     * @param bool $addWaiting
     * @param float $adminBaseSupplement
     * @param float $adminMarketerCommission
     * @param int $administratorId
     * @param string $administratorName
     * @param bool $allowPIF
     * @param bool $allowSelfFinance
     * @param bool $applySalesTax
     * @param float $campaignFixedMarkupAdjustment
     * @param string $classCode
     * @param float $classSurcharge
     * @param string $coverageColor
     * @param int $coverageId
     * @param string $coverageName
     * @param int $coveragePriority
     * @param string $coverageType
     * @param float $deductible
     * @param bool $defaultDeductible
     * @param int $financeProgramId
     * @param float $fixedMarkup
     * @param string $newOrUsed
     * @param int $productId
     * @param string $productName
     * @param string $productType
     * @param string $rateCode
     * @param float $rateCost
     * @param string $rateDate
     * @param string $rateGroupCode
     * @param string $stateProvince
     * @param float $surchargeCost
     * @param float $systemCharge
     * @param int $termMiles
     * @param int $termMonths
     * @param int $termsDocId
     * @param float $variableMarkup
     * @param float $variableMarkupMax
     * @param float $variableMarkupMin
     * @param string $vehicleClass
     * @param int $waitingDays
     * @param int $waitingMiles
     * @param int $warrantyRateId
     */
    public function __construct($aPRFinanceCharge = null, $addWaiting = null, $adminBaseSupplement = null, $adminMarketerCommission = null, $administratorId = null, $administratorName = null, $allowPIF = null, $allowSelfFinance = null, $applySalesTax = null, $campaignFixedMarkupAdjustment = null, $classCode = null, $classSurcharge = null, $coverageColor = null, $coverageId = null, $coverageName = null, $coveragePriority = null, $coverageType = null, $deductible = null, $defaultDeductible = null, $financeProgramId = null, $fixedMarkup = null, $newOrUsed = null, $productId = null, $productName = null, $productType = null, $rateCode = null, $rateCost = null, $rateDate = null, $rateGroupCode = null, $stateProvince = null, $surchargeCost = null, $systemCharge = null, $termMiles = null, $termMonths = null, $termsDocId = null, $variableMarkup = null, $variableMarkupMax = null, $variableMarkupMin = null, $vehicleClass = null, $waitingDays = null, $waitingMiles = null, $warrantyRateId = null)
    {
        $this
            ->setAPRFinanceCharge($aPRFinanceCharge)
            ->setAddWaiting($addWaiting)
            ->setAdminBaseSupplement($adminBaseSupplement)
            ->setAdminMarketerCommission($adminMarketerCommission)
            ->setAdministratorId($administratorId)
            ->setAdministratorName($administratorName)
            ->setAllowPIF($allowPIF)
            ->setAllowSelfFinance($allowSelfFinance)
            ->setApplySalesTax($applySalesTax)
            ->setCampaignFixedMarkupAdjustment($campaignFixedMarkupAdjustment)
            ->setClassCode($classCode)
            ->setClassSurcharge($classSurcharge)
            ->setCoverageColor($coverageColor)
            ->setCoverageId($coverageId)
            ->setCoverageName($coverageName)
            ->setCoveragePriority($coveragePriority)
            ->setCoverageType($coverageType)
            ->setDeductible($deductible)
            ->setDefaultDeductible($defaultDeductible)
            ->setFinanceProgramId($financeProgramId)
            ->setFixedMarkup($fixedMarkup)
            ->setNewOrUsed($newOrUsed)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductType($productType)
            ->setRateCode($rateCode)
            ->setRateCost($rateCost)
            ->setRateDate($rateDate)
            ->setRateGroupCode($rateGroupCode)
            ->setStateProvince($stateProvince)
            ->setSurchargeCost($surchargeCost)
            ->setSystemCharge($systemCharge)
            ->setTermMiles($termMiles)
            ->setTermMonths($termMonths)
            ->setTermsDocId($termsDocId)
            ->setVariableMarkup($variableMarkup)
            ->setVariableMarkupMax($variableMarkupMax)
            ->setVariableMarkupMin($variableMarkupMin)
            ->setVehicleClass($vehicleClass)
            ->setWaitingDays($waitingDays)
            ->setWaitingMiles($waitingMiles)
            ->setWarrantyRateId($warrantyRateId);
    }
    /**
     * Get APRFinanceCharge value
     * @return bool|null
     */
    public function getAPRFinanceCharge()
    {
        return $this->APRFinanceCharge;
    }
    /**
     * Set APRFinanceCharge value
     * @param bool $aPRFinanceCharge
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAPRFinanceCharge($aPRFinanceCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($aPRFinanceCharge) && !is_bool($aPRFinanceCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aPRFinanceCharge, true), gettype($aPRFinanceCharge)), __LINE__);
        }
        $this->APRFinanceCharge = $aPRFinanceCharge;
        return $this;
    }
    /**
     * Get AddWaiting value
     * @return bool|null
     */
    public function getAddWaiting()
    {
        return $this->AddWaiting;
    }
    /**
     * Set AddWaiting value
     * @param bool $addWaiting
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAddWaiting($addWaiting = null)
    {
        // validation for constraint: boolean
        if (!is_null($addWaiting) && !is_bool($addWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addWaiting, true), gettype($addWaiting)), __LINE__);
        }
        $this->AddWaiting = $addWaiting;
        return $this;
    }
    /**
     * Get AdminBaseSupplement value
     * @return float|null
     */
    public function getAdminBaseSupplement()
    {
        return $this->AdminBaseSupplement;
    }
    /**
     * Set AdminBaseSupplement value
     * @param float $adminBaseSupplement
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAdminBaseSupplement($adminBaseSupplement = null)
    {
        // validation for constraint: float
        if (!is_null($adminBaseSupplement) && !(is_float($adminBaseSupplement) || is_numeric($adminBaseSupplement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adminBaseSupplement, true), gettype($adminBaseSupplement)), __LINE__);
        }
        $this->AdminBaseSupplement = $adminBaseSupplement;
        return $this;
    }
    /**
     * Get AdminMarketerCommission value
     * @return float|null
     */
    public function getAdminMarketerCommission()
    {
        return $this->AdminMarketerCommission;
    }
    /**
     * Set AdminMarketerCommission value
     * @param float $adminMarketerCommission
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAdminMarketerCommission($adminMarketerCommission = null)
    {
        // validation for constraint: float
        if (!is_null($adminMarketerCommission) && !(is_float($adminMarketerCommission) || is_numeric($adminMarketerCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adminMarketerCommission, true), gettype($adminMarketerCommission)), __LINE__);
        }
        $this->AdminMarketerCommission = $adminMarketerCommission;
        return $this;
    }
    /**
     * Get AdministratorId value
     * @return int|null
     */
    public function getAdministratorId()
    {
        return $this->AdministratorId;
    }
    /**
     * Set AdministratorId value
     * @param int $administratorId
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAdministratorId($administratorId = null)
    {
        // validation for constraint: int
        if (!is_null($administratorId) && !(is_int($administratorId) || ctype_digit($administratorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($administratorId, true), gettype($administratorId)), __LINE__);
        }
        $this->AdministratorId = $administratorId;
        return $this;
    }
    /**
     * Get AdministratorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdministratorName()
    {
        return isset($this->AdministratorName) ? $this->AdministratorName : null;
    }
    /**
     * Set AdministratorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $administratorName
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAdministratorName($administratorName = null)
    {
        // validation for constraint: string
        if (!is_null($administratorName) && !is_string($administratorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($administratorName, true), gettype($administratorName)), __LINE__);
        }
        if (is_null($administratorName) || (is_array($administratorName) && empty($administratorName))) {
            unset($this->AdministratorName);
        } else {
            $this->AdministratorName = $administratorName;
        }
        return $this;
    }
    /**
     * Get AllowPIF value
     * @return bool|null
     */
    public function getAllowPIF()
    {
        return $this->AllowPIF;
    }
    /**
     * Set AllowPIF value
     * @param bool $allowPIF
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAllowPIF($allowPIF = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPIF) && !is_bool($allowPIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPIF, true), gettype($allowPIF)), __LINE__);
        }
        $this->AllowPIF = $allowPIF;
        return $this;
    }
    /**
     * Get AllowSelfFinance value
     * @return bool|null
     */
    public function getAllowSelfFinance()
    {
        return $this->AllowSelfFinance;
    }
    /**
     * Set AllowSelfFinance value
     * @param bool $allowSelfFinance
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setAllowSelfFinance($allowSelfFinance = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSelfFinance) && !is_bool($allowSelfFinance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSelfFinance, true), gettype($allowSelfFinance)), __LINE__);
        }
        $this->AllowSelfFinance = $allowSelfFinance;
        return $this;
    }
    /**
     * Get ApplySalesTax value
     * @return bool|null
     */
    public function getApplySalesTax()
    {
        return $this->ApplySalesTax;
    }
    /**
     * Set ApplySalesTax value
     * @param bool $applySalesTax
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setApplySalesTax($applySalesTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($applySalesTax) && !is_bool($applySalesTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applySalesTax, true), gettype($applySalesTax)), __LINE__);
        }
        $this->ApplySalesTax = $applySalesTax;
        return $this;
    }
    /**
     * Get CampaignFixedMarkupAdjustment value
     * @return float|null
     */
    public function getCampaignFixedMarkupAdjustment()
    {
        return $this->CampaignFixedMarkupAdjustment;
    }
    /**
     * Set CampaignFixedMarkupAdjustment value
     * @param float $campaignFixedMarkupAdjustment
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setCampaignFixedMarkupAdjustment($campaignFixedMarkupAdjustment = null)
    {
        // validation for constraint: float
        if (!is_null($campaignFixedMarkupAdjustment) && !(is_float($campaignFixedMarkupAdjustment) || is_numeric($campaignFixedMarkupAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($campaignFixedMarkupAdjustment, true), gettype($campaignFixedMarkupAdjustment)), __LINE__);
        }
        $this->CampaignFixedMarkupAdjustment = $campaignFixedMarkupAdjustment;
        return $this;
    }
    /**
     * Get ClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassCode()
    {
        return isset($this->ClassCode) ? $this->ClassCode : null;
    }
    /**
     * Set ClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classCode
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: string
        if (!is_null($classCode) && !is_string($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classCode, true), gettype($classCode)), __LINE__);
        }
        if (is_null($classCode) || (is_array($classCode) && empty($classCode))) {
            unset($this->ClassCode);
        } else {
            $this->ClassCode = $classCode;
        }
        return $this;
    }
    /**
     * Get ClassSurcharge value
     * @return float|null
     */
    public function getClassSurcharge()
    {
        return $this->ClassSurcharge;
    }
    /**
     * Set ClassSurcharge value
     * @param float $classSurcharge
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setClassSurcharge($classSurcharge = null)
    {
        // validation for constraint: float
        if (!is_null($classSurcharge) && !(is_float($classSurcharge) || is_numeric($classSurcharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($classSurcharge, true), gettype($classSurcharge)), __LINE__);
        }
        $this->ClassSurcharge = $classSurcharge;
        return $this;
    }
    /**
     * Get CoverageColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageColor()
    {
        return isset($this->CoverageColor) ? $this->CoverageColor : null;
    }
    /**
     * Set CoverageColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageColor
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setCoverageColor($coverageColor = null)
    {
        // validation for constraint: string
        if (!is_null($coverageColor) && !is_string($coverageColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageColor, true), gettype($coverageColor)), __LINE__);
        }
        if (is_null($coverageColor) || (is_array($coverageColor) && empty($coverageColor))) {
            unset($this->CoverageColor);
        } else {
            $this->CoverageColor = $coverageColor;
        }
        return $this;
    }
    /**
     * Get CoverageId value
     * @return int|null
     */
    public function getCoverageId()
    {
        return $this->CoverageId;
    }
    /**
     * Set CoverageId value
     * @param int $coverageId
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setCoverageId($coverageId = null)
    {
        // validation for constraint: int
        if (!is_null($coverageId) && !(is_int($coverageId) || ctype_digit($coverageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coverageId, true), gettype($coverageId)), __LINE__);
        }
        $this->CoverageId = $coverageId;
        return $this;
    }
    /**
     * Get CoverageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageName()
    {
        return isset($this->CoverageName) ? $this->CoverageName : null;
    }
    /**
     * Set CoverageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageName
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setCoverageName($coverageName = null)
    {
        // validation for constraint: string
        if (!is_null($coverageName) && !is_string($coverageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageName, true), gettype($coverageName)), __LINE__);
        }
        if (is_null($coverageName) || (is_array($coverageName) && empty($coverageName))) {
            unset($this->CoverageName);
        } else {
            $this->CoverageName = $coverageName;
        }
        return $this;
    }
    /**
     * Get CoveragePriority value
     * @return int|null
     */
    public function getCoveragePriority()
    {
        return $this->CoveragePriority;
    }
    /**
     * Set CoveragePriority value
     * @param int $coveragePriority
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setCoveragePriority($coveragePriority = null)
    {
        // validation for constraint: int
        if (!is_null($coveragePriority) && !(is_int($coveragePriority) || ctype_digit($coveragePriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coveragePriority, true), gettype($coveragePriority)), __LINE__);
        }
        $this->CoveragePriority = $coveragePriority;
        return $this;
    }
    /**
     * Get CoverageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageType()
    {
        return isset($this->CoverageType) ? $this->CoverageType : null;
    }
    /**
     * Set CoverageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageType
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setCoverageType($coverageType = null)
    {
        // validation for constraint: string
        if (!is_null($coverageType) && !is_string($coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageType, true), gettype($coverageType)), __LINE__);
        }
        if (is_null($coverageType) || (is_array($coverageType) && empty($coverageType))) {
            unset($this->CoverageType);
        } else {
            $this->CoverageType = $coverageType;
        }
        return $this;
    }
    /**
     * Get Deductible value
     * @return float|null
     */
    public function getDeductible()
    {
        return $this->Deductible;
    }
    /**
     * Set Deductible value
     * @param float $deductible
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setDeductible($deductible = null)
    {
        // validation for constraint: float
        if (!is_null($deductible) && !(is_float($deductible) || is_numeric($deductible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deductible, true), gettype($deductible)), __LINE__);
        }
        $this->Deductible = $deductible;
        return $this;
    }
    /**
     * Get DefaultDeductible value
     * @return bool|null
     */
    public function getDefaultDeductible()
    {
        return $this->DefaultDeductible;
    }
    /**
     * Set DefaultDeductible value
     * @param bool $defaultDeductible
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setDefaultDeductible($defaultDeductible = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultDeductible) && !is_bool($defaultDeductible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultDeductible, true), gettype($defaultDeductible)), __LINE__);
        }
        $this->DefaultDeductible = $defaultDeductible;
        return $this;
    }
    /**
     * Get FinanceProgramId value
     * @return int|null
     */
    public function getFinanceProgramId()
    {
        return $this->FinanceProgramId;
    }
    /**
     * Set FinanceProgramId value
     * @param int $financeProgramId
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setFinanceProgramId($financeProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($financeProgramId) && !(is_int($financeProgramId) || ctype_digit($financeProgramId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($financeProgramId, true), gettype($financeProgramId)), __LINE__);
        }
        $this->FinanceProgramId = $financeProgramId;
        return $this;
    }
    /**
     * Get FixedMarkup value
     * @return float|null
     */
    public function getFixedMarkup()
    {
        return $this->FixedMarkup;
    }
    /**
     * Set FixedMarkup value
     * @param float $fixedMarkup
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setFixedMarkup($fixedMarkup = null)
    {
        // validation for constraint: float
        if (!is_null($fixedMarkup) && !(is_float($fixedMarkup) || is_numeric($fixedMarkup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedMarkup, true), gettype($fixedMarkup)), __LINE__);
        }
        $this->FixedMarkup = $fixedMarkup;
        return $this;
    }
    /**
     * Get NewOrUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOrUsed()
    {
        return isset($this->NewOrUsed) ? $this->NewOrUsed : null;
    }
    /**
     * Set NewOrUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOrUsed
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setNewOrUsed($newOrUsed = null)
    {
        // validation for constraint: string
        if (!is_null($newOrUsed) && !is_string($newOrUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOrUsed, true), gettype($newOrUsed)), __LINE__);
        }
        if (is_null($newOrUsed) || (is_array($newOrUsed) && empty($newOrUsed))) {
            unset($this->NewOrUsed);
        } else {
            $this->NewOrUsed = $newOrUsed;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productName
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productType
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get RateCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRateCode()
    {
        return isset($this->RateCode) ? $this->RateCode : null;
    }
    /**
     * Set RateCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rateCode
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setRateCode($rateCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateCode) && !is_string($rateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCode, true), gettype($rateCode)), __LINE__);
        }
        if (is_null($rateCode) || (is_array($rateCode) && empty($rateCode))) {
            unset($this->RateCode);
        } else {
            $this->RateCode = $rateCode;
        }
        return $this;
    }
    /**
     * Get RateCost value
     * @return float|null
     */
    public function getRateCost()
    {
        return $this->RateCost;
    }
    /**
     * Set RateCost value
     * @param float $rateCost
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setRateCost($rateCost = null)
    {
        // validation for constraint: float
        if (!is_null($rateCost) && !(is_float($rateCost) || is_numeric($rateCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateCost, true), gettype($rateCost)), __LINE__);
        }
        $this->RateCost = $rateCost;
        return $this;
    }
    /**
     * Get RateDate value
     * @return string|null
     */
    public function getRateDate()
    {
        return $this->RateDate;
    }
    /**
     * Set RateDate value
     * @param string $rateDate
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setRateDate($rateDate = null)
    {
        // validation for constraint: string
        if (!is_null($rateDate) && !is_string($rateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateDate, true), gettype($rateDate)), __LINE__);
        }
        $this->RateDate = $rateDate;
        return $this;
    }
    /**
     * Get RateGroupCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRateGroupCode()
    {
        return isset($this->RateGroupCode) ? $this->RateGroupCode : null;
    }
    /**
     * Set RateGroupCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rateGroupCode
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setRateGroupCode($rateGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateGroupCode) && !is_string($rateGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateGroupCode, true), gettype($rateGroupCode)), __LINE__);
        }
        if (is_null($rateGroupCode) || (is_array($rateGroupCode) && empty($rateGroupCode))) {
            unset($this->RateGroupCode);
        } else {
            $this->RateGroupCode = $rateGroupCode;
        }
        return $this;
    }
    /**
     * Get StateProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateProvince()
    {
        return isset($this->StateProvince) ? $this->StateProvince : null;
    }
    /**
     * Set StateProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateProvince
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        if (is_null($stateProvince) || (is_array($stateProvince) && empty($stateProvince))) {
            unset($this->StateProvince);
        } else {
            $this->StateProvince = $stateProvince;
        }
        return $this;
    }
    /**
     * Get SurchargeCost value
     * @return float|null
     */
    public function getSurchargeCost()
    {
        return $this->SurchargeCost;
    }
    /**
     * Set SurchargeCost value
     * @param float $surchargeCost
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setSurchargeCost($surchargeCost = null)
    {
        // validation for constraint: float
        if (!is_null($surchargeCost) && !(is_float($surchargeCost) || is_numeric($surchargeCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surchargeCost, true), gettype($surchargeCost)), __LINE__);
        }
        $this->SurchargeCost = $surchargeCost;
        return $this;
    }
    /**
     * Get SystemCharge value
     * @return float|null
     */
    public function getSystemCharge()
    {
        return $this->SystemCharge;
    }
    /**
     * Set SystemCharge value
     * @param float $systemCharge
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setSystemCharge($systemCharge = null)
    {
        // validation for constraint: float
        if (!is_null($systemCharge) && !(is_float($systemCharge) || is_numeric($systemCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($systemCharge, true), gettype($systemCharge)), __LINE__);
        }
        $this->SystemCharge = $systemCharge;
        return $this;
    }
    /**
     * Get TermMiles value
     * @return int|null
     */
    public function getTermMiles()
    {
        return $this->TermMiles;
    }
    /**
     * Set TermMiles value
     * @param int $termMiles
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setTermMiles($termMiles = null)
    {
        // validation for constraint: int
        if (!is_null($termMiles) && !(is_int($termMiles) || ctype_digit($termMiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($termMiles, true), gettype($termMiles)), __LINE__);
        }
        $this->TermMiles = $termMiles;
        return $this;
    }
    /**
     * Get TermMonths value
     * @return int|null
     */
    public function getTermMonths()
    {
        return $this->TermMonths;
    }
    /**
     * Set TermMonths value
     * @param int $termMonths
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setTermMonths($termMonths = null)
    {
        // validation for constraint: int
        if (!is_null($termMonths) && !(is_int($termMonths) || ctype_digit($termMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($termMonths, true), gettype($termMonths)), __LINE__);
        }
        $this->TermMonths = $termMonths;
        return $this;
    }
    /**
     * Get TermsDocId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTermsDocId()
    {
        return isset($this->TermsDocId) ? $this->TermsDocId : null;
    }
    /**
     * Set TermsDocId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $termsDocId
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setTermsDocId($termsDocId = null)
    {
        // validation for constraint: int
        if (!is_null($termsDocId) && !(is_int($termsDocId) || ctype_digit($termsDocId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($termsDocId, true), gettype($termsDocId)), __LINE__);
        }
        if (is_null($termsDocId) || (is_array($termsDocId) && empty($termsDocId))) {
            unset($this->TermsDocId);
        } else {
            $this->TermsDocId = $termsDocId;
        }
        return $this;
    }
    /**
     * Get VariableMarkup value
     * @return float|null
     */
    public function getVariableMarkup()
    {
        return $this->VariableMarkup;
    }
    /**
     * Set VariableMarkup value
     * @param float $variableMarkup
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setVariableMarkup($variableMarkup = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkup) && !(is_float($variableMarkup) || is_numeric($variableMarkup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkup, true), gettype($variableMarkup)), __LINE__);
        }
        $this->VariableMarkup = $variableMarkup;
        return $this;
    }
    /**
     * Get VariableMarkupMax value
     * @return float|null
     */
    public function getVariableMarkupMax()
    {
        return $this->VariableMarkupMax;
    }
    /**
     * Set VariableMarkupMax value
     * @param float $variableMarkupMax
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setVariableMarkupMax($variableMarkupMax = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkupMax) && !(is_float($variableMarkupMax) || is_numeric($variableMarkupMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkupMax, true), gettype($variableMarkupMax)), __LINE__);
        }
        $this->VariableMarkupMax = $variableMarkupMax;
        return $this;
    }
    /**
     * Get VariableMarkupMin value
     * @return float|null
     */
    public function getVariableMarkupMin()
    {
        return $this->VariableMarkupMin;
    }
    /**
     * Set VariableMarkupMin value
     * @param float $variableMarkupMin
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setVariableMarkupMin($variableMarkupMin = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkupMin) && !(is_float($variableMarkupMin) || is_numeric($variableMarkupMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkupMin, true), gettype($variableMarkupMin)), __LINE__);
        }
        $this->VariableMarkupMin = $variableMarkupMin;
        return $this;
    }
    /**
     * Get VehicleClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVehicleClass()
    {
        return isset($this->VehicleClass) ? $this->VehicleClass : null;
    }
    /**
     * Set VehicleClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vehicleClass
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setVehicleClass($vehicleClass = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleClass) && !is_string($vehicleClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleClass, true), gettype($vehicleClass)), __LINE__);
        }
        if (is_null($vehicleClass) || (is_array($vehicleClass) && empty($vehicleClass))) {
            unset($this->VehicleClass);
        } else {
            $this->VehicleClass = $vehicleClass;
        }
        return $this;
    }
    /**
     * Get WaitingDays value
     * @return int|null
     */
    public function getWaitingDays()
    {
        return $this->WaitingDays;
    }
    /**
     * Set WaitingDays value
     * @param int $waitingDays
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setWaitingDays($waitingDays = null)
    {
        // validation for constraint: int
        if (!is_null($waitingDays) && !(is_int($waitingDays) || ctype_digit($waitingDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitingDays, true), gettype($waitingDays)), __LINE__);
        }
        $this->WaitingDays = $waitingDays;
        return $this;
    }
    /**
     * Get WaitingMiles value
     * @return int|null
     */
    public function getWaitingMiles()
    {
        return $this->WaitingMiles;
    }
    /**
     * Set WaitingMiles value
     * @param int $waitingMiles
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setWaitingMiles($waitingMiles = null)
    {
        // validation for constraint: int
        if (!is_null($waitingMiles) && !(is_int($waitingMiles) || ctype_digit($waitingMiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitingMiles, true), gettype($waitingMiles)), __LINE__);
        }
        $this->WaitingMiles = $waitingMiles;
        return $this;
    }
    /**
     * Get WarrantyRateId value
     * @return int|null
     */
    public function getWarrantyRateId()
    {
        return $this->WarrantyRateId;
    }
    /**
     * Set WarrantyRateId value
     * @param int $warrantyRateId
     * @return \StructType\GetWarrantyRates_Result
     */
    public function setWarrantyRateId($warrantyRateId = null)
    {
        // validation for constraint: int
        if (!is_null($warrantyRateId) && !(is_int($warrantyRateId) || ctype_digit($warrantyRateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warrantyRateId, true), gettype($warrantyRateId)), __LINE__);
        }
        $this->WarrantyRateId = $warrantyRateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWarrantyRates_Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
