<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQueryReportResults StructType
 * @subpackage Structs
 */
class GetQueryReportResults extends AbstractStructBase
{
    /**
     * The queryReportId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $queryReportId;
    /**
     * The queryReportParams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfsecureWebService_QueryReportParameter
     */
    public $queryReportParams;
    /**
     * The returnType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $returnType;
    /**
     * Constructor method for GetQueryReportResults
     * @uses GetQueryReportResults::setQueryReportId()
     * @uses GetQueryReportResults::setQueryReportParams()
     * @uses GetQueryReportResults::setReturnType()
     * @param int $queryReportId
     * @param \ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams
     * @param string $returnType
     */
    public function __construct($queryReportId = null, \ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams = null, $returnType = null)
    {
        $this
            ->setQueryReportId($queryReportId)
            ->setQueryReportParams($queryReportParams)
            ->setReturnType($returnType);
    }
    /**
     * Get queryReportId value
     * @return int|null
     */
    public function getQueryReportId()
    {
        return $this->queryReportId;
    }
    /**
     * Set queryReportId value
     * @param int $queryReportId
     * @return \StructType\GetQueryReportResults
     */
    public function setQueryReportId($queryReportId = null)
    {
        // validation for constraint: int
        if (!is_null($queryReportId) && !(is_int($queryReportId) || ctype_digit($queryReportId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queryReportId, true), gettype($queryReportId)), __LINE__);
        }
        $this->queryReportId = $queryReportId;
        return $this;
    }
    /**
     * Get queryReportParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfsecureWebService_QueryReportParameter|null
     */
    public function getQueryReportParams()
    {
        return isset($this->queryReportParams) ? $this->queryReportParams : null;
    }
    /**
     * Set queryReportParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams
     * @return \StructType\GetQueryReportResults
     */
    public function setQueryReportParams(\ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams = null)
    {
        if (is_null($queryReportParams) || (is_array($queryReportParams) && empty($queryReportParams))) {
            unset($this->queryReportParams);
        } else {
            $this->queryReportParams = $queryReportParams;
        }
        return $this;
    }
    /**
     * Get returnType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnType()
    {
        return isset($this->returnType) ? $this->returnType : null;
    }
    /**
     * Set returnType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnType
     * @return \StructType\GetQueryReportResults
     */
    public function setReturnType($returnType = null)
    {
        // validation for constraint: string
        if (!is_null($returnType) && !is_string($returnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnType, true), gettype($returnType)), __LINE__);
        }
        if (is_null($returnType) || (is_array($returnType) && empty($returnType))) {
            unset($this->returnType);
        } else {
            $this->returnType = $returnType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQueryReportResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
