<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPolicyPayments StructType
 * @subpackage Structs
 */
class GetPolicyPayments extends AbstractStructBase
{
    /**
     * The policyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyId;
    /**
     * The statusFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $statusFilter;
    /**
     * The typeFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $typeFilter;
    /**
     * Constructor method for GetPolicyPayments
     * @uses GetPolicyPayments::setPolicyId()
     * @uses GetPolicyPayments::setStatusFilter()
     * @uses GetPolicyPayments::setTypeFilter()
     * @param int $policyId
     * @param string $statusFilter
     * @param string $typeFilter
     */
    public function __construct($policyId = null, $statusFilter = null, $typeFilter = null)
    {
        $this
            ->setPolicyId($policyId)
            ->setStatusFilter($statusFilter)
            ->setTypeFilter($typeFilter);
    }
    /**
     * Get policyId value
     * @return int|null
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }
    /**
     * Set policyId value
     * @param int $policyId
     * @return \StructType\GetPolicyPayments
     */
    public function setPolicyId($policyId = null)
    {
        // validation for constraint: int
        if (!is_null($policyId) && !(is_int($policyId) || ctype_digit($policyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyId, true), gettype($policyId)), __LINE__);
        }
        $this->policyId = $policyId;
        return $this;
    }
    /**
     * Get statusFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusFilter()
    {
        return isset($this->statusFilter) ? $this->statusFilter : null;
    }
    /**
     * Set statusFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusFilter
     * @return \StructType\GetPolicyPayments
     */
    public function setStatusFilter($statusFilter = null)
    {
        // validation for constraint: string
        if (!is_null($statusFilter) && !is_string($statusFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusFilter, true), gettype($statusFilter)), __LINE__);
        }
        if (is_null($statusFilter) || (is_array($statusFilter) && empty($statusFilter))) {
            unset($this->statusFilter);
        } else {
            $this->statusFilter = $statusFilter;
        }
        return $this;
    }
    /**
     * Get typeFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeFilter()
    {
        return isset($this->typeFilter) ? $this->typeFilter : null;
    }
    /**
     * Set typeFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeFilter
     * @return \StructType\GetPolicyPayments
     */
    public function setTypeFilter($typeFilter = null)
    {
        // validation for constraint: string
        if (!is_null($typeFilter) && !is_string($typeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeFilter, true), gettype($typeFilter)), __LINE__);
        }
        if (is_null($typeFilter) || (is_array($typeFilter) && empty($typeFilter))) {
            unset($this->typeFilter);
        } else {
            $this->typeFilter = $typeFilter;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPolicyPayments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
