<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPolicy StructType
 * @subpackage Structs
 */
class CancelPolicy extends AbstractStructBase
{
    /**
     * The quoteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quoteId;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $policyNumber;
    /**
     * The cancelOdometer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $cancelOdometer;
    /**
     * The cancelReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cancelReason;
    /**
     * The cancelEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cancelEffectiveDate;
    /**
     * The odomStmtReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $odomStmtReceived;
    /**
     * The claimsPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $claimsPaid;
    /**
     * The marketerCanFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $marketerCanFees;
    /**
     * The additionalFinFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $additionalFinFees;
    /**
     * The balancePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $balancePaid;
    /**
     * The cancelNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cancelNote;
    /**
     * Constructor method for CancelPolicy
     * @uses CancelPolicy::setQuoteId()
     * @uses CancelPolicy::setPolicyNumber()
     * @uses CancelPolicy::setCancelOdometer()
     * @uses CancelPolicy::setCancelReason()
     * @uses CancelPolicy::setCancelEffectiveDate()
     * @uses CancelPolicy::setOdomStmtReceived()
     * @uses CancelPolicy::setClaimsPaid()
     * @uses CancelPolicy::setMarketerCanFees()
     * @uses CancelPolicy::setAdditionalFinFees()
     * @uses CancelPolicy::setBalancePaid()
     * @uses CancelPolicy::setCancelNote()
     * @param int $quoteId
     * @param string $policyNumber
     * @param int $cancelOdometer
     * @param string $cancelReason
     * @param string $cancelEffectiveDate
     * @param bool $odomStmtReceived
     * @param float $claimsPaid
     * @param float $marketerCanFees
     * @param float $additionalFinFees
     * @param float $balancePaid
     * @param string $cancelNote
     */
    public function __construct($quoteId = null, $policyNumber = null, $cancelOdometer = null, $cancelReason = null, $cancelEffectiveDate = null, $odomStmtReceived = null, $claimsPaid = null, $marketerCanFees = null, $additionalFinFees = null, $balancePaid = null, $cancelNote = null)
    {
        $this
            ->setQuoteId($quoteId)
            ->setPolicyNumber($policyNumber)
            ->setCancelOdometer($cancelOdometer)
            ->setCancelReason($cancelReason)
            ->setCancelEffectiveDate($cancelEffectiveDate)
            ->setOdomStmtReceived($odomStmtReceived)
            ->setClaimsPaid($claimsPaid)
            ->setMarketerCanFees($marketerCanFees)
            ->setAdditionalFinFees($additionalFinFees)
            ->setBalancePaid($balancePaid)
            ->setCancelNote($cancelNote);
    }
    /**
     * Get quoteId value
     * @return int|null
     */
    public function getQuoteId()
    {
        return $this->quoteId;
    }
    /**
     * Set quoteId value
     * @param int $quoteId
     * @return \StructType\CancelPolicy
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !(is_int($quoteId) || ctype_digit($quoteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        $this->quoteId = $quoteId;
        return $this;
    }
    /**
     * Get policyNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return isset($this->policyNumber) ? $this->policyNumber : null;
    }
    /**
     * Set policyNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $policyNumber
     * @return \StructType\CancelPolicy
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        if (is_null($policyNumber) || (is_array($policyNumber) && empty($policyNumber))) {
            unset($this->policyNumber);
        } else {
            $this->policyNumber = $policyNumber;
        }
        return $this;
    }
    /**
     * Get cancelOdometer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCancelOdometer()
    {
        return isset($this->cancelOdometer) ? $this->cancelOdometer : null;
    }
    /**
     * Set cancelOdometer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cancelOdometer
     * @return \StructType\CancelPolicy
     */
    public function setCancelOdometer($cancelOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($cancelOdometer) && !(is_int($cancelOdometer) || ctype_digit($cancelOdometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cancelOdometer, true), gettype($cancelOdometer)), __LINE__);
        }
        if (is_null($cancelOdometer) || (is_array($cancelOdometer) && empty($cancelOdometer))) {
            unset($this->cancelOdometer);
        } else {
            $this->cancelOdometer = $cancelOdometer;
        }
        return $this;
    }
    /**
     * Get cancelReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelReason()
    {
        return isset($this->cancelReason) ? $this->cancelReason : null;
    }
    /**
     * Set cancelReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelReason
     * @return \StructType\CancelPolicy
     */
    public function setCancelReason($cancelReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancelReason) && !is_string($cancelReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelReason, true), gettype($cancelReason)), __LINE__);
        }
        if (is_null($cancelReason) || (is_array($cancelReason) && empty($cancelReason))) {
            unset($this->cancelReason);
        } else {
            $this->cancelReason = $cancelReason;
        }
        return $this;
    }
    /**
     * Get cancelEffectiveDate value
     * @return string|null
     */
    public function getCancelEffectiveDate()
    {
        return $this->cancelEffectiveDate;
    }
    /**
     * Set cancelEffectiveDate value
     * @param string $cancelEffectiveDate
     * @return \StructType\CancelPolicy
     */
    public function setCancelEffectiveDate($cancelEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelEffectiveDate) && !is_string($cancelEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelEffectiveDate, true), gettype($cancelEffectiveDate)), __LINE__);
        }
        $this->cancelEffectiveDate = $cancelEffectiveDate;
        return $this;
    }
    /**
     * Get odomStmtReceived value
     * @return bool|null
     */
    public function getOdomStmtReceived()
    {
        return $this->odomStmtReceived;
    }
    /**
     * Set odomStmtReceived value
     * @param bool $odomStmtReceived
     * @return \StructType\CancelPolicy
     */
    public function setOdomStmtReceived($odomStmtReceived = null)
    {
        // validation for constraint: boolean
        if (!is_null($odomStmtReceived) && !is_bool($odomStmtReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($odomStmtReceived, true), gettype($odomStmtReceived)), __LINE__);
        }
        $this->odomStmtReceived = $odomStmtReceived;
        return $this;
    }
    /**
     * Get claimsPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getClaimsPaid()
    {
        return isset($this->claimsPaid) ? $this->claimsPaid : null;
    }
    /**
     * Set claimsPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $claimsPaid
     * @return \StructType\CancelPolicy
     */
    public function setClaimsPaid($claimsPaid = null)
    {
        // validation for constraint: float
        if (!is_null($claimsPaid) && !(is_float($claimsPaid) || is_numeric($claimsPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($claimsPaid, true), gettype($claimsPaid)), __LINE__);
        }
        if (is_null($claimsPaid) || (is_array($claimsPaid) && empty($claimsPaid))) {
            unset($this->claimsPaid);
        } else {
            $this->claimsPaid = $claimsPaid;
        }
        return $this;
    }
    /**
     * Get marketerCanFees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMarketerCanFees()
    {
        return isset($this->marketerCanFees) ? $this->marketerCanFees : null;
    }
    /**
     * Set marketerCanFees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $marketerCanFees
     * @return \StructType\CancelPolicy
     */
    public function setMarketerCanFees($marketerCanFees = null)
    {
        // validation for constraint: float
        if (!is_null($marketerCanFees) && !(is_float($marketerCanFees) || is_numeric($marketerCanFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($marketerCanFees, true), gettype($marketerCanFees)), __LINE__);
        }
        if (is_null($marketerCanFees) || (is_array($marketerCanFees) && empty($marketerCanFees))) {
            unset($this->marketerCanFees);
        } else {
            $this->marketerCanFees = $marketerCanFees;
        }
        return $this;
    }
    /**
     * Get additionalFinFees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAdditionalFinFees()
    {
        return isset($this->additionalFinFees) ? $this->additionalFinFees : null;
    }
    /**
     * Set additionalFinFees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $additionalFinFees
     * @return \StructType\CancelPolicy
     */
    public function setAdditionalFinFees($additionalFinFees = null)
    {
        // validation for constraint: float
        if (!is_null($additionalFinFees) && !(is_float($additionalFinFees) || is_numeric($additionalFinFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionalFinFees, true), gettype($additionalFinFees)), __LINE__);
        }
        if (is_null($additionalFinFees) || (is_array($additionalFinFees) && empty($additionalFinFees))) {
            unset($this->additionalFinFees);
        } else {
            $this->additionalFinFees = $additionalFinFees;
        }
        return $this;
    }
    /**
     * Get balancePaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBalancePaid()
    {
        return isset($this->balancePaid) ? $this->balancePaid : null;
    }
    /**
     * Set balancePaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $balancePaid
     * @return \StructType\CancelPolicy
     */
    public function setBalancePaid($balancePaid = null)
    {
        // validation for constraint: float
        if (!is_null($balancePaid) && !(is_float($balancePaid) || is_numeric($balancePaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balancePaid, true), gettype($balancePaid)), __LINE__);
        }
        if (is_null($balancePaid) || (is_array($balancePaid) && empty($balancePaid))) {
            unset($this->balancePaid);
        } else {
            $this->balancePaid = $balancePaid;
        }
        return $this;
    }
    /**
     * Get cancelNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelNote()
    {
        return isset($this->cancelNote) ? $this->cancelNote : null;
    }
    /**
     * Set cancelNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelNote
     * @return \StructType\CancelPolicy
     */
    public function setCancelNote($cancelNote = null)
    {
        // validation for constraint: string
        if (!is_null($cancelNote) && !is_string($cancelNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelNote, true), gettype($cancelNote)), __LINE__);
        }
        if (is_null($cancelNote) || (is_array($cancelNote) && empty($cancelNote))) {
            unset($this->cancelNote);
        } else {
            $this->cancelNote = $cancelNote;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
