<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseEntity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseEntity
 * @subpackage Structs
 */
class BaseEntity extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $Address;
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AddressId;
    /**
     * The Disposition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Disposition;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $Entity;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityId;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The FullNameFL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullNameFL;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The Phone1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone1;
    /**
     * The Phone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone2;
    /**
     * The Prefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefix;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * Constructor method for BaseEntity
     * @uses BaseEntity::setAddress()
     * @uses BaseEntity::setAddressId()
     * @uses BaseEntity::setDisposition()
     * @uses BaseEntity::setEmail()
     * @uses BaseEntity::setEntity()
     * @uses BaseEntity::setEntityId()
     * @uses BaseEntity::setEntityType()
     * @uses BaseEntity::setFirstName()
     * @uses BaseEntity::setFullNameFL()
     * @uses BaseEntity::setLastName()
     * @uses BaseEntity::setMiddleName()
     * @uses BaseEntity::setPhone1()
     * @uses BaseEntity::setPhone2()
     * @uses BaseEntity::setPrefix()
     * @uses BaseEntity::setStatus()
     * @uses BaseEntity::setSuffix()
     * @param mixed $address
     * @param int $addressId
     * @param string $disposition
     * @param string $email
     * @param mixed $entity
     * @param int $entityId
     * @param string $entityType
     * @param string $firstName
     * @param string $fullNameFL
     * @param string $lastName
     * @param string $middleName
     * @param string $phone1
     * @param string $phone2
     * @param string $prefix
     * @param string $status
     * @param string $suffix
     */
    public function __construct($address = null, $addressId = null, $disposition = null, $email = null, $entity = null, $entityId = null, $entityType = null, $firstName = null, $fullNameFL = null, $lastName = null, $middleName = null, $phone1 = null, $phone2 = null, $prefix = null, $status = null, $suffix = null)
    {
        $this
            ->setAddress($address)
            ->setAddressId($addressId)
            ->setDisposition($disposition)
            ->setEmail($email)
            ->setEntity($entity)
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setFirstName($firstName)
            ->setFullNameFL($fullNameFL)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setPhone1($phone1)
            ->setPhone2($phone2)
            ->setPrefix($prefix)
            ->setStatus($status)
            ->setSuffix($suffix);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $address
     * @return \StructType\BaseEntity
     */
    public function setAddress($address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAddressId()
    {
        return isset($this->AddressId) ? $this->AddressId : null;
    }
    /**
     * Set AddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $addressId
     * @return \StructType\BaseEntity
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        if (is_null($addressId) || (is_array($addressId) && empty($addressId))) {
            unset($this->AddressId);
        } else {
            $this->AddressId = $addressId;
        }
        return $this;
    }
    /**
     * Get Disposition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisposition()
    {
        return isset($this->Disposition) ? $this->Disposition : null;
    }
    /**
     * Set Disposition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $disposition
     * @return \StructType\BaseEntity
     */
    public function setDisposition($disposition = null)
    {
        // validation for constraint: string
        if (!is_null($disposition) && !is_string($disposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disposition, true), gettype($disposition)), __LINE__);
        }
        if (is_null($disposition) || (is_array($disposition) && empty($disposition))) {
            unset($this->Disposition);
        } else {
            $this->Disposition = $disposition;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\BaseEntity
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Entity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getEntity()
    {
        return isset($this->Entity) ? $this->Entity : null;
    }
    /**
     * Set Entity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $entity
     * @return \StructType\BaseEntity
     */
    public function setEntity($entity = null)
    {
        if (is_null($entity) || (is_array($entity) && empty($entity))) {
            unset($this->Entity);
        } else {
            $this->Entity = $entity;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\BaseEntity
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\BaseEntity
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\BaseEntity
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get FullNameFL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullNameFL()
    {
        return isset($this->FullNameFL) ? $this->FullNameFL : null;
    }
    /**
     * Set FullNameFL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullNameFL
     * @return \StructType\BaseEntity
     */
    public function setFullNameFL($fullNameFL = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameFL) && !is_string($fullNameFL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameFL, true), gettype($fullNameFL)), __LINE__);
        }
        if (is_null($fullNameFL) || (is_array($fullNameFL) && empty($fullNameFL))) {
            unset($this->FullNameFL);
        } else {
            $this->FullNameFL = $fullNameFL;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\BaseEntity
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \StructType\BaseEntity
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get Phone1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone1()
    {
        return isset($this->Phone1) ? $this->Phone1 : null;
    }
    /**
     * Set Phone1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone1
     * @return \StructType\BaseEntity
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        if (is_null($phone1) || (is_array($phone1) && empty($phone1))) {
            unset($this->Phone1);
        } else {
            $this->Phone1 = $phone1;
        }
        return $this;
    }
    /**
     * Get Phone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone2()
    {
        return isset($this->Phone2) ? $this->Phone2 : null;
    }
    /**
     * Set Phone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone2
     * @return \StructType\BaseEntity
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        if (is_null($phone2) || (is_array($phone2) && empty($phone2))) {
            unset($this->Phone2);
        } else {
            $this->Phone2 = $phone2;
        }
        return $this;
    }
    /**
     * Get Prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->Prefix) ? $this->Prefix : null;
    }
    /**
     * Set Prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \StructType\BaseEntity
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->Prefix);
        } else {
            $this->Prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\BaseEntity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \StructType\BaseEntity
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
