<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Attachment
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountId;
    /**
     * The AttachmentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AttachmentId;
    /**
     * The CertFileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CertFileName;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ESignData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ESignData;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The FilePath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilePath;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FileSize;
    /**
     * The MetaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetaData;
    /**
     * The PolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PolicyId;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setAccountId()
     * @uses Attachment::setAttachmentId()
     * @uses Attachment::setCertFileName()
     * @uses Attachment::setCreateDate()
     * @uses Attachment::setCreateUserId()
     * @uses Attachment::setDescription()
     * @uses Attachment::setESignData()
     * @uses Attachment::setFileName()
     * @uses Attachment::setFilePath()
     * @uses Attachment::setFileSize()
     * @uses Attachment::setMetaData()
     * @uses Attachment::setPolicyId()
     * @uses Attachment::setType()
     * @param int $accountId
     * @param int $attachmentId
     * @param string $certFileName
     * @param string $createDate
     * @param string $createUserId
     * @param string $description
     * @param string $eSignData
     * @param string $fileName
     * @param string $filePath
     * @param int $fileSize
     * @param string $metaData
     * @param int $policyId
     * @param string $type
     */
    public function __construct($accountId = null, $attachmentId = null, $certFileName = null, $createDate = null, $createUserId = null, $description = null, $eSignData = null, $fileName = null, $filePath = null, $fileSize = null, $metaData = null, $policyId = null, $type = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAttachmentId($attachmentId)
            ->setCertFileName($certFileName)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setDescription($description)
            ->setESignData($eSignData)
            ->setFileName($fileName)
            ->setFilePath($filePath)
            ->setFileSize($fileSize)
            ->setMetaData($metaData)
            ->setPolicyId($policyId)
            ->setType($type);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountId
     * @return \StructType\Attachment
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get AttachmentId value
     * @return int|null
     */
    public function getAttachmentId()
    {
        return $this->AttachmentId;
    }
    /**
     * Set AttachmentId value
     * @param int $attachmentId
     * @return \StructType\Attachment
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentId) && !(is_int($attachmentId) || ctype_digit($attachmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        $this->AttachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get CertFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertFileName()
    {
        return isset($this->CertFileName) ? $this->CertFileName : null;
    }
    /**
     * Set CertFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $certFileName
     * @return \StructType\Attachment
     */
    public function setCertFileName($certFileName = null)
    {
        // validation for constraint: string
        if (!is_null($certFileName) && !is_string($certFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certFileName, true), gettype($certFileName)), __LINE__);
        }
        if (is_null($certFileName) || (is_array($certFileName) && empty($certFileName))) {
            unset($this->CertFileName);
        } else {
            $this->CertFileName = $certFileName;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Attachment
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\Attachment
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Attachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ESignData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getESignData()
    {
        return isset($this->ESignData) ? $this->ESignData : null;
    }
    /**
     * Set ESignData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eSignData
     * @return \StructType\Attachment
     */
    public function setESignData($eSignData = null)
    {
        // validation for constraint: string
        if (!is_null($eSignData) && !is_string($eSignData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eSignData, true), gettype($eSignData)), __LINE__);
        }
        if (is_null($eSignData) || (is_array($eSignData) && empty($eSignData))) {
            unset($this->ESignData);
        } else {
            $this->ESignData = $eSignData;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \StructType\Attachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get FilePath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilePath()
    {
        return isset($this->FilePath) ? $this->FilePath : null;
    }
    /**
     * Set FilePath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filePath
     * @return \StructType\Attachment
     */
    public function setFilePath($filePath = null)
    {
        // validation for constraint: string
        if (!is_null($filePath) && !is_string($filePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filePath, true), gettype($filePath)), __LINE__);
        }
        if (is_null($filePath) || (is_array($filePath) && empty($filePath))) {
            unset($this->FilePath);
        } else {
            $this->FilePath = $filePath;
        }
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\Attachment
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get MetaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetaData()
    {
        return isset($this->MetaData) ? $this->MetaData : null;
    }
    /**
     * Set MetaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metaData
     * @return \StructType\Attachment
     */
    public function setMetaData($metaData = null)
    {
        // validation for constraint: string
        if (!is_null($metaData) && !is_string($metaData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaData, true), gettype($metaData)), __LINE__);
        }
        if (is_null($metaData) || (is_array($metaData) && empty($metaData))) {
            unset($this->MetaData);
        } else {
            $this->MetaData = $metaData;
        }
        return $this;
    }
    /**
     * Get PolicyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPolicyId()
    {
        return isset($this->PolicyId) ? $this->PolicyId : null;
    }
    /**
     * Set PolicyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $policyId
     * @return \StructType\Attachment
     */
    public function setPolicyId($policyId = null)
    {
        // validation for constraint: int
        if (!is_null($policyId) && !(is_int($policyId) || ctype_digit($policyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyId, true), gettype($policyId)), __LINE__);
        }
        if (is_null($policyId) || (is_array($policyId) && empty($policyId))) {
            unset($this->PolicyId);
        } else {
            $this->PolicyId = $policyId;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\Attachment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
