<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Account
 * @subpackage Structs
 */
class Account extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AddressId;
    /**
     * The DBANAME
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DBANAME;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The ParentAccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentAccountId;
    /**
     * The Phone1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone1;
    /**
     * The Phone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone2;
    /**
     * The Phone3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone3;
    /**
     * The Phone4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone4;
    /**
     * The Phone5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone5;
    /**
     * The ReadOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReadOnly;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebSite;
    /**
     * The WebSite2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebSite2;
    /**
     * Constructor method for Account
     * @uses Account::setAccountId()
     * @uses Account::setAccountName()
     * @uses Account::setAddressId()
     * @uses Account::setDBANAME()
     * @uses Account::setEmail()
     * @uses Account::setExternalId()
     * @uses Account::setFax()
     * @uses Account::setParentAccountId()
     * @uses Account::setPhone1()
     * @uses Account::setPhone2()
     * @uses Account::setPhone3()
     * @uses Account::setPhone4()
     * @uses Account::setPhone5()
     * @uses Account::setReadOnly()
     * @uses Account::setShortName()
     * @uses Account::setStatus()
     * @uses Account::setType()
     * @uses Account::setWebSite()
     * @uses Account::setWebSite2()
     * @param int $accountId
     * @param string $accountName
     * @param int $addressId
     * @param string $dBANAME
     * @param string $email
     * @param string $externalId
     * @param string $fax
     * @param int $parentAccountId
     * @param string $phone1
     * @param string $phone2
     * @param string $phone3
     * @param string $phone4
     * @param string $phone5
     * @param bool $readOnly
     * @param string $shortName
     * @param string $status
     * @param string $type
     * @param string $webSite
     * @param string $webSite2
     */
    public function __construct($accountId = null, $accountName = null, $addressId = null, $dBANAME = null, $email = null, $externalId = null, $fax = null, $parentAccountId = null, $phone1 = null, $phone2 = null, $phone3 = null, $phone4 = null, $phone5 = null, $readOnly = null, $shortName = null, $status = null, $type = null, $webSite = null, $webSite2 = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAccountName($accountName)
            ->setAddressId($addressId)
            ->setDBANAME($dBANAME)
            ->setEmail($email)
            ->setExternalId($externalId)
            ->setFax($fax)
            ->setParentAccountId($parentAccountId)
            ->setPhone1($phone1)
            ->setPhone2($phone2)
            ->setPhone3($phone3)
            ->setPhone4($phone4)
            ->setPhone5($phone5)
            ->setReadOnly($readOnly)
            ->setShortName($shortName)
            ->setStatus($status)
            ->setType($type)
            ->setWebSite($webSite)
            ->setWebSite2($webSite2);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\Account
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \StructType\Account
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAddressId()
    {
        return isset($this->AddressId) ? $this->AddressId : null;
    }
    /**
     * Set AddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $addressId
     * @return \StructType\Account
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        if (is_null($addressId) || (is_array($addressId) && empty($addressId))) {
            unset($this->AddressId);
        } else {
            $this->AddressId = $addressId;
        }
        return $this;
    }
    /**
     * Get DBANAME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDBANAME()
    {
        return isset($this->DBANAME) ? $this->DBANAME : null;
    }
    /**
     * Set DBANAME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dBANAME
     * @return \StructType\Account
     */
    public function setDBANAME($dBANAME = null)
    {
        // validation for constraint: string
        if (!is_null($dBANAME) && !is_string($dBANAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dBANAME, true), gettype($dBANAME)), __LINE__);
        }
        if (is_null($dBANAME) || (is_array($dBANAME) && empty($dBANAME))) {
            unset($this->DBANAME);
        } else {
            $this->DBANAME = $dBANAME;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\Account
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \StructType\Account
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \StructType\Account
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get ParentAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentAccountId()
    {
        return isset($this->ParentAccountId) ? $this->ParentAccountId : null;
    }
    /**
     * Set ParentAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentAccountId
     * @return \StructType\Account
     */
    public function setParentAccountId($parentAccountId = null)
    {
        // validation for constraint: int
        if (!is_null($parentAccountId) && !(is_int($parentAccountId) || ctype_digit($parentAccountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentAccountId, true), gettype($parentAccountId)), __LINE__);
        }
        if (is_null($parentAccountId) || (is_array($parentAccountId) && empty($parentAccountId))) {
            unset($this->ParentAccountId);
        } else {
            $this->ParentAccountId = $parentAccountId;
        }
        return $this;
    }
    /**
     * Get Phone1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone1()
    {
        return isset($this->Phone1) ? $this->Phone1 : null;
    }
    /**
     * Set Phone1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone1
     * @return \StructType\Account
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        if (is_null($phone1) || (is_array($phone1) && empty($phone1))) {
            unset($this->Phone1);
        } else {
            $this->Phone1 = $phone1;
        }
        return $this;
    }
    /**
     * Get Phone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone2()
    {
        return isset($this->Phone2) ? $this->Phone2 : null;
    }
    /**
     * Set Phone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone2
     * @return \StructType\Account
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        if (is_null($phone2) || (is_array($phone2) && empty($phone2))) {
            unset($this->Phone2);
        } else {
            $this->Phone2 = $phone2;
        }
        return $this;
    }
    /**
     * Get Phone3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone3()
    {
        return isset($this->Phone3) ? $this->Phone3 : null;
    }
    /**
     * Set Phone3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone3
     * @return \StructType\Account
     */
    public function setPhone3($phone3 = null)
    {
        // validation for constraint: string
        if (!is_null($phone3) && !is_string($phone3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone3, true), gettype($phone3)), __LINE__);
        }
        if (is_null($phone3) || (is_array($phone3) && empty($phone3))) {
            unset($this->Phone3);
        } else {
            $this->Phone3 = $phone3;
        }
        return $this;
    }
    /**
     * Get Phone4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone4()
    {
        return isset($this->Phone4) ? $this->Phone4 : null;
    }
    /**
     * Set Phone4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone4
     * @return \StructType\Account
     */
    public function setPhone4($phone4 = null)
    {
        // validation for constraint: string
        if (!is_null($phone4) && !is_string($phone4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone4, true), gettype($phone4)), __LINE__);
        }
        if (is_null($phone4) || (is_array($phone4) && empty($phone4))) {
            unset($this->Phone4);
        } else {
            $this->Phone4 = $phone4;
        }
        return $this;
    }
    /**
     * Get Phone5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone5()
    {
        return isset($this->Phone5) ? $this->Phone5 : null;
    }
    /**
     * Set Phone5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone5
     * @return \StructType\Account
     */
    public function setPhone5($phone5 = null)
    {
        // validation for constraint: string
        if (!is_null($phone5) && !is_string($phone5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone5, true), gettype($phone5)), __LINE__);
        }
        if (is_null($phone5) || (is_array($phone5) && empty($phone5))) {
            unset($this->Phone5);
        } else {
            $this->Phone5 = $phone5;
        }
        return $this;
    }
    /**
     * Get ReadOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReadOnly()
    {
        return isset($this->ReadOnly) ? $this->ReadOnly : null;
    }
    /**
     * Set ReadOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $readOnly
     * @return \StructType\Account
     */
    public function setReadOnly($readOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($readOnly) && !is_bool($readOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($readOnly, true), gettype($readOnly)), __LINE__);
        }
        if (is_null($readOnly) || (is_array($readOnly) && empty($readOnly))) {
            unset($this->ReadOnly);
        } else {
            $this->ReadOnly = $readOnly;
        }
        return $this;
    }
    /**
     * Get ShortName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortName()
    {
        return isset($this->ShortName) ? $this->ShortName : null;
    }
    /**
     * Set ShortName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortName
     * @return \StructType\Account
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        if (is_null($shortName) || (is_array($shortName) && empty($shortName))) {
            unset($this->ShortName);
        } else {
            $this->ShortName = $shortName;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\Account
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\Account
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get WebSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebSite()
    {
        return isset($this->WebSite) ? $this->WebSite : null;
    }
    /**
     * Set WebSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webSite
     * @return \StructType\Account
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        if (is_null($webSite) || (is_array($webSite) && empty($webSite))) {
            unset($this->WebSite);
        } else {
            $this->WebSite = $webSite;
        }
        return $this;
    }
    /**
     * Get WebSite2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebSite2()
    {
        return isset($this->WebSite2) ? $this->WebSite2 : null;
    }
    /**
     * Set WebSite2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webSite2
     * @return \StructType\Account
     */
    public function setWebSite2($webSite2 = null)
    {
        // validation for constraint: string
        if (!is_null($webSite2) && !is_string($webSite2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite2, true), gettype($webSite2)), __LINE__);
        }
        if (is_null($webSite2) || (is_array($webSite2) && empty($webSite2))) {
            unset($this->WebSite2);
        } else {
            $this->WebSite2 = $webSite2;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Account
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
