<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Sets the FileName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $fileName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderFileName($fileName, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'FileName', $fileName, $mustUnderstand, $actor);
    }
    /**
     * Sets the Length SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $length
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLength($length, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Length', $length, $mustUnderstand, $actor);
    }
    /**
     * Sets the Description SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $description
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDescription($description, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'description', $description, $mustUnderstand, $actor);
    }
    /**
     * Sets the PolicyId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $policyId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPolicyId($policyId, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'policyId', $policyId, $mustUnderstand, $actor);
    }
    /**
     * Sets the Type SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $type
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderType($type, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'type', $type, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named InsertVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertVehicle $parameters
     * @return \StructType\InsertVehicleResponse|bool
     */
    public function InsertVehicle(\StructType\InsertVehicle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCampaignTarget
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertCampaignTarget $parameters
     * @return \StructType\InsertCampaignTargetResponse|bool
     */
    public function InsertCampaignTarget(\StructType\InsertCampaignTarget $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertCampaignTarget($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertTargetResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertTargetResponse $parameters
     * @return \StructType\InsertTargetResponseResponse|bool
     */
    public function InsertTargetResponse(\StructType\InsertTargetResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertTargetResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertQuote $parameters
     * @return \StructType\InsertQuoteResponse|bool
     */
    public function InsertQuote(\StructType\InsertQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertQuoteAndEntity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertQuoteAndEntity $parameters
     * @return \StructType\InsertQuoteAndEntityResponse|bool
     */
    public function InsertQuoteAndEntity(\StructType\InsertQuoteAndEntity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertQuoteAndEntity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertQuotePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertQuotePayment $parameters
     * @return \StructType\InsertQuotePaymentResponse|bool
     */
    public function InsertQuotePayment(\StructType\InsertQuotePayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertQuotePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertPolicyPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertPolicyPayment $parameters
     * @return \StructType\InsertPolicyPaymentResponse|bool
     */
    public function InsertPolicyPayment(\StructType\InsertPolicyPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertPolicyPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertNote $parameters
     * @return \StructType\InsertNoteResponse|bool
     */
    public function InsertNote(\StructType\InsertNote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertAttachment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: FileName, Length, description, policyId, type
     * - SOAPHeaderNamespaces: http://tempuri.org/, http://tempuri.org/, http://tempuri.org/, http://tempuri.org/, http://tempuri.org/
     * - SOAPHeaderTypes: string, long, string, int, string
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentFileInfo $parameters
     * @return void|bool
     */
    public function InsertAttachment(\StructType\AttachmentFileInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertPhoneCall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertPhoneCall $parameters
     * @return \StructType\InsertPhoneCallResponse|bool
     */
    public function InsertPhoneCall(\StructType\InsertPhoneCall $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertPhoneCall($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertEntityIntoQueue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertEntityIntoQueue $parameters
     * @return \StructType\InsertEntityIntoQueueResponse|bool
     */
    public function InsertEntityIntoQueue(\StructType\InsertEntityIntoQueue $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertEntityIntoQueue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void|\StructType\InsertCampaignTargetResponse|\StructType\InsertEntityIntoQueueResponse|\StructType\InsertNoteResponse|\StructType\InsertPhoneCallResponse|\StructType\InsertPolicyPaymentResponse|\StructType\InsertQuoteAndEntityResponse|\StructType\InsertQuotePaymentResponse|\StructType\InsertQuoteResponse|\StructType\InsertTargetResponseResponse|\StructType\InsertVehicleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
