<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetVehicleModelsByMake
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleModelsByMake $parameters
     * @return \StructType\GetVehicleModelsByMakeResponse|bool
     */
    public function GetVehicleModelsByMake(\StructType\GetVehicleModelsByMake $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVehicleModelsByMake($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleMakes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleMakes $parameters
     * @return \StructType\GetVehicleMakesResponse|bool
     */
    public function GetVehicleMakes(\StructType\GetVehicleMakes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVehicleMakes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleTrimLevelsByModel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleTrimLevelsByModel $parameters
     * @return \StructType\GetVehicleTrimLevelsByModelResponse|bool
     */
    public function GetVehicleTrimLevelsByModel(\StructType\GetVehicleTrimLevelsByModel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVehicleTrimLevelsByModel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPickListValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPickListValues $parameters
     * @return \StructType\GetPickListValuesResponse|bool
     */
    public function GetPickListValues(\StructType\GetPickListValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPickListValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEntitiesByTargetDates2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntitiesByTargetDates2 $parameters
     * @return \StructType\GetEntitiesByTargetDates2Response|bool
     */
    public function GetEntitiesByTargetDates2(\StructType\GetEntitiesByTargetDates2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEntitiesByTargetDates2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEntitiesByTargetDates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntitiesByTargetDates $parameters
     * @return \StructType\GetEntitiesByTargetDatesResponse|bool
     */
    public function GetEntitiesByTargetDates(\StructType\GetEntitiesByTargetDates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEntitiesByTargetDates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEntityById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntityById $parameters
     * @return \StructType\GetEntityByIdResponse|bool
     */
    public function GetEntityById(\StructType\GetEntityById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEntityById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEntityByQuoteId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntityByQuoteId $parameters
     * @return \StructType\GetEntityByQuoteIdResponse|bool
     */
    public function GetEntityByQuoteId(\StructType\GetEntityByQuoteId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEntityByQuoteId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressById $parameters
     * @return \StructType\GetAddressByIdResponse|bool
     */
    public function GetAddressById(\StructType\GetAddressById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicles $parameters
     * @return \StructType\GetVehiclesResponse|bool
     */
    public function GetVehicles(\StructType\GetVehicles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMostRecentCampaignTarget
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMostRecentCampaignTarget $parameters
     * @return \StructType\GetMostRecentCampaignTargetResponse|bool
     */
    public function GetMostRecentCampaignTarget(\StructType\GetMostRecentCampaignTarget $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMostRecentCampaignTarget($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignTargetById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignTargetById $parameters
     * @return \StructType\GetCampaignTargetByIdResponse|bool
     */
    public function GetCampaignTargetById(\StructType\GetCampaignTargetById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignTargetById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRates1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRates1 $parameters
     * @return \StructType\GetRates1Response|bool
     */
    public function GetRates1(\StructType\GetRates1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRates1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRates2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRates2 $parameters
     * @return \StructType\GetRates2Response|bool
     */
    public function GetRates2(\StructType\GetRates2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRates2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRates3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRates3 $parameters
     * @return \StructType\GetRates3Response|bool
     */
    public function GetRates3(\StructType\GetRates3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRates3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTermsDocId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTermsDocId $parameters
     * @return \StructType\GetTermsDocIdResponse|bool
     */
    public function GetTermsDocId(\StructType\GetTermsDocId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTermsDocId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCoverageInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCoverageInfo $parameters
     * @return \StructType\GetCoverageInfoResponse|bool
     */
    public function GetCoverageInfo(\StructType\GetCoverageInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCoverageInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPolicyPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyPayments $parameters
     * @return \StructType\GetPolicyPaymentsResponse|bool
     */
    public function GetPolicyPayments(\StructType\GetPolicyPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPolicyPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPoliciesByDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoliciesByDateRange $parameters
     * @return \StructType\GetPoliciesByDateRangeResponse|bool
     */
    public function GetPoliciesByDateRange(\StructType\GetPoliciesByDateRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPoliciesByDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPoliciesByDateRange2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoliciesByDateRange2 $parameters
     * @return \StructType\GetPoliciesByDateRange2Response|bool
     */
    public function GetPoliciesByDateRange2(\StructType\GetPoliciesByDateRange2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPoliciesByDateRange2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPoliciesByDateRange3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoliciesByDateRange3 $parameters
     * @return \StructType\GetPoliciesByDateRange3Response|bool
     */
    public function GetPoliciesByDateRange3(\StructType\GetPoliciesByDateRange3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPoliciesByDateRange3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuoteById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuoteById $parameters
     * @return \StructType\GetQuoteByIdResponse|bool
     */
    public function GetQuoteById(\StructType\GetQuoteById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQuoteById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPolicyById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyById $parameters
     * @return \StructType\GetPolicyByIdResponse|bool
     */
    public function GetPolicyById(\StructType\GetPolicyById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPolicyById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNotes $parameters
     * @return \StructType\GetNotesResponse|bool
     */
    public function GetNotes(\StructType\GetNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispositions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDispositions $parameters
     * @return \StructType\GetDispositionsResponse|bool
     */
    public function GetDispositions(\StructType\GetDispositions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDispositions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecordQueueEntries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecordQueueEntries $parameters
     * @return \StructType\GetRecordQueueEntriesResponse|bool
     */
    public function GetRecordQueueEntries(\StructType\GetRecordQueueEntries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecordQueueEntries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccounts $parameters
     * @return \StructType\GetAccountsResponse|bool
     */
    public function GetAccounts(\StructType\GetAccounts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLeadSources
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLeadSources $parameters
     * @return \StructType\GetLeadSourcesResponse|bool
     */
    public function GetLeadSources(\StructType\GetLeadSources $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLeadSources($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaigns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaigns $parameters
     * @return \StructType\GetCampaignsResponse|bool
     */
    public function GetCampaigns(\StructType\GetCampaigns $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaigns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUsers $parameters
     * @return \StructType\GetUsersResponse|bool
     */
    public function GetUsers(\StructType\GetUsers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByUserId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserByUserId $parameters
     * @return \StructType\GetUserByUserIdResponse|bool
     */
    public function GetUserByUserId(\StructType\GetUserByUserId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserByUserId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPolicyAttachments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyAttachments $parameters
     * @return \StructType\GetPolicyAttachmentsResponse|bool
     */
    public function GetPolicyAttachments(\StructType\GetPolicyAttachments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPolicyAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttachment $parameters
     * @return \StructType\GetAttachmentResponse|bool
     */
    public function GetAttachment(\StructType\GetAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAttachmentDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttachmentDocument $parameters
     * @return \StructType\GetAttachmentDocumentResponse|bool
     */
    public function GetAttachmentDocument(\StructType\GetAttachmentDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAttachmentDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebTabResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebTabResults $parameters
     * @return \StructType\GetWebTabResultsResponse|bool
     */
    public function GetWebTabResults(\StructType\GetWebTabResults $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebTabResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQueryReportResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQueryReportResults $parameters
     * @return \StructType\GetQueryReportResultsResponse|bool
     */
    public function GetQueryReportResults(\StructType\GetQueryReportResults $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQueryReportResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountsResponse|\StructType\GetAddressByIdResponse|\StructType\GetAttachmentDocumentResponse|\StructType\GetAttachmentResponse|\StructType\GetCampaignsResponse|\StructType\GetCampaignTargetByIdResponse|\StructType\GetCoverageInfoResponse|\StructType\GetDispositionsResponse|\StructType\GetEntitiesByTargetDates2Response|\StructType\GetEntitiesByTargetDatesResponse|\StructType\GetEntityByIdResponse|\StructType\GetEntityByQuoteIdResponse|\StructType\GetLeadSourcesResponse|\StructType\GetMostRecentCampaignTargetResponse|\StructType\GetNotesResponse|\StructType\GetPickListValuesResponse|\StructType\GetPoliciesByDateRange2Response|\StructType\GetPoliciesByDateRange3Response|\StructType\GetPoliciesByDateRangeResponse|\StructType\GetPolicyAttachmentsResponse|\StructType\GetPolicyByIdResponse|\StructType\GetPolicyPaymentsResponse|\StructType\GetQueryReportResultsResponse|\StructType\GetQuoteByIdResponse|\StructType\GetRates1Response|\StructType\GetRates2Response|\StructType\GetRates3Response|\StructType\GetRecordQueueEntriesResponse|\StructType\GetTermsDocIdResponse|\StructType\GetUserByUserIdResponse|\StructType\GetUsersResponse|\StructType\GetVehicleMakesResponse|\StructType\GetVehicleModelsByMakeResponse|\StructType\GetVehiclesResponse|\StructType\GetVehicleTrimLevelsByModelResponse|\StructType\GetWebTabResultsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
