<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @subpackage Services
 */
class Convert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConvertLeadToContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConvertLeadToContact $parameters
     * @return \StructType\ConvertLeadToContactResponse|bool
     */
    public function ConvertLeadToContact(\StructType\ConvertLeadToContact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConvertLeadToContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConvertLeadVehicleToContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConvertLeadVehicleToContact $parameters
     * @return \StructType\ConvertLeadVehicleToContactResponse|bool
     */
    public function ConvertLeadVehicleToContact(\StructType\ConvertLeadVehicleToContact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConvertLeadVehicleToContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConvertLeadToContactResponse|\StructType\ConvertLeadVehicleToContactResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
