<?php

namespace EnumType;

/**
 * This class stands for VehicleType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VehicleType
 * @subpackage Enumerations
 */
class VehicleType
{
    /**
     * Constant for value 'Vehicle'
     * @return string 'Vehicle'
     */
    const VALUE_VEHICLE = 'Vehicle';
    /**
     * Constant for value 'RV'
     * @return string 'RV'
     */
    const VALUE_RV = 'RV';
    /**
     * Constant for value 'Home'
     * @return string 'Home'
     */
    const VALUE_HOME = 'Home';
    /**
     * Constant for value 'Motorcycle'
     * @return string 'Motorcycle'
     */
    const VALUE_MOTORCYCLE = 'Motorcycle';
    /**
     * Constant for value 'Commercial'
     * @return string 'Commercial'
     */
    const VALUE_COMMERCIAL = 'Commercial';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VEHICLE
     * @uses self::VALUE_RV
     * @uses self::VALUE_HOME
     * @uses self::VALUE_MOTORCYCLE
     * @uses self::VALUE_COMMERCIAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VEHICLE,
            self::VALUE_RV,
            self::VALUE_HOME,
            self::VALUE_MOTORCYCLE,
            self::VALUE_COMMERCIAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
