<?php

namespace EnumType;

/**
 * This class stands for UserStartPage EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserStartPage
 * @subpackage Enumerations
 */
class UserStartPage
{
    /**
     * Constant for value 'homepage'
     * @return string 'homepage'
     */
    const VALUE_HOMEPAGE = 'homepage';
    /**
     * Constant for value 'search'
     * @return string 'search'
     */
    const VALUE_SEARCH = 'search';
    /**
     * Constant for value 'genericQuote'
     * @return string 'genericQuote'
     */
    const VALUE_GENERIC_QUOTE = 'genericQuote';
    /**
     * Constant for value 'policy'
     * @return string 'policy'
     */
    const VALUE_POLICY = 'policy';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOMEPAGE
     * @uses self::VALUE_SEARCH
     * @uses self::VALUE_GENERIC_QUOTE
     * @uses self::VALUE_POLICY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOMEPAGE,
            self::VALUE_SEARCH,
            self::VALUE_GENERIC_QUOTE,
            self::VALUE_POLICY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
