<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePolicy StructType
 * @subpackage Structs
 */
class UpdatePolicy extends AbstractStructBase
{
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * Constructor method for UpdatePolicy
     * @uses UpdatePolicy::setPolicy()
     * @param \StructType\Policy $policy
     */
    public function __construct(\StructType\Policy $policy = null)
    {
        $this
            ->setPolicy($policy);
    }
    /**
     * Get policy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return isset($this->policy) ? $this->policy : null;
    }
    /**
     * Set policy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Policy $policy
     * @return \StructType\UpdatePolicy
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        if (is_null($policy) || (is_array($policy) && empty($policy))) {
            unset($this->policy);
        } else {
            $this->policy = $policy;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdatePolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
