<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TargetResponse
 * @subpackage Structs
 */
class TargetResponse extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The CampaignTargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignTargetId;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContactId;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The LeadId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LeadId;
    /**
     * The LeadSourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LeadSourceId;
    /**
     * The ModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyDate;
    /**
     * The ResponseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResponseDate;
    /**
     * Constructor method for TargetResponse
     * @uses TargetResponse::setCampaignId()
     * @uses TargetResponse::setCampaignTargetId()
     * @uses TargetResponse::setContactId()
     * @uses TargetResponse::setCreateUserId()
     * @uses TargetResponse::setLeadId()
     * @uses TargetResponse::setLeadSourceId()
     * @uses TargetResponse::setModifyDate()
     * @uses TargetResponse::setResponseDate()
     * @param int $campaignId
     * @param int $campaignTargetId
     * @param int $contactId
     * @param string $createUserId
     * @param int $leadId
     * @param int $leadSourceId
     * @param string $modifyDate
     * @param string $responseDate
     */
    public function __construct($campaignId = null, $campaignTargetId = null, $contactId = null, $createUserId = null, $leadId = null, $leadSourceId = null, $modifyDate = null, $responseDate = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setCampaignTargetId($campaignTargetId)
            ->setContactId($contactId)
            ->setCreateUserId($createUserId)
            ->setLeadId($leadId)
            ->setLeadSourceId($leadSourceId)
            ->setModifyDate($modifyDate)
            ->setResponseDate($responseDate);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\TargetResponse
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get CampaignTargetId value
     * @return int|null
     */
    public function getCampaignTargetId()
    {
        return $this->CampaignTargetId;
    }
    /**
     * Set CampaignTargetId value
     * @param int $campaignTargetId
     * @return \StructType\TargetResponse
     */
    public function setCampaignTargetId($campaignTargetId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignTargetId) && !(is_int($campaignTargetId) || ctype_digit($campaignTargetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignTargetId, true), gettype($campaignTargetId)), __LINE__);
        }
        $this->CampaignTargetId = $campaignTargetId;
        return $this;
    }
    /**
     * Get ContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContactId()
    {
        return isset($this->ContactId) ? $this->ContactId : null;
    }
    /**
     * Set ContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contactId
     * @return \StructType\TargetResponse
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        if (is_null($contactId) || (is_array($contactId) && empty($contactId))) {
            unset($this->ContactId);
        } else {
            $this->ContactId = $contactId;
        }
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\TargetResponse
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get LeadId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeadId()
    {
        return isset($this->LeadId) ? $this->LeadId : null;
    }
    /**
     * Set LeadId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leadId
     * @return \StructType\TargetResponse
     */
    public function setLeadId($leadId = null)
    {
        // validation for constraint: int
        if (!is_null($leadId) && !(is_int($leadId) || ctype_digit($leadId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadId, true), gettype($leadId)), __LINE__);
        }
        if (is_null($leadId) || (is_array($leadId) && empty($leadId))) {
            unset($this->LeadId);
        } else {
            $this->LeadId = $leadId;
        }
        return $this;
    }
    /**
     * Get LeadSourceId value
     * @return int|null
     */
    public function getLeadSourceId()
    {
        return $this->LeadSourceId;
    }
    /**
     * Set LeadSourceId value
     * @param int $leadSourceId
     * @return \StructType\TargetResponse
     */
    public function setLeadSourceId($leadSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceId) && !(is_int($leadSourceId) || ctype_digit($leadSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadSourceId, true), gettype($leadSourceId)), __LINE__);
        }
        $this->LeadSourceId = $leadSourceId;
        return $this;
    }
    /**
     * Get ModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyDate()
    {
        return isset($this->ModifyDate) ? $this->ModifyDate : null;
    }
    /**
     * Set ModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyDate
     * @return \StructType\TargetResponse
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        if (is_null($modifyDate) || (is_array($modifyDate) && empty($modifyDate))) {
            unset($this->ModifyDate);
        } else {
            $this->ModifyDate = $modifyDate;
        }
        return $this;
    }
    /**
     * Get ResponseDate value
     * @return string|null
     */
    public function getResponseDate()
    {
        return $this->ResponseDate;
    }
    /**
     * Set ResponseDate value
     * @param string $responseDate
     * @return \StructType\TargetResponse
     */
    public function setResponseDate($responseDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDate) && !is_string($responseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDate, true), gettype($responseDate)), __LINE__);
        }
        $this->ResponseDate = $responseDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TargetResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
