<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for secureWebService.ImportQuotePaymentSource StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:secureWebService.ImportQuotePaymentSource
 * @subpackage Structs
 */
class SecureWebService_ImportQuotePaymentSource extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The BankTransit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankTransit;
    /**
     * The CreditCardExpDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardExpDate;
    /**
     * The CreditCardExpString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardExpString;
    /**
     * The MethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodType;
    /**
     * Constructor method for secureWebService.ImportQuotePaymentSource
     * @uses SecureWebService_ImportQuotePaymentSource::setAccountNumber()
     * @uses SecureWebService_ImportQuotePaymentSource::setBankTransit()
     * @uses SecureWebService_ImportQuotePaymentSource::setCreditCardExpDate()
     * @uses SecureWebService_ImportQuotePaymentSource::setCreditCardExpString()
     * @uses SecureWebService_ImportQuotePaymentSource::setMethodType()
     * @param string $accountNumber
     * @param string $bankTransit
     * @param string $creditCardExpDate
     * @param string $creditCardExpString
     * @param string $methodType
     */
    public function __construct($accountNumber = null, $bankTransit = null, $creditCardExpDate = null, $creditCardExpString = null, $methodType = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setBankTransit($bankTransit)
            ->setCreditCardExpDate($creditCardExpDate)
            ->setCreditCardExpString($creditCardExpString)
            ->setMethodType($methodType);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get BankTransit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankTransit()
    {
        return isset($this->BankTransit) ? $this->BankTransit : null;
    }
    /**
     * Set BankTransit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankTransit
     * @return \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public function setBankTransit($bankTransit = null)
    {
        // validation for constraint: string
        if (!is_null($bankTransit) && !is_string($bankTransit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankTransit, true), gettype($bankTransit)), __LINE__);
        }
        if (is_null($bankTransit) || (is_array($bankTransit) && empty($bankTransit))) {
            unset($this->BankTransit);
        } else {
            $this->BankTransit = $bankTransit;
        }
        return $this;
    }
    /**
     * Get CreditCardExpDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardExpDate()
    {
        return isset($this->CreditCardExpDate) ? $this->CreditCardExpDate : null;
    }
    /**
     * Set CreditCardExpDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardExpDate
     * @return \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public function setCreditCardExpDate($creditCardExpDate = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardExpDate) && !is_string($creditCardExpDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardExpDate, true), gettype($creditCardExpDate)), __LINE__);
        }
        if (is_null($creditCardExpDate) || (is_array($creditCardExpDate) && empty($creditCardExpDate))) {
            unset($this->CreditCardExpDate);
        } else {
            $this->CreditCardExpDate = $creditCardExpDate;
        }
        return $this;
    }
    /**
     * Get CreditCardExpString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardExpString()
    {
        return isset($this->CreditCardExpString) ? $this->CreditCardExpString : null;
    }
    /**
     * Set CreditCardExpString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardExpString
     * @return \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public function setCreditCardExpString($creditCardExpString = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardExpString) && !is_string($creditCardExpString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardExpString, true), gettype($creditCardExpString)), __LINE__);
        }
        if (is_null($creditCardExpString) || (is_array($creditCardExpString) && empty($creditCardExpString))) {
            unset($this->CreditCardExpString);
        } else {
            $this->CreditCardExpString = $creditCardExpString;
        }
        return $this;
    }
    /**
     * Get MethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodType()
    {
        return isset($this->MethodType) ? $this->MethodType : null;
    }
    /**
     * Set MethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodType
     * @return \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public function setMethodType($methodType = null)
    {
        // validation for constraint: string
        if (!is_null($methodType) && !is_string($methodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodType, true), gettype($methodType)), __LINE__);
        }
        if (is_null($methodType) || (is_array($methodType) && empty($methodType))) {
            unset($this->MethodType);
        } else {
            $this->MethodType = $methodType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
