<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for secureWebService.ImportQuoteData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:secureWebService.ImportQuoteData
 * @subpackage Structs
 */
class SecureWebService_ImportQuoteData extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The CampaignTargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignTargetId;
    /**
     * The CoverageOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfsecureWebService_ImportQuoteOption
     */
    public $CoverageOptions;
    /**
     * The DownPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfsecureWebService_ImportQuotePayment
     */
    public $DownPayments;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityId;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The FinancePaymentSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_ImportQuotePaymentSource
     */
    public $FinancePaymentSource;
    /**
     * The FinanceTerm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FinanceTerm;
    /**
     * The Premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Premium;
    /**
     * The PremiumPlusTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PremiumPlusTax;
    /**
     * The VehicleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VehicleId;
    /**
     * The VehicleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VehicleType;
    /**
     * The WarrantyRateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WarrantyRateId;
    /**
     * Constructor method for secureWebService.ImportQuoteData
     * @uses SecureWebService_ImportQuoteData::setCampaignId()
     * @uses SecureWebService_ImportQuoteData::setCampaignTargetId()
     * @uses SecureWebService_ImportQuoteData::setCoverageOptions()
     * @uses SecureWebService_ImportQuoteData::setDownPayments()
     * @uses SecureWebService_ImportQuoteData::setEntityId()
     * @uses SecureWebService_ImportQuoteData::setEntityType()
     * @uses SecureWebService_ImportQuoteData::setFinancePaymentSource()
     * @uses SecureWebService_ImportQuoteData::setFinanceTerm()
     * @uses SecureWebService_ImportQuoteData::setPremium()
     * @uses SecureWebService_ImportQuoteData::setPremiumPlusTax()
     * @uses SecureWebService_ImportQuoteData::setVehicleId()
     * @uses SecureWebService_ImportQuoteData::setVehicleType()
     * @uses SecureWebService_ImportQuoteData::setWarrantyRateId()
     * @param int $campaignId
     * @param int $campaignTargetId
     * @param \ArrayType\ArrayOfsecureWebService_ImportQuoteOption $coverageOptions
     * @param \ArrayType\ArrayOfsecureWebService_ImportQuotePayment $downPayments
     * @param int $entityId
     * @param string $entityType
     * @param \StructType\SecureWebService_ImportQuotePaymentSource $financePaymentSource
     * @param int $financeTerm
     * @param float $premium
     * @param float $premiumPlusTax
     * @param int $vehicleId
     * @param string $vehicleType
     * @param int $warrantyRateId
     */
    public function __construct($campaignId = null, $campaignTargetId = null, \ArrayType\ArrayOfsecureWebService_ImportQuoteOption $coverageOptions = null, \ArrayType\ArrayOfsecureWebService_ImportQuotePayment $downPayments = null, $entityId = null, $entityType = null, \StructType\SecureWebService_ImportQuotePaymentSource $financePaymentSource = null, $financeTerm = null, $premium = null, $premiumPlusTax = null, $vehicleId = null, $vehicleType = null, $warrantyRateId = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setCampaignTargetId($campaignTargetId)
            ->setCoverageOptions($coverageOptions)
            ->setDownPayments($downPayments)
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setFinancePaymentSource($financePaymentSource)
            ->setFinanceTerm($financeTerm)
            ->setPremium($premium)
            ->setPremiumPlusTax($premiumPlusTax)
            ->setVehicleId($vehicleId)
            ->setVehicleType($vehicleType)
            ->setWarrantyRateId($warrantyRateId);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get CampaignTargetId value
     * @return int|null
     */
    public function getCampaignTargetId()
    {
        return $this->CampaignTargetId;
    }
    /**
     * Set CampaignTargetId value
     * @param int $campaignTargetId
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setCampaignTargetId($campaignTargetId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignTargetId) && !(is_int($campaignTargetId) || ctype_digit($campaignTargetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignTargetId, true), gettype($campaignTargetId)), __LINE__);
        }
        $this->CampaignTargetId = $campaignTargetId;
        return $this;
    }
    /**
     * Get CoverageOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfsecureWebService_ImportQuoteOption|null
     */
    public function getCoverageOptions()
    {
        return isset($this->CoverageOptions) ? $this->CoverageOptions : null;
    }
    /**
     * Set CoverageOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfsecureWebService_ImportQuoteOption $coverageOptions
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setCoverageOptions(\ArrayType\ArrayOfsecureWebService_ImportQuoteOption $coverageOptions = null)
    {
        if (is_null($coverageOptions) || (is_array($coverageOptions) && empty($coverageOptions))) {
            unset($this->CoverageOptions);
        } else {
            $this->CoverageOptions = $coverageOptions;
        }
        return $this;
    }
    /**
     * Get DownPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfsecureWebService_ImportQuotePayment|null
     */
    public function getDownPayments()
    {
        return isset($this->DownPayments) ? $this->DownPayments : null;
    }
    /**
     * Set DownPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfsecureWebService_ImportQuotePayment $downPayments
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setDownPayments(\ArrayType\ArrayOfsecureWebService_ImportQuotePayment $downPayments = null)
    {
        if (is_null($downPayments) || (is_array($downPayments) && empty($downPayments))) {
            unset($this->DownPayments);
        } else {
            $this->DownPayments = $downPayments;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get FinancePaymentSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_ImportQuotePaymentSource|null
     */
    public function getFinancePaymentSource()
    {
        return isset($this->FinancePaymentSource) ? $this->FinancePaymentSource : null;
    }
    /**
     * Set FinancePaymentSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_ImportQuotePaymentSource $financePaymentSource
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setFinancePaymentSource(\StructType\SecureWebService_ImportQuotePaymentSource $financePaymentSource = null)
    {
        if (is_null($financePaymentSource) || (is_array($financePaymentSource) && empty($financePaymentSource))) {
            unset($this->FinancePaymentSource);
        } else {
            $this->FinancePaymentSource = $financePaymentSource;
        }
        return $this;
    }
    /**
     * Get FinanceTerm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFinanceTerm()
    {
        return isset($this->FinanceTerm) ? $this->FinanceTerm : null;
    }
    /**
     * Set FinanceTerm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $financeTerm
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setFinanceTerm($financeTerm = null)
    {
        // validation for constraint: int
        if (!is_null($financeTerm) && !(is_int($financeTerm) || ctype_digit($financeTerm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($financeTerm, true), gettype($financeTerm)), __LINE__);
        }
        if (is_null($financeTerm) || (is_array($financeTerm) && empty($financeTerm))) {
            unset($this->FinanceTerm);
        } else {
            $this->FinanceTerm = $financeTerm;
        }
        return $this;
    }
    /**
     * Get Premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param float $premium
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get PremiumPlusTax value
     * @return float|null
     */
    public function getPremiumPlusTax()
    {
        return $this->PremiumPlusTax;
    }
    /**
     * Set PremiumPlusTax value
     * @param float $premiumPlusTax
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setPremiumPlusTax($premiumPlusTax = null)
    {
        // validation for constraint: float
        if (!is_null($premiumPlusTax) && !(is_float($premiumPlusTax) || is_numeric($premiumPlusTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premiumPlusTax, true), gettype($premiumPlusTax)), __LINE__);
        }
        $this->PremiumPlusTax = $premiumPlusTax;
        return $this;
    }
    /**
     * Get VehicleId value
     * @return int|null
     */
    public function getVehicleId()
    {
        return $this->VehicleId;
    }
    /**
     * Set VehicleId value
     * @param int $vehicleId
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        $this->VehicleId = $vehicleId;
        return $this;
    }
    /**
     * Get VehicleType value
     * @return string|null
     */
    public function getVehicleType()
    {
        return $this->VehicleType;
    }
    /**
     * Set VehicleType value
     * @uses \EnumType\VehicleType::valueIsValid()
     * @uses \EnumType\VehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleType
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleType::valueIsValid($vehicleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehicleType', is_array($vehicleType) ? implode(', ', $vehicleType) : var_export($vehicleType, true), implode(', ', \EnumType\VehicleType::getValidValues())), __LINE__);
        }
        $this->VehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get WarrantyRateId value
     * @return int|null
     */
    public function getWarrantyRateId()
    {
        return $this->WarrantyRateId;
    }
    /**
     * Set WarrantyRateId value
     * @param int $warrantyRateId
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public function setWarrantyRateId($warrantyRateId = null)
    {
        // validation for constraint: int
        if (!is_null($warrantyRateId) && !(is_int($warrantyRateId) || ctype_digit($warrantyRateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warrantyRateId, true), gettype($warrantyRateId)), __LINE__);
        }
        $this->WarrantyRateId = $warrantyRateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecureWebService_ImportQuoteData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
