<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for secureWebService.ImportLeadReturn StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:secureWebService.ImportLeadReturn
 * @subpackage Structs
 */
class SecureWebService_ImportLeadReturn extends AbstractStructBase
{
    /**
     * The campaignTargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $campaignTargetId;
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $entityId;
    /**
     * The entityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $entityType;
    /**
     * The quoteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $quoteId;
    /**
     * The responseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $responseCode;
    /**
     * The responseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $responseMessage;
    /**
     * The vehicleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $vehicleId;
    /**
     * Constructor method for secureWebService.ImportLeadReturn
     * @uses SecureWebService_ImportLeadReturn::setCampaignTargetId()
     * @uses SecureWebService_ImportLeadReturn::setEntityId()
     * @uses SecureWebService_ImportLeadReturn::setEntityType()
     * @uses SecureWebService_ImportLeadReturn::setQuoteId()
     * @uses SecureWebService_ImportLeadReturn::setResponseCode()
     * @uses SecureWebService_ImportLeadReturn::setResponseMessage()
     * @uses SecureWebService_ImportLeadReturn::setVehicleId()
     * @param int $campaignTargetId
     * @param int $entityId
     * @param string $entityType
     * @param int $quoteId
     * @param string $responseCode
     * @param string $responseMessage
     * @param int $vehicleId
     */
    public function __construct($campaignTargetId = null, $entityId = null, $entityType = null, $quoteId = null, $responseCode = null, $responseMessage = null, $vehicleId = null)
    {
        $this
            ->setCampaignTargetId($campaignTargetId)
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setQuoteId($quoteId)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage)
            ->setVehicleId($vehicleId);
    }
    /**
     * Get campaignTargetId value
     * @return int|null
     */
    public function getCampaignTargetId()
    {
        return $this->campaignTargetId;
    }
    /**
     * Set campaignTargetId value
     * @param int $campaignTargetId
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setCampaignTargetId($campaignTargetId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignTargetId) && !(is_int($campaignTargetId) || ctype_digit($campaignTargetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignTargetId, true), gettype($campaignTargetId)), __LINE__);
        }
        $this->campaignTargetId = $campaignTargetId;
        return $this;
    }
    /**
     * Get entityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEntityId()
    {
        return isset($this->entityId) ? $this->entityId : null;
    }
    /**
     * Set entityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $entityId
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->entityId);
        } else {
            $this->entityId = $entityId;
        }
        return $this;
    }
    /**
     * Get entityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->entityType) ? $this->entityType : null;
    }
    /**
     * Set entityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->entityType);
        } else {
            $this->entityType = $entityType;
        }
        return $this;
    }
    /**
     * Get quoteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuoteId()
    {
        return isset($this->quoteId) ? $this->quoteId : null;
    }
    /**
     * Set quoteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quoteId
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !(is_int($quoteId) || ctype_digit($quoteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        if (is_null($quoteId) || (is_array($quoteId) && empty($quoteId))) {
            unset($this->quoteId);
        } else {
            $this->quoteId = $quoteId;
        }
        return $this;
    }
    /**
     * Get responseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->responseCode) ? $this->responseCode : null;
    }
    /**
     * Set responseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->responseCode);
        } else {
            $this->responseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get responseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->responseMessage) ? $this->responseMessage : null;
    }
    /**
     * Set responseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->responseMessage);
        } else {
            $this->responseMessage = $responseMessage;
        }
        return $this;
    }
    /**
     * Get vehicleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVehicleId()
    {
        return isset($this->vehicleId) ? $this->vehicleId : null;
    }
    /**
     * Set vehicleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vehicleId
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        if (is_null($vehicleId) || (is_array($vehicleId) && empty($vehicleId))) {
            unset($this->vehicleId);
        } else {
            $this->vehicleId = $vehicleId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecureWebService_ImportLeadReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
