<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeadSource StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LeadSource
 * @subpackage Structs
 */
class LeadSource extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The CodePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePattern;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The LeadSourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LeadSourceId;
    /**
     * The LeadSourceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadSourceName;
    /**
     * The ListProviderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ListProviderId;
    /**
     * The ModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifyDate;
    /**
     * The ModifyUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyUserId;
    /**
     * Constructor method for LeadSource
     * @uses LeadSource::setActive()
     * @uses LeadSource::setCodePattern()
     * @uses LeadSource::setCreateDate()
     * @uses LeadSource::setCreateUserId()
     * @uses LeadSource::setExternalId()
     * @uses LeadSource::setLeadSourceId()
     * @uses LeadSource::setLeadSourceName()
     * @uses LeadSource::setListProviderId()
     * @uses LeadSource::setModifyDate()
     * @uses LeadSource::setModifyUserId()
     * @param bool $active
     * @param string $codePattern
     * @param string $createDate
     * @param string $createUserId
     * @param string $externalId
     * @param int $leadSourceId
     * @param string $leadSourceName
     * @param int $listProviderId
     * @param string $modifyDate
     * @param string $modifyUserId
     */
    public function __construct($active = null, $codePattern = null, $createDate = null, $createUserId = null, $externalId = null, $leadSourceId = null, $leadSourceName = null, $listProviderId = null, $modifyDate = null, $modifyUserId = null)
    {
        $this
            ->setActive($active)
            ->setCodePattern($codePattern)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setExternalId($externalId)
            ->setLeadSourceId($leadSourceId)
            ->setLeadSourceName($leadSourceName)
            ->setListProviderId($listProviderId)
            ->setModifyDate($modifyDate)
            ->setModifyUserId($modifyUserId);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\LeadSource
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get CodePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePattern()
    {
        return isset($this->CodePattern) ? $this->CodePattern : null;
    }
    /**
     * Set CodePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePattern
     * @return \StructType\LeadSource
     */
    public function setCodePattern($codePattern = null)
    {
        // validation for constraint: string
        if (!is_null($codePattern) && !is_string($codePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePattern, true), gettype($codePattern)), __LINE__);
        }
        if (is_null($codePattern) || (is_array($codePattern) && empty($codePattern))) {
            unset($this->CodePattern);
        } else {
            $this->CodePattern = $codePattern;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\LeadSource
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\LeadSource
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \StructType\LeadSource
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get LeadSourceId value
     * @return int|null
     */
    public function getLeadSourceId()
    {
        return $this->LeadSourceId;
    }
    /**
     * Set LeadSourceId value
     * @param int $leadSourceId
     * @return \StructType\LeadSource
     */
    public function setLeadSourceId($leadSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceId) && !(is_int($leadSourceId) || ctype_digit($leadSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadSourceId, true), gettype($leadSourceId)), __LINE__);
        }
        $this->LeadSourceId = $leadSourceId;
        return $this;
    }
    /**
     * Get LeadSourceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadSourceName()
    {
        return isset($this->LeadSourceName) ? $this->LeadSourceName : null;
    }
    /**
     * Set LeadSourceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadSourceName
     * @return \StructType\LeadSource
     */
    public function setLeadSourceName($leadSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($leadSourceName) && !is_string($leadSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadSourceName, true), gettype($leadSourceName)), __LINE__);
        }
        if (is_null($leadSourceName) || (is_array($leadSourceName) && empty($leadSourceName))) {
            unset($this->LeadSourceName);
        } else {
            $this->LeadSourceName = $leadSourceName;
        }
        return $this;
    }
    /**
     * Get ListProviderId value
     * @return int|null
     */
    public function getListProviderId()
    {
        return $this->ListProviderId;
    }
    /**
     * Set ListProviderId value
     * @param int $listProviderId
     * @return \StructType\LeadSource
     */
    public function setListProviderId($listProviderId = null)
    {
        // validation for constraint: int
        if (!is_null($listProviderId) && !(is_int($listProviderId) || ctype_digit($listProviderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listProviderId, true), gettype($listProviderId)), __LINE__);
        }
        $this->ListProviderId = $listProviderId;
        return $this;
    }
    /**
     * Get ModifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->ModifyDate;
    }
    /**
     * Set ModifyDate value
     * @param string $modifyDate
     * @return \StructType\LeadSource
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        $this->ModifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get ModifyUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyUserId()
    {
        return isset($this->ModifyUserId) ? $this->ModifyUserId : null;
    }
    /**
     * Set ModifyUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyUserId
     * @return \StructType\LeadSource
     */
    public function setModifyUserId($modifyUserId = null)
    {
        // validation for constraint: string
        if (!is_null($modifyUserId) && !is_string($modifyUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyUserId, true), gettype($modifyUserId)), __LINE__);
        }
        if (is_null($modifyUserId) || (is_array($modifyUserId) && empty($modifyUserId))) {
            unset($this->ModifyUserId);
        } else {
            $this->ModifyUserId = $modifyUserId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LeadSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
