<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertQuoteAndEntity StructType
 * @subpackage Structs
 */
class InsertQuoteAndEntity extends AbstractStructBase
{
    /**
     * The quoteData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_ImportQuoteData
     */
    public $quoteData;
    /**
     * The entityData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_ImportLeadData
     */
    public $entityData;
    /**
     * Constructor method for InsertQuoteAndEntity
     * @uses InsertQuoteAndEntity::setQuoteData()
     * @uses InsertQuoteAndEntity::setEntityData()
     * @param \StructType\SecureWebService_ImportQuoteData $quoteData
     * @param \StructType\SecureWebService_ImportLeadData $entityData
     */
    public function __construct(\StructType\SecureWebService_ImportQuoteData $quoteData = null, \StructType\SecureWebService_ImportLeadData $entityData = null)
    {
        $this
            ->setQuoteData($quoteData)
            ->setEntityData($entityData);
    }
    /**
     * Get quoteData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_ImportQuoteData|null
     */
    public function getQuoteData()
    {
        return isset($this->quoteData) ? $this->quoteData : null;
    }
    /**
     * Set quoteData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_ImportQuoteData $quoteData
     * @return \StructType\InsertQuoteAndEntity
     */
    public function setQuoteData(\StructType\SecureWebService_ImportQuoteData $quoteData = null)
    {
        if (is_null($quoteData) || (is_array($quoteData) && empty($quoteData))) {
            unset($this->quoteData);
        } else {
            $this->quoteData = $quoteData;
        }
        return $this;
    }
    /**
     * Get entityData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_ImportLeadData|null
     */
    public function getEntityData()
    {
        return isset($this->entityData) ? $this->entityData : null;
    }
    /**
     * Set entityData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_ImportLeadData $entityData
     * @return \StructType\InsertQuoteAndEntity
     */
    public function setEntityData(\StructType\SecureWebService_ImportLeadData $entityData = null)
    {
        if (is_null($entityData) || (is_array($entityData) && empty($entityData))) {
            unset($this->entityData);
        } else {
            $this->entityData = $entityData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertQuoteAndEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
