<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertNote StructType
 * @subpackage Structs
 */
class InsertNote extends AbstractStructBase
{
    /**
     * The note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\History
     */
    public $note;
    /**
     * Constructor method for InsertNote
     * @uses InsertNote::setNote()
     * @param \StructType\History $note
     */
    public function __construct(\StructType\History $note = null)
    {
        $this
            ->setNote($note);
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\History|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\History $note
     * @return \StructType\InsertNote
     */
    public function setNote(\StructType\History $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
