<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWebTabResults StructType
 * @subpackage Structs
 */
class GetWebTabResults extends AbstractStructBase
{
    /**
     * The webTabId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $webTabId;
    /**
     * The queryReportParams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfsecureWebService_QueryReportParameter
     */
    public $queryReportParams;
    /**
     * The returnType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $returnType;
    /**
     * Constructor method for GetWebTabResults
     * @uses GetWebTabResults::setWebTabId()
     * @uses GetWebTabResults::setQueryReportParams()
     * @uses GetWebTabResults::setReturnType()
     * @param int $webTabId
     * @param \ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams
     * @param string $returnType
     */
    public function __construct($webTabId = null, \ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams = null, $returnType = null)
    {
        $this
            ->setWebTabId($webTabId)
            ->setQueryReportParams($queryReportParams)
            ->setReturnType($returnType);
    }
    /**
     * Get webTabId value
     * @return int|null
     */
    public function getWebTabId()
    {
        return $this->webTabId;
    }
    /**
     * Set webTabId value
     * @param int $webTabId
     * @return \StructType\GetWebTabResults
     */
    public function setWebTabId($webTabId = null)
    {
        // validation for constraint: int
        if (!is_null($webTabId) && !(is_int($webTabId) || ctype_digit($webTabId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($webTabId, true), gettype($webTabId)), __LINE__);
        }
        $this->webTabId = $webTabId;
        return $this;
    }
    /**
     * Get queryReportParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfsecureWebService_QueryReportParameter|null
     */
    public function getQueryReportParams()
    {
        return isset($this->queryReportParams) ? $this->queryReportParams : null;
    }
    /**
     * Set queryReportParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams
     * @return \StructType\GetWebTabResults
     */
    public function setQueryReportParams(\ArrayType\ArrayOfsecureWebService_QueryReportParameter $queryReportParams = null)
    {
        if (is_null($queryReportParams) || (is_array($queryReportParams) && empty($queryReportParams))) {
            unset($this->queryReportParams);
        } else {
            $this->queryReportParams = $queryReportParams;
        }
        return $this;
    }
    /**
     * Get returnType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnType()
    {
        return isset($this->returnType) ? $this->returnType : null;
    }
    /**
     * Set returnType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnType
     * @return \StructType\GetWebTabResults
     */
    public function setReturnType($returnType = null)
    {
        // validation for constraint: string
        if (!is_null($returnType) && !is_string($returnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnType, true), gettype($returnType)), __LINE__);
        }
        if (is_null($returnType) || (is_array($returnType) && empty($returnType))) {
            unset($this->returnType);
        } else {
            $this->returnType = $returnType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWebTabResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
