<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVehicles StructType
 * @subpackage Structs
 */
class GetVehicles extends AbstractStructBase
{
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $entityId;
    /**
     * The entityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $entityType;
    /**
     * The vehicleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $vehicleId;
    /**
     * Constructor method for GetVehicles
     * @uses GetVehicles::setEntityId()
     * @uses GetVehicles::setEntityType()
     * @uses GetVehicles::setVehicleId()
     * @param int $entityId
     * @param string $entityType
     * @param int $vehicleId
     */
    public function __construct($entityId = null, $entityType = null, $vehicleId = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setVehicleId($vehicleId);
    }
    /**
     * Get entityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEntityId()
    {
        return isset($this->entityId) ? $this->entityId : null;
    }
    /**
     * Set entityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $entityId
     * @return \StructType\GetVehicles
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->entityId);
        } else {
            $this->entityId = $entityId;
        }
        return $this;
    }
    /**
     * Get entityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->entityType) ? $this->entityType : null;
    }
    /**
     * Set entityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\GetVehicles
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->entityType);
        } else {
            $this->entityType = $entityType;
        }
        return $this;
    }
    /**
     * Get vehicleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVehicleId()
    {
        return isset($this->vehicleId) ? $this->vehicleId : null;
    }
    /**
     * Set vehicleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vehicleId
     * @return \StructType\GetVehicles
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        if (is_null($vehicleId) || (is_array($vehicleId) && empty($vehicleId))) {
            unset($this->vehicleId);
        } else {
            $this->vehicleId = $vehicleId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVehicles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
