<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRates2 StructType
 * @subpackage Structs
 */
class GetRates2 extends AbstractStructBase
{
    /**
     * The campaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $campaignId;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $zip;
    /**
     * The stateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $stateProvince;
    /**
     * The vehicleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $vehicleType;
    /**
     * The odometer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $odometer;
    /**
     * The modelYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $modelYear;
    /**
     * The trimOrClassId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $trimOrClassId;
    /**
     * The purchasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $purchasePrice;
    /**
     * The purchaseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $purchaseDate;
    /**
     * The vin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $vin;
    /**
     * The altVehicleOptionIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $altVehicleOptionIdList;
    /**
     * The termMilesFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $termMilesFilter;
    /**
     * The termMonthsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $termMonthsFilter;
    /**
     * The milesPerYearFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $milesPerYearFilter;
    /**
     * The coverageLevelFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $coverageLevelFilter;
    /**
     * The endOdometerFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $endOdometerFilter;
    /**
     * The productIdFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $productIdFilter;
    /**
     * Constructor method for GetRates2
     * @uses GetRates2::setCampaignId()
     * @uses GetRates2::setZip()
     * @uses GetRates2::setStateProvince()
     * @uses GetRates2::setVehicleType()
     * @uses GetRates2::setOdometer()
     * @uses GetRates2::setModelYear()
     * @uses GetRates2::setTrimOrClassId()
     * @uses GetRates2::setPurchasePrice()
     * @uses GetRates2::setPurchaseDate()
     * @uses GetRates2::setVin()
     * @uses GetRates2::setAltVehicleOptionIdList()
     * @uses GetRates2::setTermMilesFilter()
     * @uses GetRates2::setTermMonthsFilter()
     * @uses GetRates2::setMilesPerYearFilter()
     * @uses GetRates2::setCoverageLevelFilter()
     * @uses GetRates2::setEndOdometerFilter()
     * @uses GetRates2::setProductIdFilter()
     * @param int $campaignId
     * @param string $zip
     * @param string $stateProvince
     * @param string $vehicleType
     * @param int $odometer
     * @param int $modelYear
     * @param int $trimOrClassId
     * @param float $purchasePrice
     * @param string $purchaseDate
     * @param string $vin
     * @param string $altVehicleOptionIdList
     * @param \StructType\SecureWebService_RangeFilter $termMilesFilter
     * @param \StructType\SecureWebService_RangeFilter $termMonthsFilter
     * @param \StructType\SecureWebService_RangeFilter $milesPerYearFilter
     * @param \StructType\SecureWebService_RangeFilter $coverageLevelFilter
     * @param \StructType\SecureWebService_RangeFilter $endOdometerFilter
     * @param \ArrayType\ArrayOfint $productIdFilter
     */
    public function __construct($campaignId = null, $zip = null, $stateProvince = null, $vehicleType = null, $odometer = null, $modelYear = null, $trimOrClassId = null, $purchasePrice = null, $purchaseDate = null, $vin = null, $altVehicleOptionIdList = null, \StructType\SecureWebService_RangeFilter $termMilesFilter = null, \StructType\SecureWebService_RangeFilter $termMonthsFilter = null, \StructType\SecureWebService_RangeFilter $milesPerYearFilter = null, \StructType\SecureWebService_RangeFilter $coverageLevelFilter = null, \StructType\SecureWebService_RangeFilter $endOdometerFilter = null, \ArrayType\ArrayOfint $productIdFilter = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setZip($zip)
            ->setStateProvince($stateProvince)
            ->setVehicleType($vehicleType)
            ->setOdometer($odometer)
            ->setModelYear($modelYear)
            ->setTrimOrClassId($trimOrClassId)
            ->setPurchasePrice($purchasePrice)
            ->setPurchaseDate($purchaseDate)
            ->setVin($vin)
            ->setAltVehicleOptionIdList($altVehicleOptionIdList)
            ->setTermMilesFilter($termMilesFilter)
            ->setTermMonthsFilter($termMonthsFilter)
            ->setMilesPerYearFilter($milesPerYearFilter)
            ->setCoverageLevelFilter($coverageLevelFilter)
            ->setEndOdometerFilter($endOdometerFilter)
            ->setProductIdFilter($productIdFilter);
    }
    /**
     * Get campaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->campaignId;
    }
    /**
     * Set campaignId value
     * @param int $campaignId
     * @return \StructType\GetRates2
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->campaignId = $campaignId;
        return $this;
    }
    /**
     * Get zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->zip) ? $this->zip : null;
    }
    /**
     * Set zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \StructType\GetRates2
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->zip);
        } else {
            $this->zip = $zip;
        }
        return $this;
    }
    /**
     * Get stateProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateProvince()
    {
        return isset($this->stateProvince) ? $this->stateProvince : null;
    }
    /**
     * Set stateProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateProvince
     * @return \StructType\GetRates2
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        if (is_null($stateProvince) || (is_array($stateProvince) && empty($stateProvince))) {
            unset($this->stateProvince);
        } else {
            $this->stateProvince = $stateProvince;
        }
        return $this;
    }
    /**
     * Get vehicleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVehicleType()
    {
        return isset($this->vehicleType) ? $this->vehicleType : null;
    }
    /**
     * Set vehicleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vehicleType
     * @return \StructType\GetRates2
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleType) && !is_string($vehicleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleType, true), gettype($vehicleType)), __LINE__);
        }
        if (is_null($vehicleType) || (is_array($vehicleType) && empty($vehicleType))) {
            unset($this->vehicleType);
        } else {
            $this->vehicleType = $vehicleType;
        }
        return $this;
    }
    /**
     * Get odometer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOdometer()
    {
        return isset($this->odometer) ? $this->odometer : null;
    }
    /**
     * Set odometer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $odometer
     * @return \StructType\GetRates2
     */
    public function setOdometer($odometer = null)
    {
        // validation for constraint: int
        if (!is_null($odometer) && !(is_int($odometer) || ctype_digit($odometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odometer, true), gettype($odometer)), __LINE__);
        }
        if (is_null($odometer) || (is_array($odometer) && empty($odometer))) {
            unset($this->odometer);
        } else {
            $this->odometer = $odometer;
        }
        return $this;
    }
    /**
     * Get modelYear value
     * @return int|null
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * Set modelYear value
     * @param int $modelYear
     * @return \StructType\GetRates2
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
    /**
     * Get trimOrClassId value
     * @return int|null
     */
    public function getTrimOrClassId()
    {
        return $this->trimOrClassId;
    }
    /**
     * Set trimOrClassId value
     * @param int $trimOrClassId
     * @return \StructType\GetRates2
     */
    public function setTrimOrClassId($trimOrClassId = null)
    {
        // validation for constraint: int
        if (!is_null($trimOrClassId) && !(is_int($trimOrClassId) || ctype_digit($trimOrClassId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trimOrClassId, true), gettype($trimOrClassId)), __LINE__);
        }
        $this->trimOrClassId = $trimOrClassId;
        return $this;
    }
    /**
     * Get purchasePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return isset($this->purchasePrice) ? $this->purchasePrice : null;
    }
    /**
     * Set purchasePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $purchasePrice
     * @return \StructType\GetRates2
     */
    public function setPurchasePrice($purchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($purchasePrice) && !(is_float($purchasePrice) || is_numeric($purchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchasePrice, true), gettype($purchasePrice)), __LINE__);
        }
        if (is_null($purchasePrice) || (is_array($purchasePrice) && empty($purchasePrice))) {
            unset($this->purchasePrice);
        } else {
            $this->purchasePrice = $purchasePrice;
        }
        return $this;
    }
    /**
     * Get purchaseDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return isset($this->purchaseDate) ? $this->purchaseDate : null;
    }
    /**
     * Set purchaseDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaseDate
     * @return \StructType\GetRates2
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDate) && !is_string($purchaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDate, true), gettype($purchaseDate)), __LINE__);
        }
        if (is_null($purchaseDate) || (is_array($purchaseDate) && empty($purchaseDate))) {
            unset($this->purchaseDate);
        } else {
            $this->purchaseDate = $purchaseDate;
        }
        return $this;
    }
    /**
     * Get vin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVin()
    {
        return isset($this->vin) ? $this->vin : null;
    }
    /**
     * Set vin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vin
     * @return \StructType\GetRates2
     */
    public function setVin($vin = null)
    {
        // validation for constraint: string
        if (!is_null($vin) && !is_string($vin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vin, true), gettype($vin)), __LINE__);
        }
        if (is_null($vin) || (is_array($vin) && empty($vin))) {
            unset($this->vin);
        } else {
            $this->vin = $vin;
        }
        return $this;
    }
    /**
     * Get altVehicleOptionIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAltVehicleOptionIdList()
    {
        return isset($this->altVehicleOptionIdList) ? $this->altVehicleOptionIdList : null;
    }
    /**
     * Set altVehicleOptionIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $altVehicleOptionIdList
     * @return \StructType\GetRates2
     */
    public function setAltVehicleOptionIdList($altVehicleOptionIdList = null)
    {
        // validation for constraint: string
        if (!is_null($altVehicleOptionIdList) && !is_string($altVehicleOptionIdList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altVehicleOptionIdList, true), gettype($altVehicleOptionIdList)), __LINE__);
        }
        if (is_null($altVehicleOptionIdList) || (is_array($altVehicleOptionIdList) && empty($altVehicleOptionIdList))) {
            unset($this->altVehicleOptionIdList);
        } else {
            $this->altVehicleOptionIdList = $altVehicleOptionIdList;
        }
        return $this;
    }
    /**
     * Get termMilesFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getTermMilesFilter()
    {
        return isset($this->termMilesFilter) ? $this->termMilesFilter : null;
    }
    /**
     * Set termMilesFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $termMilesFilter
     * @return \StructType\GetRates2
     */
    public function setTermMilesFilter(\StructType\SecureWebService_RangeFilter $termMilesFilter = null)
    {
        if (is_null($termMilesFilter) || (is_array($termMilesFilter) && empty($termMilesFilter))) {
            unset($this->termMilesFilter);
        } else {
            $this->termMilesFilter = $termMilesFilter;
        }
        return $this;
    }
    /**
     * Get termMonthsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getTermMonthsFilter()
    {
        return isset($this->termMonthsFilter) ? $this->termMonthsFilter : null;
    }
    /**
     * Set termMonthsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $termMonthsFilter
     * @return \StructType\GetRates2
     */
    public function setTermMonthsFilter(\StructType\SecureWebService_RangeFilter $termMonthsFilter = null)
    {
        if (is_null($termMonthsFilter) || (is_array($termMonthsFilter) && empty($termMonthsFilter))) {
            unset($this->termMonthsFilter);
        } else {
            $this->termMonthsFilter = $termMonthsFilter;
        }
        return $this;
    }
    /**
     * Get milesPerYearFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getMilesPerYearFilter()
    {
        return isset($this->milesPerYearFilter) ? $this->milesPerYearFilter : null;
    }
    /**
     * Set milesPerYearFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $milesPerYearFilter
     * @return \StructType\GetRates2
     */
    public function setMilesPerYearFilter(\StructType\SecureWebService_RangeFilter $milesPerYearFilter = null)
    {
        if (is_null($milesPerYearFilter) || (is_array($milesPerYearFilter) && empty($milesPerYearFilter))) {
            unset($this->milesPerYearFilter);
        } else {
            $this->milesPerYearFilter = $milesPerYearFilter;
        }
        return $this;
    }
    /**
     * Get coverageLevelFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getCoverageLevelFilter()
    {
        return isset($this->coverageLevelFilter) ? $this->coverageLevelFilter : null;
    }
    /**
     * Set coverageLevelFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $coverageLevelFilter
     * @return \StructType\GetRates2
     */
    public function setCoverageLevelFilter(\StructType\SecureWebService_RangeFilter $coverageLevelFilter = null)
    {
        if (is_null($coverageLevelFilter) || (is_array($coverageLevelFilter) && empty($coverageLevelFilter))) {
            unset($this->coverageLevelFilter);
        } else {
            $this->coverageLevelFilter = $coverageLevelFilter;
        }
        return $this;
    }
    /**
     * Get endOdometerFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getEndOdometerFilter()
    {
        return isset($this->endOdometerFilter) ? $this->endOdometerFilter : null;
    }
    /**
     * Set endOdometerFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $endOdometerFilter
     * @return \StructType\GetRates2
     */
    public function setEndOdometerFilter(\StructType\SecureWebService_RangeFilter $endOdometerFilter = null)
    {
        if (is_null($endOdometerFilter) || (is_array($endOdometerFilter) && empty($endOdometerFilter))) {
            unset($this->endOdometerFilter);
        } else {
            $this->endOdometerFilter = $endOdometerFilter;
        }
        return $this;
    }
    /**
     * Get productIdFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getProductIdFilter()
    {
        return isset($this->productIdFilter) ? $this->productIdFilter : null;
    }
    /**
     * Set productIdFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $productIdFilter
     * @return \StructType\GetRates2
     */
    public function setProductIdFilter(\ArrayType\ArrayOfint $productIdFilter = null)
    {
        if (is_null($productIdFilter) || (is_array($productIdFilter) && empty($productIdFilter))) {
            unset($this->productIdFilter);
        } else {
            $this->productIdFilter = $productIdFilter;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRates2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
