<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRates1 StructType
 * @subpackage Structs
 */
class GetRates1 extends AbstractStructBase
{
    /**
     * The entityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $entityType;
    /**
     * The vehicleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vehicleId;
    /**
     * The targetResponseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $targetResponseId;
    /**
     * The termMilesFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $termMilesFilter;
    /**
     * The termMonthsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $termMonthsFilter;
    /**
     * The milesPerYearFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $milesPerYearFilter;
    /**
     * The coverageLevelFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $coverageLevelFilter;
    /**
     * The endOdometerFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SecureWebService_RangeFilter
     */
    public $endOdometerFilter;
    /**
     * The productIdFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $productIdFilter;
    /**
     * Constructor method for GetRates1
     * @uses GetRates1::setEntityType()
     * @uses GetRates1::setVehicleId()
     * @uses GetRates1::setTargetResponseId()
     * @uses GetRates1::setTermMilesFilter()
     * @uses GetRates1::setTermMonthsFilter()
     * @uses GetRates1::setMilesPerYearFilter()
     * @uses GetRates1::setCoverageLevelFilter()
     * @uses GetRates1::setEndOdometerFilter()
     * @uses GetRates1::setProductIdFilter()
     * @param string $entityType
     * @param int $vehicleId
     * @param int $targetResponseId
     * @param \StructType\SecureWebService_RangeFilter $termMilesFilter
     * @param \StructType\SecureWebService_RangeFilter $termMonthsFilter
     * @param \StructType\SecureWebService_RangeFilter $milesPerYearFilter
     * @param \StructType\SecureWebService_RangeFilter $coverageLevelFilter
     * @param \StructType\SecureWebService_RangeFilter $endOdometerFilter
     * @param \ArrayType\ArrayOfint $productIdFilter
     */
    public function __construct($entityType = null, $vehicleId = null, $targetResponseId = null, \StructType\SecureWebService_RangeFilter $termMilesFilter = null, \StructType\SecureWebService_RangeFilter $termMonthsFilter = null, \StructType\SecureWebService_RangeFilter $milesPerYearFilter = null, \StructType\SecureWebService_RangeFilter $coverageLevelFilter = null, \StructType\SecureWebService_RangeFilter $endOdometerFilter = null, \ArrayType\ArrayOfint $productIdFilter = null)
    {
        $this
            ->setEntityType($entityType)
            ->setVehicleId($vehicleId)
            ->setTargetResponseId($targetResponseId)
            ->setTermMilesFilter($termMilesFilter)
            ->setTermMonthsFilter($termMonthsFilter)
            ->setMilesPerYearFilter($milesPerYearFilter)
            ->setCoverageLevelFilter($coverageLevelFilter)
            ->setEndOdometerFilter($endOdometerFilter)
            ->setProductIdFilter($productIdFilter);
    }
    /**
     * Get entityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->entityType) ? $this->entityType : null;
    }
    /**
     * Set entityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\GetRates1
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->entityType);
        } else {
            $this->entityType = $entityType;
        }
        return $this;
    }
    /**
     * Get vehicleId value
     * @return int|null
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }
    /**
     * Set vehicleId value
     * @param int $vehicleId
     * @return \StructType\GetRates1
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        $this->vehicleId = $vehicleId;
        return $this;
    }
    /**
     * Get targetResponseId value
     * @return int|null
     */
    public function getTargetResponseId()
    {
        return $this->targetResponseId;
    }
    /**
     * Set targetResponseId value
     * @param int $targetResponseId
     * @return \StructType\GetRates1
     */
    public function setTargetResponseId($targetResponseId = null)
    {
        // validation for constraint: int
        if (!is_null($targetResponseId) && !(is_int($targetResponseId) || ctype_digit($targetResponseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($targetResponseId, true), gettype($targetResponseId)), __LINE__);
        }
        $this->targetResponseId = $targetResponseId;
        return $this;
    }
    /**
     * Get termMilesFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getTermMilesFilter()
    {
        return isset($this->termMilesFilter) ? $this->termMilesFilter : null;
    }
    /**
     * Set termMilesFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $termMilesFilter
     * @return \StructType\GetRates1
     */
    public function setTermMilesFilter(\StructType\SecureWebService_RangeFilter $termMilesFilter = null)
    {
        if (is_null($termMilesFilter) || (is_array($termMilesFilter) && empty($termMilesFilter))) {
            unset($this->termMilesFilter);
        } else {
            $this->termMilesFilter = $termMilesFilter;
        }
        return $this;
    }
    /**
     * Get termMonthsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getTermMonthsFilter()
    {
        return isset($this->termMonthsFilter) ? $this->termMonthsFilter : null;
    }
    /**
     * Set termMonthsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $termMonthsFilter
     * @return \StructType\GetRates1
     */
    public function setTermMonthsFilter(\StructType\SecureWebService_RangeFilter $termMonthsFilter = null)
    {
        if (is_null($termMonthsFilter) || (is_array($termMonthsFilter) && empty($termMonthsFilter))) {
            unset($this->termMonthsFilter);
        } else {
            $this->termMonthsFilter = $termMonthsFilter;
        }
        return $this;
    }
    /**
     * Get milesPerYearFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getMilesPerYearFilter()
    {
        return isset($this->milesPerYearFilter) ? $this->milesPerYearFilter : null;
    }
    /**
     * Set milesPerYearFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $milesPerYearFilter
     * @return \StructType\GetRates1
     */
    public function setMilesPerYearFilter(\StructType\SecureWebService_RangeFilter $milesPerYearFilter = null)
    {
        if (is_null($milesPerYearFilter) || (is_array($milesPerYearFilter) && empty($milesPerYearFilter))) {
            unset($this->milesPerYearFilter);
        } else {
            $this->milesPerYearFilter = $milesPerYearFilter;
        }
        return $this;
    }
    /**
     * Get coverageLevelFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getCoverageLevelFilter()
    {
        return isset($this->coverageLevelFilter) ? $this->coverageLevelFilter : null;
    }
    /**
     * Set coverageLevelFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $coverageLevelFilter
     * @return \StructType\GetRates1
     */
    public function setCoverageLevelFilter(\StructType\SecureWebService_RangeFilter $coverageLevelFilter = null)
    {
        if (is_null($coverageLevelFilter) || (is_array($coverageLevelFilter) && empty($coverageLevelFilter))) {
            unset($this->coverageLevelFilter);
        } else {
            $this->coverageLevelFilter = $coverageLevelFilter;
        }
        return $this;
    }
    /**
     * Get endOdometerFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SecureWebService_RangeFilter|null
     */
    public function getEndOdometerFilter()
    {
        return isset($this->endOdometerFilter) ? $this->endOdometerFilter : null;
    }
    /**
     * Set endOdometerFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SecureWebService_RangeFilter $endOdometerFilter
     * @return \StructType\GetRates1
     */
    public function setEndOdometerFilter(\StructType\SecureWebService_RangeFilter $endOdometerFilter = null)
    {
        if (is_null($endOdometerFilter) || (is_array($endOdometerFilter) && empty($endOdometerFilter))) {
            unset($this->endOdometerFilter);
        } else {
            $this->endOdometerFilter = $endOdometerFilter;
        }
        return $this;
    }
    /**
     * Get productIdFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getProductIdFilter()
    {
        return isset($this->productIdFilter) ? $this->productIdFilter : null;
    }
    /**
     * Set productIdFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $productIdFilter
     * @return \StructType\GetRates1
     */
    public function setProductIdFilter(\ArrayType\ArrayOfint $productIdFilter = null)
    {
        if (is_null($productIdFilter) || (is_array($productIdFilter) && empty($productIdFilter))) {
            unset($this->productIdFilter);
        } else {
            $this->productIdFilter = $productIdFilter;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRates1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
