<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPoliciesByDateRange2 StructType
 * @subpackage Structs
 */
class GetPoliciesByDateRange2 extends AbstractStructBase
{
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The userIdFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userIdFilter;
    /**
     * The statusFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $statusFilter;
    /**
     * Constructor method for GetPoliciesByDateRange2
     * @uses GetPoliciesByDateRange2::setStartDate()
     * @uses GetPoliciesByDateRange2::setEndDate()
     * @uses GetPoliciesByDateRange2::setUserIdFilter()
     * @uses GetPoliciesByDateRange2::setStatusFilter()
     * @param string $startDate
     * @param string $endDate
     * @param string $userIdFilter
     * @param \ArrayType\ArrayOfstring $statusFilter
     */
    public function __construct($startDate = null, $endDate = null, $userIdFilter = null, \ArrayType\ArrayOfstring $statusFilter = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setUserIdFilter($userIdFilter)
            ->setStatusFilter($statusFilter);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetPoliciesByDateRange2
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\GetPoliciesByDateRange2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get userIdFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserIdFilter()
    {
        return isset($this->userIdFilter) ? $this->userIdFilter : null;
    }
    /**
     * Set userIdFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userIdFilter
     * @return \StructType\GetPoliciesByDateRange2
     */
    public function setUserIdFilter($userIdFilter = null)
    {
        // validation for constraint: string
        if (!is_null($userIdFilter) && !is_string($userIdFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdFilter, true), gettype($userIdFilter)), __LINE__);
        }
        if (is_null($userIdFilter) || (is_array($userIdFilter) && empty($userIdFilter))) {
            unset($this->userIdFilter);
        } else {
            $this->userIdFilter = $userIdFilter;
        }
        return $this;
    }
    /**
     * Get statusFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getStatusFilter()
    {
        return isset($this->statusFilter) ? $this->statusFilter : null;
    }
    /**
     * Set statusFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $statusFilter
     * @return \StructType\GetPoliciesByDateRange2
     */
    public function setStatusFilter(\ArrayType\ArrayOfstring $statusFilter = null)
    {
        if (is_null($statusFilter) || (is_array($statusFilter) && empty($statusFilter))) {
            unset($this->statusFilter);
        } else {
            $this->statusFilter = $statusFilter;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPoliciesByDateRange2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
