<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMostRecentCampaignTarget StructType
 * @subpackage Structs
 */
class GetMostRecentCampaignTarget extends AbstractStructBase
{
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $entityId;
    /**
     * The entityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $entityType;
    /**
     * The responseIfExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $responseIfExists;
    /**
     * Constructor method for GetMostRecentCampaignTarget
     * @uses GetMostRecentCampaignTarget::setEntityId()
     * @uses GetMostRecentCampaignTarget::setEntityType()
     * @uses GetMostRecentCampaignTarget::setResponseIfExists()
     * @param int $entityId
     * @param string $entityType
     * @param bool $responseIfExists
     */
    public function __construct($entityId = null, $entityType = null, $responseIfExists = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setResponseIfExists($responseIfExists);
    }
    /**
     * Get entityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param int $entityId
     * @return \StructType\GetMostRecentCampaignTarget
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get entityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->entityType) ? $this->entityType : null;
    }
    /**
     * Set entityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\GetMostRecentCampaignTarget
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->entityType);
        } else {
            $this->entityType = $entityType;
        }
        return $this;
    }
    /**
     * Get responseIfExists value
     * @return bool|null
     */
    public function getResponseIfExists()
    {
        return $this->responseIfExists;
    }
    /**
     * Set responseIfExists value
     * @param bool $responseIfExists
     * @return \StructType\GetMostRecentCampaignTarget
     */
    public function setResponseIfExists($responseIfExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($responseIfExists) && !is_bool($responseIfExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($responseIfExists, true), gettype($responseIfExists)), __LINE__);
        }
        $this->responseIfExists = $responseIfExists;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMostRecentCampaignTarget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
