<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coverage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Coverage
 * @subpackage Structs
 */
class Coverage extends AbstractStructBase
{
    /**
     * The APRFinanceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $APRFinanceCharge;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The ActiveDeducts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveDeducts;
    /**
     * The AdminBaseSupplement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdminBaseSupplement;
    /**
     * The AdminMarketerCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdminMarketerCommission;
    /**
     * The AllowPaidInFull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowPaidInFull;
    /**
     * The AllowSelfFinance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowSelfFinance;
    /**
     * The ApplySalesTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ApplySalesTax;
    /**
     * The ClassEngineId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ClassEngineId;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Color;
    /**
     * The ContractVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractVersion;
    /**
     * The CoverageAlias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageAlias;
    /**
     * The CoverageDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageDescription;
    /**
     * The CoverageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CoverageId;
    /**
     * The CoverageName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageName;
    /**
     * The CoverageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CoverageType;
    /**
     * The CustomDataField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomDataField;
    /**
     * The DeductSysFeeFromRP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DeductSysFeeFromRP;
    /**
     * The DefDPAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DefDPAmount;
    /**
     * The DefDPPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DefDPPercent;
    /**
     * The DefaultDeductible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DefaultDeductible;
    /**
     * The EmailFulfillmentCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EmailFulfillmentCredit;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The FinanceProgramId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FinanceProgramId;
    /**
     * The FixedMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FixedMarkup;
    /**
     * The IncludeTaxInRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeTaxInRate;
    /**
     * The MaxCancelFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxCancelFee;
    /**
     * The MaxDPPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxDPPercent;
    /**
     * The MinDPAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinDPAmount;
    /**
     * The MinDPOverridePercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinDPOverridePercent;
    /**
     * The MinDPPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinDPPercent;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Priority;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The PurchDateRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PurchDateRequired;
    /**
     * The RequiredDocCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequiredDocCategory;
    /**
     * The SystemCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SystemCharge;
    /**
     * The VariableMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkup;
    /**
     * The VariableMarkupMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkupMax;
    /**
     * The VariableMarkupMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VariableMarkupMin;
    /**
     * The WebLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebLink;
    /**
     * Constructor method for Coverage
     * @uses Coverage::setAPRFinanceCharge()
     * @uses Coverage::setActive()
     * @uses Coverage::setActiveDeducts()
     * @uses Coverage::setAdminBaseSupplement()
     * @uses Coverage::setAdminMarketerCommission()
     * @uses Coverage::setAllowPaidInFull()
     * @uses Coverage::setAllowSelfFinance()
     * @uses Coverage::setApplySalesTax()
     * @uses Coverage::setClassEngineId()
     * @uses Coverage::setColor()
     * @uses Coverage::setContractVersion()
     * @uses Coverage::setCoverageAlias()
     * @uses Coverage::setCoverageDescription()
     * @uses Coverage::setCoverageId()
     * @uses Coverage::setCoverageName()
     * @uses Coverage::setCoverageType()
     * @uses Coverage::setCustomDataField()
     * @uses Coverage::setDeductSysFeeFromRP()
     * @uses Coverage::setDefDPAmount()
     * @uses Coverage::setDefDPPercent()
     * @uses Coverage::setDefaultDeductible()
     * @uses Coverage::setEmailFulfillmentCredit()
     * @uses Coverage::setExternalId()
     * @uses Coverage::setFinanceProgramId()
     * @uses Coverage::setFixedMarkup()
     * @uses Coverage::setIncludeTaxInRate()
     * @uses Coverage::setMaxCancelFee()
     * @uses Coverage::setMaxDPPercent()
     * @uses Coverage::setMinDPAmount()
     * @uses Coverage::setMinDPOverridePercent()
     * @uses Coverage::setMinDPPercent()
     * @uses Coverage::setPriority()
     * @uses Coverage::setProductId()
     * @uses Coverage::setPurchDateRequired()
     * @uses Coverage::setRequiredDocCategory()
     * @uses Coverage::setSystemCharge()
     * @uses Coverage::setVariableMarkup()
     * @uses Coverage::setVariableMarkupMax()
     * @uses Coverage::setVariableMarkupMin()
     * @uses Coverage::setWebLink()
     * @param bool $aPRFinanceCharge
     * @param bool $active
     * @param string $activeDeducts
     * @param float $adminBaseSupplement
     * @param float $adminMarketerCommission
     * @param bool $allowPaidInFull
     * @param bool $allowSelfFinance
     * @param bool $applySalesTax
     * @param int $classEngineId
     * @param string $color
     * @param string $contractVersion
     * @param string $coverageAlias
     * @param string $coverageDescription
     * @param int $coverageId
     * @param string $coverageName
     * @param string $coverageType
     * @param string $customDataField
     * @param bool $deductSysFeeFromRP
     * @param float $defDPAmount
     * @param float $defDPPercent
     * @param float $defaultDeductible
     * @param float $emailFulfillmentCredit
     * @param string $externalId
     * @param int $financeProgramId
     * @param float $fixedMarkup
     * @param bool $includeTaxInRate
     * @param float $maxCancelFee
     * @param float $maxDPPercent
     * @param float $minDPAmount
     * @param float $minDPOverridePercent
     * @param float $minDPPercent
     * @param int $priority
     * @param int $productId
     * @param bool $purchDateRequired
     * @param string $requiredDocCategory
     * @param float $systemCharge
     * @param float $variableMarkup
     * @param float $variableMarkupMax
     * @param float $variableMarkupMin
     * @param string $webLink
     */
    public function __construct($aPRFinanceCharge = null, $active = null, $activeDeducts = null, $adminBaseSupplement = null, $adminMarketerCommission = null, $allowPaidInFull = null, $allowSelfFinance = null, $applySalesTax = null, $classEngineId = null, $color = null, $contractVersion = null, $coverageAlias = null, $coverageDescription = null, $coverageId = null, $coverageName = null, $coverageType = null, $customDataField = null, $deductSysFeeFromRP = null, $defDPAmount = null, $defDPPercent = null, $defaultDeductible = null, $emailFulfillmentCredit = null, $externalId = null, $financeProgramId = null, $fixedMarkup = null, $includeTaxInRate = null, $maxCancelFee = null, $maxDPPercent = null, $minDPAmount = null, $minDPOverridePercent = null, $minDPPercent = null, $priority = null, $productId = null, $purchDateRequired = null, $requiredDocCategory = null, $systemCharge = null, $variableMarkup = null, $variableMarkupMax = null, $variableMarkupMin = null, $webLink = null)
    {
        $this
            ->setAPRFinanceCharge($aPRFinanceCharge)
            ->setActive($active)
            ->setActiveDeducts($activeDeducts)
            ->setAdminBaseSupplement($adminBaseSupplement)
            ->setAdminMarketerCommission($adminMarketerCommission)
            ->setAllowPaidInFull($allowPaidInFull)
            ->setAllowSelfFinance($allowSelfFinance)
            ->setApplySalesTax($applySalesTax)
            ->setClassEngineId($classEngineId)
            ->setColor($color)
            ->setContractVersion($contractVersion)
            ->setCoverageAlias($coverageAlias)
            ->setCoverageDescription($coverageDescription)
            ->setCoverageId($coverageId)
            ->setCoverageName($coverageName)
            ->setCoverageType($coverageType)
            ->setCustomDataField($customDataField)
            ->setDeductSysFeeFromRP($deductSysFeeFromRP)
            ->setDefDPAmount($defDPAmount)
            ->setDefDPPercent($defDPPercent)
            ->setDefaultDeductible($defaultDeductible)
            ->setEmailFulfillmentCredit($emailFulfillmentCredit)
            ->setExternalId($externalId)
            ->setFinanceProgramId($financeProgramId)
            ->setFixedMarkup($fixedMarkup)
            ->setIncludeTaxInRate($includeTaxInRate)
            ->setMaxCancelFee($maxCancelFee)
            ->setMaxDPPercent($maxDPPercent)
            ->setMinDPAmount($minDPAmount)
            ->setMinDPOverridePercent($minDPOverridePercent)
            ->setMinDPPercent($minDPPercent)
            ->setPriority($priority)
            ->setProductId($productId)
            ->setPurchDateRequired($purchDateRequired)
            ->setRequiredDocCategory($requiredDocCategory)
            ->setSystemCharge($systemCharge)
            ->setVariableMarkup($variableMarkup)
            ->setVariableMarkupMax($variableMarkupMax)
            ->setVariableMarkupMin($variableMarkupMin)
            ->setWebLink($webLink);
    }
    /**
     * Get APRFinanceCharge value
     * @return bool|null
     */
    public function getAPRFinanceCharge()
    {
        return $this->APRFinanceCharge;
    }
    /**
     * Set APRFinanceCharge value
     * @param bool $aPRFinanceCharge
     * @return \StructType\Coverage
     */
    public function setAPRFinanceCharge($aPRFinanceCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($aPRFinanceCharge) && !is_bool($aPRFinanceCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aPRFinanceCharge, true), gettype($aPRFinanceCharge)), __LINE__);
        }
        $this->APRFinanceCharge = $aPRFinanceCharge;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Coverage
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ActiveDeducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveDeducts()
    {
        return isset($this->ActiveDeducts) ? $this->ActiveDeducts : null;
    }
    /**
     * Set ActiveDeducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeDeducts
     * @return \StructType\Coverage
     */
    public function setActiveDeducts($activeDeducts = null)
    {
        // validation for constraint: string
        if (!is_null($activeDeducts) && !is_string($activeDeducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDeducts, true), gettype($activeDeducts)), __LINE__);
        }
        if (is_null($activeDeducts) || (is_array($activeDeducts) && empty($activeDeducts))) {
            unset($this->ActiveDeducts);
        } else {
            $this->ActiveDeducts = $activeDeducts;
        }
        return $this;
    }
    /**
     * Get AdminBaseSupplement value
     * @return float|null
     */
    public function getAdminBaseSupplement()
    {
        return $this->AdminBaseSupplement;
    }
    /**
     * Set AdminBaseSupplement value
     * @param float $adminBaseSupplement
     * @return \StructType\Coverage
     */
    public function setAdminBaseSupplement($adminBaseSupplement = null)
    {
        // validation for constraint: float
        if (!is_null($adminBaseSupplement) && !(is_float($adminBaseSupplement) || is_numeric($adminBaseSupplement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adminBaseSupplement, true), gettype($adminBaseSupplement)), __LINE__);
        }
        $this->AdminBaseSupplement = $adminBaseSupplement;
        return $this;
    }
    /**
     * Get AdminMarketerCommission value
     * @return float|null
     */
    public function getAdminMarketerCommission()
    {
        return $this->AdminMarketerCommission;
    }
    /**
     * Set AdminMarketerCommission value
     * @param float $adminMarketerCommission
     * @return \StructType\Coverage
     */
    public function setAdminMarketerCommission($adminMarketerCommission = null)
    {
        // validation for constraint: float
        if (!is_null($adminMarketerCommission) && !(is_float($adminMarketerCommission) || is_numeric($adminMarketerCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adminMarketerCommission, true), gettype($adminMarketerCommission)), __LINE__);
        }
        $this->AdminMarketerCommission = $adminMarketerCommission;
        return $this;
    }
    /**
     * Get AllowPaidInFull value
     * @return bool|null
     */
    public function getAllowPaidInFull()
    {
        return $this->AllowPaidInFull;
    }
    /**
     * Set AllowPaidInFull value
     * @param bool $allowPaidInFull
     * @return \StructType\Coverage
     */
    public function setAllowPaidInFull($allowPaidInFull = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPaidInFull) && !is_bool($allowPaidInFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPaidInFull, true), gettype($allowPaidInFull)), __LINE__);
        }
        $this->AllowPaidInFull = $allowPaidInFull;
        return $this;
    }
    /**
     * Get AllowSelfFinance value
     * @return bool|null
     */
    public function getAllowSelfFinance()
    {
        return $this->AllowSelfFinance;
    }
    /**
     * Set AllowSelfFinance value
     * @param bool $allowSelfFinance
     * @return \StructType\Coverage
     */
    public function setAllowSelfFinance($allowSelfFinance = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSelfFinance) && !is_bool($allowSelfFinance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSelfFinance, true), gettype($allowSelfFinance)), __LINE__);
        }
        $this->AllowSelfFinance = $allowSelfFinance;
        return $this;
    }
    /**
     * Get ApplySalesTax value
     * @return bool|null
     */
    public function getApplySalesTax()
    {
        return $this->ApplySalesTax;
    }
    /**
     * Set ApplySalesTax value
     * @param bool $applySalesTax
     * @return \StructType\Coverage
     */
    public function setApplySalesTax($applySalesTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($applySalesTax) && !is_bool($applySalesTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applySalesTax, true), gettype($applySalesTax)), __LINE__);
        }
        $this->ApplySalesTax = $applySalesTax;
        return $this;
    }
    /**
     * Get ClassEngineId value
     * @return int|null
     */
    public function getClassEngineId()
    {
        return $this->ClassEngineId;
    }
    /**
     * Set ClassEngineId value
     * @param int $classEngineId
     * @return \StructType\Coverage
     */
    public function setClassEngineId($classEngineId = null)
    {
        // validation for constraint: int
        if (!is_null($classEngineId) && !(is_int($classEngineId) || ctype_digit($classEngineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($classEngineId, true), gettype($classEngineId)), __LINE__);
        }
        $this->ClassEngineId = $classEngineId;
        return $this;
    }
    /**
     * Get Color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColor()
    {
        return isset($this->Color) ? $this->Color : null;
    }
    /**
     * Set Color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $color
     * @return \StructType\Coverage
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->Color);
        } else {
            $this->Color = $color;
        }
        return $this;
    }
    /**
     * Get ContractVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractVersion()
    {
        return isset($this->ContractVersion) ? $this->ContractVersion : null;
    }
    /**
     * Set ContractVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractVersion
     * @return \StructType\Coverage
     */
    public function setContractVersion($contractVersion = null)
    {
        // validation for constraint: string
        if (!is_null($contractVersion) && !is_string($contractVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractVersion, true), gettype($contractVersion)), __LINE__);
        }
        if (is_null($contractVersion) || (is_array($contractVersion) && empty($contractVersion))) {
            unset($this->ContractVersion);
        } else {
            $this->ContractVersion = $contractVersion;
        }
        return $this;
    }
    /**
     * Get CoverageAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageAlias()
    {
        return isset($this->CoverageAlias) ? $this->CoverageAlias : null;
    }
    /**
     * Set CoverageAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageAlias
     * @return \StructType\Coverage
     */
    public function setCoverageAlias($coverageAlias = null)
    {
        // validation for constraint: string
        if (!is_null($coverageAlias) && !is_string($coverageAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageAlias, true), gettype($coverageAlias)), __LINE__);
        }
        if (is_null($coverageAlias) || (is_array($coverageAlias) && empty($coverageAlias))) {
            unset($this->CoverageAlias);
        } else {
            $this->CoverageAlias = $coverageAlias;
        }
        return $this;
    }
    /**
     * Get CoverageDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageDescription()
    {
        return isset($this->CoverageDescription) ? $this->CoverageDescription : null;
    }
    /**
     * Set CoverageDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageDescription
     * @return \StructType\Coverage
     */
    public function setCoverageDescription($coverageDescription = null)
    {
        // validation for constraint: string
        if (!is_null($coverageDescription) && !is_string($coverageDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageDescription, true), gettype($coverageDescription)), __LINE__);
        }
        if (is_null($coverageDescription) || (is_array($coverageDescription) && empty($coverageDescription))) {
            unset($this->CoverageDescription);
        } else {
            $this->CoverageDescription = $coverageDescription;
        }
        return $this;
    }
    /**
     * Get CoverageId value
     * @return int|null
     */
    public function getCoverageId()
    {
        return $this->CoverageId;
    }
    /**
     * Set CoverageId value
     * @param int $coverageId
     * @return \StructType\Coverage
     */
    public function setCoverageId($coverageId = null)
    {
        // validation for constraint: int
        if (!is_null($coverageId) && !(is_int($coverageId) || ctype_digit($coverageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coverageId, true), gettype($coverageId)), __LINE__);
        }
        $this->CoverageId = $coverageId;
        return $this;
    }
    /**
     * Get CoverageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageName()
    {
        return isset($this->CoverageName) ? $this->CoverageName : null;
    }
    /**
     * Set CoverageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageName
     * @return \StructType\Coverage
     */
    public function setCoverageName($coverageName = null)
    {
        // validation for constraint: string
        if (!is_null($coverageName) && !is_string($coverageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageName, true), gettype($coverageName)), __LINE__);
        }
        if (is_null($coverageName) || (is_array($coverageName) && empty($coverageName))) {
            unset($this->CoverageName);
        } else {
            $this->CoverageName = $coverageName;
        }
        return $this;
    }
    /**
     * Get CoverageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoverageType()
    {
        return isset($this->CoverageType) ? $this->CoverageType : null;
    }
    /**
     * Set CoverageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coverageType
     * @return \StructType\Coverage
     */
    public function setCoverageType($coverageType = null)
    {
        // validation for constraint: string
        if (!is_null($coverageType) && !is_string($coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageType, true), gettype($coverageType)), __LINE__);
        }
        if (is_null($coverageType) || (is_array($coverageType) && empty($coverageType))) {
            unset($this->CoverageType);
        } else {
            $this->CoverageType = $coverageType;
        }
        return $this;
    }
    /**
     * Get CustomDataField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomDataField()
    {
        return isset($this->CustomDataField) ? $this->CustomDataField : null;
    }
    /**
     * Set CustomDataField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customDataField
     * @return \StructType\Coverage
     */
    public function setCustomDataField($customDataField = null)
    {
        // validation for constraint: string
        if (!is_null($customDataField) && !is_string($customDataField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customDataField, true), gettype($customDataField)), __LINE__);
        }
        if (is_null($customDataField) || (is_array($customDataField) && empty($customDataField))) {
            unset($this->CustomDataField);
        } else {
            $this->CustomDataField = $customDataField;
        }
        return $this;
    }
    /**
     * Get DeductSysFeeFromRP value
     * @return bool|null
     */
    public function getDeductSysFeeFromRP()
    {
        return $this->DeductSysFeeFromRP;
    }
    /**
     * Set DeductSysFeeFromRP value
     * @param bool $deductSysFeeFromRP
     * @return \StructType\Coverage
     */
    public function setDeductSysFeeFromRP($deductSysFeeFromRP = null)
    {
        // validation for constraint: boolean
        if (!is_null($deductSysFeeFromRP) && !is_bool($deductSysFeeFromRP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deductSysFeeFromRP, true), gettype($deductSysFeeFromRP)), __LINE__);
        }
        $this->DeductSysFeeFromRP = $deductSysFeeFromRP;
        return $this;
    }
    /**
     * Get DefDPAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDefDPAmount()
    {
        return isset($this->DefDPAmount) ? $this->DefDPAmount : null;
    }
    /**
     * Set DefDPAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $defDPAmount
     * @return \StructType\Coverage
     */
    public function setDefDPAmount($defDPAmount = null)
    {
        // validation for constraint: float
        if (!is_null($defDPAmount) && !(is_float($defDPAmount) || is_numeric($defDPAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defDPAmount, true), gettype($defDPAmount)), __LINE__);
        }
        if (is_null($defDPAmount) || (is_array($defDPAmount) && empty($defDPAmount))) {
            unset($this->DefDPAmount);
        } else {
            $this->DefDPAmount = $defDPAmount;
        }
        return $this;
    }
    /**
     * Get DefDPPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDefDPPercent()
    {
        return isset($this->DefDPPercent) ? $this->DefDPPercent : null;
    }
    /**
     * Set DefDPPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $defDPPercent
     * @return \StructType\Coverage
     */
    public function setDefDPPercent($defDPPercent = null)
    {
        // validation for constraint: float
        if (!is_null($defDPPercent) && !(is_float($defDPPercent) || is_numeric($defDPPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defDPPercent, true), gettype($defDPPercent)), __LINE__);
        }
        if (is_null($defDPPercent) || (is_array($defDPPercent) && empty($defDPPercent))) {
            unset($this->DefDPPercent);
        } else {
            $this->DefDPPercent = $defDPPercent;
        }
        return $this;
    }
    /**
     * Get DefaultDeductible value
     * @return float|null
     */
    public function getDefaultDeductible()
    {
        return $this->DefaultDeductible;
    }
    /**
     * Set DefaultDeductible value
     * @param float $defaultDeductible
     * @return \StructType\Coverage
     */
    public function setDefaultDeductible($defaultDeductible = null)
    {
        // validation for constraint: float
        if (!is_null($defaultDeductible) && !(is_float($defaultDeductible) || is_numeric($defaultDeductible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultDeductible, true), gettype($defaultDeductible)), __LINE__);
        }
        $this->DefaultDeductible = $defaultDeductible;
        return $this;
    }
    /**
     * Get EmailFulfillmentCredit value
     * @return float|null
     */
    public function getEmailFulfillmentCredit()
    {
        return $this->EmailFulfillmentCredit;
    }
    /**
     * Set EmailFulfillmentCredit value
     * @param float $emailFulfillmentCredit
     * @return \StructType\Coverage
     */
    public function setEmailFulfillmentCredit($emailFulfillmentCredit = null)
    {
        // validation for constraint: float
        if (!is_null($emailFulfillmentCredit) && !(is_float($emailFulfillmentCredit) || is_numeric($emailFulfillmentCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emailFulfillmentCredit, true), gettype($emailFulfillmentCredit)), __LINE__);
        }
        $this->EmailFulfillmentCredit = $emailFulfillmentCredit;
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \StructType\Coverage
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get FinanceProgramId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFinanceProgramId()
    {
        return isset($this->FinanceProgramId) ? $this->FinanceProgramId : null;
    }
    /**
     * Set FinanceProgramId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $financeProgramId
     * @return \StructType\Coverage
     */
    public function setFinanceProgramId($financeProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($financeProgramId) && !(is_int($financeProgramId) || ctype_digit($financeProgramId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($financeProgramId, true), gettype($financeProgramId)), __LINE__);
        }
        if (is_null($financeProgramId) || (is_array($financeProgramId) && empty($financeProgramId))) {
            unset($this->FinanceProgramId);
        } else {
            $this->FinanceProgramId = $financeProgramId;
        }
        return $this;
    }
    /**
     * Get FixedMarkup value
     * @return float|null
     */
    public function getFixedMarkup()
    {
        return $this->FixedMarkup;
    }
    /**
     * Set FixedMarkup value
     * @param float $fixedMarkup
     * @return \StructType\Coverage
     */
    public function setFixedMarkup($fixedMarkup = null)
    {
        // validation for constraint: float
        if (!is_null($fixedMarkup) && !(is_float($fixedMarkup) || is_numeric($fixedMarkup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedMarkup, true), gettype($fixedMarkup)), __LINE__);
        }
        $this->FixedMarkup = $fixedMarkup;
        return $this;
    }
    /**
     * Get IncludeTaxInRate value
     * @return bool|null
     */
    public function getIncludeTaxInRate()
    {
        return $this->IncludeTaxInRate;
    }
    /**
     * Set IncludeTaxInRate value
     * @param bool $includeTaxInRate
     * @return \StructType\Coverage
     */
    public function setIncludeTaxInRate($includeTaxInRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTaxInRate) && !is_bool($includeTaxInRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTaxInRate, true), gettype($includeTaxInRate)), __LINE__);
        }
        $this->IncludeTaxInRate = $includeTaxInRate;
        return $this;
    }
    /**
     * Get MaxCancelFee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxCancelFee()
    {
        return isset($this->MaxCancelFee) ? $this->MaxCancelFee : null;
    }
    /**
     * Set MaxCancelFee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxCancelFee
     * @return \StructType\Coverage
     */
    public function setMaxCancelFee($maxCancelFee = null)
    {
        // validation for constraint: float
        if (!is_null($maxCancelFee) && !(is_float($maxCancelFee) || is_numeric($maxCancelFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxCancelFee, true), gettype($maxCancelFee)), __LINE__);
        }
        if (is_null($maxCancelFee) || (is_array($maxCancelFee) && empty($maxCancelFee))) {
            unset($this->MaxCancelFee);
        } else {
            $this->MaxCancelFee = $maxCancelFee;
        }
        return $this;
    }
    /**
     * Get MaxDPPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxDPPercent()
    {
        return isset($this->MaxDPPercent) ? $this->MaxDPPercent : null;
    }
    /**
     * Set MaxDPPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxDPPercent
     * @return \StructType\Coverage
     */
    public function setMaxDPPercent($maxDPPercent = null)
    {
        // validation for constraint: float
        if (!is_null($maxDPPercent) && !(is_float($maxDPPercent) || is_numeric($maxDPPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxDPPercent, true), gettype($maxDPPercent)), __LINE__);
        }
        if (is_null($maxDPPercent) || (is_array($maxDPPercent) && empty($maxDPPercent))) {
            unset($this->MaxDPPercent);
        } else {
            $this->MaxDPPercent = $maxDPPercent;
        }
        return $this;
    }
    /**
     * Get MinDPAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinDPAmount()
    {
        return isset($this->MinDPAmount) ? $this->MinDPAmount : null;
    }
    /**
     * Set MinDPAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minDPAmount
     * @return \StructType\Coverage
     */
    public function setMinDPAmount($minDPAmount = null)
    {
        // validation for constraint: float
        if (!is_null($minDPAmount) && !(is_float($minDPAmount) || is_numeric($minDPAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minDPAmount, true), gettype($minDPAmount)), __LINE__);
        }
        if (is_null($minDPAmount) || (is_array($minDPAmount) && empty($minDPAmount))) {
            unset($this->MinDPAmount);
        } else {
            $this->MinDPAmount = $minDPAmount;
        }
        return $this;
    }
    /**
     * Get MinDPOverridePercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinDPOverridePercent()
    {
        return isset($this->MinDPOverridePercent) ? $this->MinDPOverridePercent : null;
    }
    /**
     * Set MinDPOverridePercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minDPOverridePercent
     * @return \StructType\Coverage
     */
    public function setMinDPOverridePercent($minDPOverridePercent = null)
    {
        // validation for constraint: float
        if (!is_null($minDPOverridePercent) && !(is_float($minDPOverridePercent) || is_numeric($minDPOverridePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minDPOverridePercent, true), gettype($minDPOverridePercent)), __LINE__);
        }
        if (is_null($minDPOverridePercent) || (is_array($minDPOverridePercent) && empty($minDPOverridePercent))) {
            unset($this->MinDPOverridePercent);
        } else {
            $this->MinDPOverridePercent = $minDPOverridePercent;
        }
        return $this;
    }
    /**
     * Get MinDPPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinDPPercent()
    {
        return isset($this->MinDPPercent) ? $this->MinDPPercent : null;
    }
    /**
     * Set MinDPPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minDPPercent
     * @return \StructType\Coverage
     */
    public function setMinDPPercent($minDPPercent = null)
    {
        // validation for constraint: float
        if (!is_null($minDPPercent) && !(is_float($minDPPercent) || is_numeric($minDPPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minDPPercent, true), gettype($minDPPercent)), __LINE__);
        }
        if (is_null($minDPPercent) || (is_array($minDPPercent) && empty($minDPPercent))) {
            unset($this->MinDPPercent);
        } else {
            $this->MinDPPercent = $minDPPercent;
        }
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\Coverage
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\Coverage
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get PurchDateRequired value
     * @return bool|null
     */
    public function getPurchDateRequired()
    {
        return $this->PurchDateRequired;
    }
    /**
     * Set PurchDateRequired value
     * @param bool $purchDateRequired
     * @return \StructType\Coverage
     */
    public function setPurchDateRequired($purchDateRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchDateRequired) && !is_bool($purchDateRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchDateRequired, true), gettype($purchDateRequired)), __LINE__);
        }
        $this->PurchDateRequired = $purchDateRequired;
        return $this;
    }
    /**
     * Get RequiredDocCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequiredDocCategory()
    {
        return isset($this->RequiredDocCategory) ? $this->RequiredDocCategory : null;
    }
    /**
     * Set RequiredDocCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requiredDocCategory
     * @return \StructType\Coverage
     */
    public function setRequiredDocCategory($requiredDocCategory = null)
    {
        // validation for constraint: string
        if (!is_null($requiredDocCategory) && !is_string($requiredDocCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiredDocCategory, true), gettype($requiredDocCategory)), __LINE__);
        }
        if (is_null($requiredDocCategory) || (is_array($requiredDocCategory) && empty($requiredDocCategory))) {
            unset($this->RequiredDocCategory);
        } else {
            $this->RequiredDocCategory = $requiredDocCategory;
        }
        return $this;
    }
    /**
     * Get SystemCharge value
     * @return float|null
     */
    public function getSystemCharge()
    {
        return $this->SystemCharge;
    }
    /**
     * Set SystemCharge value
     * @param float $systemCharge
     * @return \StructType\Coverage
     */
    public function setSystemCharge($systemCharge = null)
    {
        // validation for constraint: float
        if (!is_null($systemCharge) && !(is_float($systemCharge) || is_numeric($systemCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($systemCharge, true), gettype($systemCharge)), __LINE__);
        }
        $this->SystemCharge = $systemCharge;
        return $this;
    }
    /**
     * Get VariableMarkup value
     * @return float|null
     */
    public function getVariableMarkup()
    {
        return $this->VariableMarkup;
    }
    /**
     * Set VariableMarkup value
     * @param float $variableMarkup
     * @return \StructType\Coverage
     */
    public function setVariableMarkup($variableMarkup = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkup) && !(is_float($variableMarkup) || is_numeric($variableMarkup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkup, true), gettype($variableMarkup)), __LINE__);
        }
        $this->VariableMarkup = $variableMarkup;
        return $this;
    }
    /**
     * Get VariableMarkupMax value
     * @return float|null
     */
    public function getVariableMarkupMax()
    {
        return $this->VariableMarkupMax;
    }
    /**
     * Set VariableMarkupMax value
     * @param float $variableMarkupMax
     * @return \StructType\Coverage
     */
    public function setVariableMarkupMax($variableMarkupMax = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkupMax) && !(is_float($variableMarkupMax) || is_numeric($variableMarkupMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkupMax, true), gettype($variableMarkupMax)), __LINE__);
        }
        $this->VariableMarkupMax = $variableMarkupMax;
        return $this;
    }
    /**
     * Get VariableMarkupMin value
     * @return float|null
     */
    public function getVariableMarkupMin()
    {
        return $this->VariableMarkupMin;
    }
    /**
     * Set VariableMarkupMin value
     * @param float $variableMarkupMin
     * @return \StructType\Coverage
     */
    public function setVariableMarkupMin($variableMarkupMin = null)
    {
        // validation for constraint: float
        if (!is_null($variableMarkupMin) && !(is_float($variableMarkupMin) || is_numeric($variableMarkupMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableMarkupMin, true), gettype($variableMarkupMin)), __LINE__);
        }
        $this->VariableMarkupMin = $variableMarkupMin;
        return $this;
    }
    /**
     * Get WebLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebLink()
    {
        return isset($this->WebLink) ? $this->WebLink : null;
    }
    /**
     * Set WebLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webLink
     * @return \StructType\Coverage
     */
    public function setWebLink($webLink = null)
    {
        // validation for constraint: string
        if (!is_null($webLink) && !is_string($webLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webLink, true), gettype($webLink)), __LINE__);
        }
        if (is_null($webLink) || (is_array($webLink) && empty($webLink))) {
            unset($this->WebLink);
        } else {
            $this->WebLink = $webLink;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Coverage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
