<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignTarget StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignTarget
 * @subpackage Structs
 */
class CampaignTarget extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The CampaignTargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignTargetId;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContactId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The LeadId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LeadId;
    /**
     * The LeadSourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LeadSourceId;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The StateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateProvince;
    /**
     * The TargetIdentifier1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetIdentifier1;
    /**
     * The TargetIdentifier2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetIdentifier2;
    /**
     * The TargetStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TargetStartDate;
    /**
     * The TargetStopDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetStopDate;
    /**
     * Constructor method for CampaignTarget
     * @uses CampaignTarget::setCampaignId()
     * @uses CampaignTarget::setCampaignTargetId()
     * @uses CampaignTarget::setContactId()
     * @uses CampaignTarget::setCreateDate()
     * @uses CampaignTarget::setCreateUserId()
     * @uses CampaignTarget::setLeadId()
     * @uses CampaignTarget::setLeadSourceId()
     * @uses CampaignTarget::setResponseCode()
     * @uses CampaignTarget::setStateProvince()
     * @uses CampaignTarget::setTargetIdentifier1()
     * @uses CampaignTarget::setTargetIdentifier2()
     * @uses CampaignTarget::setTargetStartDate()
     * @uses CampaignTarget::setTargetStopDate()
     * @param int $campaignId
     * @param int $campaignTargetId
     * @param int $contactId
     * @param string $createDate
     * @param string $createUserId
     * @param int $leadId
     * @param int $leadSourceId
     * @param string $responseCode
     * @param string $stateProvince
     * @param string $targetIdentifier1
     * @param string $targetIdentifier2
     * @param string $targetStartDate
     * @param string $targetStopDate
     */
    public function __construct($campaignId = null, $campaignTargetId = null, $contactId = null, $createDate = null, $createUserId = null, $leadId = null, $leadSourceId = null, $responseCode = null, $stateProvince = null, $targetIdentifier1 = null, $targetIdentifier2 = null, $targetStartDate = null, $targetStopDate = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setCampaignTargetId($campaignTargetId)
            ->setContactId($contactId)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setLeadId($leadId)
            ->setLeadSourceId($leadSourceId)
            ->setResponseCode($responseCode)
            ->setStateProvince($stateProvince)
            ->setTargetIdentifier1($targetIdentifier1)
            ->setTargetIdentifier2($targetIdentifier2)
            ->setTargetStartDate($targetStartDate)
            ->setTargetStopDate($targetStopDate);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\CampaignTarget
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get CampaignTargetId value
     * @return int|null
     */
    public function getCampaignTargetId()
    {
        return $this->CampaignTargetId;
    }
    /**
     * Set CampaignTargetId value
     * @param int $campaignTargetId
     * @return \StructType\CampaignTarget
     */
    public function setCampaignTargetId($campaignTargetId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignTargetId) && !(is_int($campaignTargetId) || ctype_digit($campaignTargetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignTargetId, true), gettype($campaignTargetId)), __LINE__);
        }
        $this->CampaignTargetId = $campaignTargetId;
        return $this;
    }
    /**
     * Get ContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContactId()
    {
        return isset($this->ContactId) ? $this->ContactId : null;
    }
    /**
     * Set ContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contactId
     * @return \StructType\CampaignTarget
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        if (is_null($contactId) || (is_array($contactId) && empty($contactId))) {
            unset($this->ContactId);
        } else {
            $this->ContactId = $contactId;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\CampaignTarget
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\CampaignTarget
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get LeadId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeadId()
    {
        return isset($this->LeadId) ? $this->LeadId : null;
    }
    /**
     * Set LeadId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leadId
     * @return \StructType\CampaignTarget
     */
    public function setLeadId($leadId = null)
    {
        // validation for constraint: int
        if (!is_null($leadId) && !(is_int($leadId) || ctype_digit($leadId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadId, true), gettype($leadId)), __LINE__);
        }
        if (is_null($leadId) || (is_array($leadId) && empty($leadId))) {
            unset($this->LeadId);
        } else {
            $this->LeadId = $leadId;
        }
        return $this;
    }
    /**
     * Get LeadSourceId value
     * @return int|null
     */
    public function getLeadSourceId()
    {
        return $this->LeadSourceId;
    }
    /**
     * Set LeadSourceId value
     * @param int $leadSourceId
     * @return \StructType\CampaignTarget
     */
    public function setLeadSourceId($leadSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceId) && !(is_int($leadSourceId) || ctype_digit($leadSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadSourceId, true), gettype($leadSourceId)), __LINE__);
        }
        $this->LeadSourceId = $leadSourceId;
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\CampaignTarget
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get StateProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateProvince()
    {
        return isset($this->StateProvince) ? $this->StateProvince : null;
    }
    /**
     * Set StateProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateProvince
     * @return \StructType\CampaignTarget
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        if (is_null($stateProvince) || (is_array($stateProvince) && empty($stateProvince))) {
            unset($this->StateProvince);
        } else {
            $this->StateProvince = $stateProvince;
        }
        return $this;
    }
    /**
     * Get TargetIdentifier1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetIdentifier1()
    {
        return isset($this->TargetIdentifier1) ? $this->TargetIdentifier1 : null;
    }
    /**
     * Set TargetIdentifier1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetIdentifier1
     * @return \StructType\CampaignTarget
     */
    public function setTargetIdentifier1($targetIdentifier1 = null)
    {
        // validation for constraint: string
        if (!is_null($targetIdentifier1) && !is_string($targetIdentifier1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetIdentifier1, true), gettype($targetIdentifier1)), __LINE__);
        }
        if (is_null($targetIdentifier1) || (is_array($targetIdentifier1) && empty($targetIdentifier1))) {
            unset($this->TargetIdentifier1);
        } else {
            $this->TargetIdentifier1 = $targetIdentifier1;
        }
        return $this;
    }
    /**
     * Get TargetIdentifier2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetIdentifier2()
    {
        return isset($this->TargetIdentifier2) ? $this->TargetIdentifier2 : null;
    }
    /**
     * Set TargetIdentifier2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetIdentifier2
     * @return \StructType\CampaignTarget
     */
    public function setTargetIdentifier2($targetIdentifier2 = null)
    {
        // validation for constraint: string
        if (!is_null($targetIdentifier2) && !is_string($targetIdentifier2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetIdentifier2, true), gettype($targetIdentifier2)), __LINE__);
        }
        if (is_null($targetIdentifier2) || (is_array($targetIdentifier2) && empty($targetIdentifier2))) {
            unset($this->TargetIdentifier2);
        } else {
            $this->TargetIdentifier2 = $targetIdentifier2;
        }
        return $this;
    }
    /**
     * Get TargetStartDate value
     * @return string|null
     */
    public function getTargetStartDate()
    {
        return $this->TargetStartDate;
    }
    /**
     * Set TargetStartDate value
     * @param string $targetStartDate
     * @return \StructType\CampaignTarget
     */
    public function setTargetStartDate($targetStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetStartDate) && !is_string($targetStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetStartDate, true), gettype($targetStartDate)), __LINE__);
        }
        $this->TargetStartDate = $targetStartDate;
        return $this;
    }
    /**
     * Get TargetStopDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetStopDate()
    {
        return isset($this->TargetStopDate) ? $this->TargetStopDate : null;
    }
    /**
     * Set TargetStopDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetStopDate
     * @return \StructType\CampaignTarget
     */
    public function setTargetStopDate($targetStopDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetStopDate) && !is_string($targetStopDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetStopDate, true), gettype($targetStopDate)), __LINE__);
        }
        if (is_null($targetStopDate) || (is_array($targetStopDate) && empty($targetStopDate))) {
            unset($this->TargetStopDate);
        } else {
            $this->TargetStopDate = $targetStopDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignTarget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
