<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Campaign
 * @subpackage Structs
 */
class Campaign extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AffiliateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AffiliateId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The CampaignName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CampaignName;
    /**
     * The CampaignStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CampaignStartDate;
    /**
     * The CampaignType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CampaignType;
    /**
     * The CodePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePattern;
    /**
     * The CostPerTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CostPerTarget;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateUserId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The FixedMarkupAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FixedMarkupAdjustment;
    /**
     * The FollowupDistRuleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FollowupDistRuleId;
    /**
     * The FollowupStatusId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FollowupStatusId;
    /**
     * The LeadSourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LeadSourceId;
    /**
     * The ModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifyDate;
    /**
     * The ModifyUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifyUserId;
    /**
     * The PromptIfNoResponse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PromptIfNoResponse;
    /**
     * The RecordQueueId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecordQueueId;
    /**
     * The ResponseCodePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCodePrefix;
    /**
     * The ViewableForNewLeads
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ViewableForNewLeads;
    /**
     * Constructor method for Campaign
     * @uses Campaign::setActive()
     * @uses Campaign::setAffiliateId()
     * @uses Campaign::setCampaignId()
     * @uses Campaign::setCampaignName()
     * @uses Campaign::setCampaignStartDate()
     * @uses Campaign::setCampaignType()
     * @uses Campaign::setCodePattern()
     * @uses Campaign::setCostPerTarget()
     * @uses Campaign::setCreateDate()
     * @uses Campaign::setCreateUserId()
     * @uses Campaign::setExternalId()
     * @uses Campaign::setFixedMarkupAdjustment()
     * @uses Campaign::setFollowupDistRuleId()
     * @uses Campaign::setFollowupStatusId()
     * @uses Campaign::setLeadSourceId()
     * @uses Campaign::setModifyDate()
     * @uses Campaign::setModifyUserId()
     * @uses Campaign::setPromptIfNoResponse()
     * @uses Campaign::setRecordQueueId()
     * @uses Campaign::setResponseCodePrefix()
     * @uses Campaign::setViewableForNewLeads()
     * @param bool $active
     * @param int $affiliateId
     * @param int $campaignId
     * @param string $campaignName
     * @param string $campaignStartDate
     * @param string $campaignType
     * @param string $codePattern
     * @param float $costPerTarget
     * @param string $createDate
     * @param string $createUserId
     * @param string $externalId
     * @param float $fixedMarkupAdjustment
     * @param int $followupDistRuleId
     * @param int $followupStatusId
     * @param int $leadSourceId
     * @param string $modifyDate
     * @param string $modifyUserId
     * @param bool $promptIfNoResponse
     * @param int $recordQueueId
     * @param string $responseCodePrefix
     * @param bool $viewableForNewLeads
     */
    public function __construct($active = null, $affiliateId = null, $campaignId = null, $campaignName = null, $campaignStartDate = null, $campaignType = null, $codePattern = null, $costPerTarget = null, $createDate = null, $createUserId = null, $externalId = null, $fixedMarkupAdjustment = null, $followupDistRuleId = null, $followupStatusId = null, $leadSourceId = null, $modifyDate = null, $modifyUserId = null, $promptIfNoResponse = null, $recordQueueId = null, $responseCodePrefix = null, $viewableForNewLeads = null)
    {
        $this
            ->setActive($active)
            ->setAffiliateId($affiliateId)
            ->setCampaignId($campaignId)
            ->setCampaignName($campaignName)
            ->setCampaignStartDate($campaignStartDate)
            ->setCampaignType($campaignType)
            ->setCodePattern($codePattern)
            ->setCostPerTarget($costPerTarget)
            ->setCreateDate($createDate)
            ->setCreateUserId($createUserId)
            ->setExternalId($externalId)
            ->setFixedMarkupAdjustment($fixedMarkupAdjustment)
            ->setFollowupDistRuleId($followupDistRuleId)
            ->setFollowupStatusId($followupStatusId)
            ->setLeadSourceId($leadSourceId)
            ->setModifyDate($modifyDate)
            ->setModifyUserId($modifyUserId)
            ->setPromptIfNoResponse($promptIfNoResponse)
            ->setRecordQueueId($recordQueueId)
            ->setResponseCodePrefix($responseCodePrefix)
            ->setViewableForNewLeads($viewableForNewLeads);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Campaign
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AffiliateId value
     * @return int|null
     */
    public function getAffiliateId()
    {
        return $this->AffiliateId;
    }
    /**
     * Set AffiliateId value
     * @param int $affiliateId
     * @return \StructType\Campaign
     */
    public function setAffiliateId($affiliateId = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateId) && !(is_int($affiliateId) || ctype_digit($affiliateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateId, true), gettype($affiliateId)), __LINE__);
        }
        $this->AffiliateId = $affiliateId;
        return $this;
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\Campaign
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get CampaignName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignName()
    {
        return isset($this->CampaignName) ? $this->CampaignName : null;
    }
    /**
     * Set CampaignName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignName
     * @return \StructType\Campaign
     */
    public function setCampaignName($campaignName = null)
    {
        // validation for constraint: string
        if (!is_null($campaignName) && !is_string($campaignName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignName, true), gettype($campaignName)), __LINE__);
        }
        if (is_null($campaignName) || (is_array($campaignName) && empty($campaignName))) {
            unset($this->CampaignName);
        } else {
            $this->CampaignName = $campaignName;
        }
        return $this;
    }
    /**
     * Get CampaignStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignStartDate()
    {
        return isset($this->CampaignStartDate) ? $this->CampaignStartDate : null;
    }
    /**
     * Set CampaignStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignStartDate
     * @return \StructType\Campaign
     */
    public function setCampaignStartDate($campaignStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($campaignStartDate) && !is_string($campaignStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignStartDate, true), gettype($campaignStartDate)), __LINE__);
        }
        if (is_null($campaignStartDate) || (is_array($campaignStartDate) && empty($campaignStartDate))) {
            unset($this->CampaignStartDate);
        } else {
            $this->CampaignStartDate = $campaignStartDate;
        }
        return $this;
    }
    /**
     * Get CampaignType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignType()
    {
        return isset($this->CampaignType) ? $this->CampaignType : null;
    }
    /**
     * Set CampaignType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignType
     * @return \StructType\Campaign
     */
    public function setCampaignType($campaignType = null)
    {
        // validation for constraint: string
        if (!is_null($campaignType) && !is_string($campaignType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignType, true), gettype($campaignType)), __LINE__);
        }
        if (is_null($campaignType) || (is_array($campaignType) && empty($campaignType))) {
            unset($this->CampaignType);
        } else {
            $this->CampaignType = $campaignType;
        }
        return $this;
    }
    /**
     * Get CodePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePattern()
    {
        return isset($this->CodePattern) ? $this->CodePattern : null;
    }
    /**
     * Set CodePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePattern
     * @return \StructType\Campaign
     */
    public function setCodePattern($codePattern = null)
    {
        // validation for constraint: string
        if (!is_null($codePattern) && !is_string($codePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePattern, true), gettype($codePattern)), __LINE__);
        }
        if (is_null($codePattern) || (is_array($codePattern) && empty($codePattern))) {
            unset($this->CodePattern);
        } else {
            $this->CodePattern = $codePattern;
        }
        return $this;
    }
    /**
     * Get CostPerTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCostPerTarget()
    {
        return isset($this->CostPerTarget) ? $this->CostPerTarget : null;
    }
    /**
     * Set CostPerTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $costPerTarget
     * @return \StructType\Campaign
     */
    public function setCostPerTarget($costPerTarget = null)
    {
        // validation for constraint: float
        if (!is_null($costPerTarget) && !(is_float($costPerTarget) || is_numeric($costPerTarget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costPerTarget, true), gettype($costPerTarget)), __LINE__);
        }
        if (is_null($costPerTarget) || (is_array($costPerTarget) && empty($costPerTarget))) {
            unset($this->CostPerTarget);
        } else {
            $this->CostPerTarget = $costPerTarget;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Campaign
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateUserId()
    {
        return isset($this->CreateUserId) ? $this->CreateUserId : null;
    }
    /**
     * Set CreateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createUserId
     * @return \StructType\Campaign
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createUserId) && !is_string($createUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        if (is_null($createUserId) || (is_array($createUserId) && empty($createUserId))) {
            unset($this->CreateUserId);
        } else {
            $this->CreateUserId = $createUserId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \StructType\Campaign
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get FixedMarkupAdjustment value
     * @return float|null
     */
    public function getFixedMarkupAdjustment()
    {
        return $this->FixedMarkupAdjustment;
    }
    /**
     * Set FixedMarkupAdjustment value
     * @param float $fixedMarkupAdjustment
     * @return \StructType\Campaign
     */
    public function setFixedMarkupAdjustment($fixedMarkupAdjustment = null)
    {
        // validation for constraint: float
        if (!is_null($fixedMarkupAdjustment) && !(is_float($fixedMarkupAdjustment) || is_numeric($fixedMarkupAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedMarkupAdjustment, true), gettype($fixedMarkupAdjustment)), __LINE__);
        }
        $this->FixedMarkupAdjustment = $fixedMarkupAdjustment;
        return $this;
    }
    /**
     * Get FollowupDistRuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFollowupDistRuleId()
    {
        return isset($this->FollowupDistRuleId) ? $this->FollowupDistRuleId : null;
    }
    /**
     * Set FollowupDistRuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $followupDistRuleId
     * @return \StructType\Campaign
     */
    public function setFollowupDistRuleId($followupDistRuleId = null)
    {
        // validation for constraint: int
        if (!is_null($followupDistRuleId) && !(is_int($followupDistRuleId) || ctype_digit($followupDistRuleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($followupDistRuleId, true), gettype($followupDistRuleId)), __LINE__);
        }
        if (is_null($followupDistRuleId) || (is_array($followupDistRuleId) && empty($followupDistRuleId))) {
            unset($this->FollowupDistRuleId);
        } else {
            $this->FollowupDistRuleId = $followupDistRuleId;
        }
        return $this;
    }
    /**
     * Get FollowupStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFollowupStatusId()
    {
        return isset($this->FollowupStatusId) ? $this->FollowupStatusId : null;
    }
    /**
     * Set FollowupStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $followupStatusId
     * @return \StructType\Campaign
     */
    public function setFollowupStatusId($followupStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($followupStatusId) && !(is_int($followupStatusId) || ctype_digit($followupStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($followupStatusId, true), gettype($followupStatusId)), __LINE__);
        }
        if (is_null($followupStatusId) || (is_array($followupStatusId) && empty($followupStatusId))) {
            unset($this->FollowupStatusId);
        } else {
            $this->FollowupStatusId = $followupStatusId;
        }
        return $this;
    }
    /**
     * Get LeadSourceId value
     * @return int|null
     */
    public function getLeadSourceId()
    {
        return $this->LeadSourceId;
    }
    /**
     * Set LeadSourceId value
     * @param int $leadSourceId
     * @return \StructType\Campaign
     */
    public function setLeadSourceId($leadSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceId) && !(is_int($leadSourceId) || ctype_digit($leadSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadSourceId, true), gettype($leadSourceId)), __LINE__);
        }
        $this->LeadSourceId = $leadSourceId;
        return $this;
    }
    /**
     * Get ModifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->ModifyDate;
    }
    /**
     * Set ModifyDate value
     * @param string $modifyDate
     * @return \StructType\Campaign
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        $this->ModifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get ModifyUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifyUserId()
    {
        return isset($this->ModifyUserId) ? $this->ModifyUserId : null;
    }
    /**
     * Set ModifyUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifyUserId
     * @return \StructType\Campaign
     */
    public function setModifyUserId($modifyUserId = null)
    {
        // validation for constraint: string
        if (!is_null($modifyUserId) && !is_string($modifyUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyUserId, true), gettype($modifyUserId)), __LINE__);
        }
        if (is_null($modifyUserId) || (is_array($modifyUserId) && empty($modifyUserId))) {
            unset($this->ModifyUserId);
        } else {
            $this->ModifyUserId = $modifyUserId;
        }
        return $this;
    }
    /**
     * Get PromptIfNoResponse value
     * @return bool|null
     */
    public function getPromptIfNoResponse()
    {
        return $this->PromptIfNoResponse;
    }
    /**
     * Set PromptIfNoResponse value
     * @param bool $promptIfNoResponse
     * @return \StructType\Campaign
     */
    public function setPromptIfNoResponse($promptIfNoResponse = null)
    {
        // validation for constraint: boolean
        if (!is_null($promptIfNoResponse) && !is_bool($promptIfNoResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($promptIfNoResponse, true), gettype($promptIfNoResponse)), __LINE__);
        }
        $this->PromptIfNoResponse = $promptIfNoResponse;
        return $this;
    }
    /**
     * Get RecordQueueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecordQueueId()
    {
        return isset($this->RecordQueueId) ? $this->RecordQueueId : null;
    }
    /**
     * Set RecordQueueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recordQueueId
     * @return \StructType\Campaign
     */
    public function setRecordQueueId($recordQueueId = null)
    {
        // validation for constraint: int
        if (!is_null($recordQueueId) && !(is_int($recordQueueId) || ctype_digit($recordQueueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordQueueId, true), gettype($recordQueueId)), __LINE__);
        }
        if (is_null($recordQueueId) || (is_array($recordQueueId) && empty($recordQueueId))) {
            unset($this->RecordQueueId);
        } else {
            $this->RecordQueueId = $recordQueueId;
        }
        return $this;
    }
    /**
     * Get ResponseCodePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCodePrefix()
    {
        return isset($this->ResponseCodePrefix) ? $this->ResponseCodePrefix : null;
    }
    /**
     * Set ResponseCodePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCodePrefix
     * @return \StructType\Campaign
     */
    public function setResponseCodePrefix($responseCodePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($responseCodePrefix) && !is_string($responseCodePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCodePrefix, true), gettype($responseCodePrefix)), __LINE__);
        }
        if (is_null($responseCodePrefix) || (is_array($responseCodePrefix) && empty($responseCodePrefix))) {
            unset($this->ResponseCodePrefix);
        } else {
            $this->ResponseCodePrefix = $responseCodePrefix;
        }
        return $this;
    }
    /**
     * Get ViewableForNewLeads value
     * @return bool|null
     */
    public function getViewableForNewLeads()
    {
        return $this->ViewableForNewLeads;
    }
    /**
     * Set ViewableForNewLeads value
     * @param bool $viewableForNewLeads
     * @return \StructType\Campaign
     */
    public function setViewableForNewLeads($viewableForNewLeads = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewableForNewLeads) && !is_bool($viewableForNewLeads)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewableForNewLeads, true), gettype($viewableForNewLeads)), __LINE__);
        }
        $this->ViewableForNewLeads = $viewableForNewLeads;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Campaign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
