<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Decode ServiceType
 * @subpackage Services
 */
class Decode extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DecodeVin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DecodeVin $parameters
     * @return \StructType\DecodeVinResponse|bool
     */
    public function DecodeVin(\StructType\DecodeVin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DecodeVin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DecodeVinResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
