<?php

namespace EnumType;

/**
 * This class stands for HistoryCategory EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HistoryCategory
 * @subpackage Enumerations
 */
class HistoryCategory
{
    /**
     * Constant for value 'Audit'
     * @return string 'Audit'
     */
    const VALUE_AUDIT = 'Audit';
    /**
     * Constant for value 'DatabaseChange'
     * @return string 'DatabaseChange'
     */
    const VALUE_DATABASE_CHANGE = 'DatabaseChange';
    /**
     * Constant for value 'Note'
     * @return string 'Note'
     */
    const VALUE_NOTE = 'Note';
    /**
     * Constant for value 'Activity'
     * @return string 'Activity'
     */
    const VALUE_ACTIVITY = 'Activity';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUDIT
     * @uses self::VALUE_DATABASE_CHANGE
     * @uses self::VALUE_NOTE
     * @uses self::VALUE_ACTIVITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUDIT,
            self::VALUE_DATABASE_CHANGE,
            self::VALUE_NOTE,
            self::VALUE_ACTIVITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
