<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPickList ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPickList
 * @subpackage Arrays
 */
class ArrayOfPickList extends AbstractStructArrayBase
{
    /**
     * The PickList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PickList[]
     */
    public $PickList;
    /**
     * Constructor method for ArrayOfPickList
     * @uses ArrayOfPickList::setPickList()
     * @param \StructType\PickList[] $pickList
     */
    public function __construct(array $pickList = array())
    {
        $this
            ->setPickList($pickList);
    }
    /**
     * Get PickList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PickList[]|null
     */
    public function getPickList()
    {
        return isset($this->PickList) ? $this->PickList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPickList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickListForArrayConstraintsFromSetPickList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPickListPickListItem) {
            // validation for constraint: itemType
            if (!$arrayOfPickListPickListItem instanceof \StructType\PickList) {
                $invalidValues[] = is_object($arrayOfPickListPickListItem) ? get_class($arrayOfPickListPickListItem) : sprintf('%s(%s)', gettype($arrayOfPickListPickListItem), var_export($arrayOfPickListPickListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PickList property can only contain items of type \StructType\PickList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PickList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PickList[] $pickList
     * @return \ArrayType\ArrayOfPickList
     */
    public function setPickList(array $pickList = array())
    {
        // validation for constraint: array
        if ('' !== ($pickListArrayErrorMessage = self::validatePickListForArrayConstraintsFromSetPickList($pickList))) {
            throw new \InvalidArgumentException($pickListArrayErrorMessage, __LINE__);
        }
        if (is_null($pickList) || (is_array($pickList) && empty($pickList))) {
            unset($this->PickList);
        } else {
            $this->PickList = $pickList;
        }
        return $this;
    }
    /**
     * Add item to PickList value
     * @throws \InvalidArgumentException
     * @param \StructType\PickList $item
     * @return \ArrayType\ArrayOfPickList
     */
    public function addToPickList(\StructType\PickList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PickList) {
            throw new \InvalidArgumentException(sprintf('The PickList property can only contain items of type \StructType\PickList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PickList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PickList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PickList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PickList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PickList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PickList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PickList
     */
    public function getAttributeName()
    {
        return 'PickList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPickList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
