<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBaseEntity ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBaseEntity
 * @subpackage Arrays
 */
class ArrayOfBaseEntity extends AbstractStructArrayBase
{
    /**
     * The BaseEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BaseEntity[]
     */
    public $BaseEntity;
    /**
     * Constructor method for ArrayOfBaseEntity
     * @uses ArrayOfBaseEntity::setBaseEntity()
     * @param \StructType\BaseEntity[] $baseEntity
     */
    public function __construct(array $baseEntity = array())
    {
        $this
            ->setBaseEntity($baseEntity);
    }
    /**
     * Get BaseEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BaseEntity[]|null
     */
    public function getBaseEntity()
    {
        return isset($this->BaseEntity) ? $this->BaseEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseEntityForArrayConstraintsFromSetBaseEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBaseEntityBaseEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfBaseEntityBaseEntityItem instanceof \StructType\BaseEntity) {
                $invalidValues[] = is_object($arrayOfBaseEntityBaseEntityItem) ? get_class($arrayOfBaseEntityBaseEntityItem) : sprintf('%s(%s)', gettype($arrayOfBaseEntityBaseEntityItem), var_export($arrayOfBaseEntityBaseEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaseEntity property can only contain items of type \StructType\BaseEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaseEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BaseEntity[] $baseEntity
     * @return \ArrayType\ArrayOfBaseEntity
     */
    public function setBaseEntity(array $baseEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($baseEntityArrayErrorMessage = self::validateBaseEntityForArrayConstraintsFromSetBaseEntity($baseEntity))) {
            throw new \InvalidArgumentException($baseEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($baseEntity) || (is_array($baseEntity) && empty($baseEntity))) {
            unset($this->BaseEntity);
        } else {
            $this->BaseEntity = $baseEntity;
        }
        return $this;
    }
    /**
     * Add item to BaseEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseEntity $item
     * @return \ArrayType\ArrayOfBaseEntity
     */
    public function addToBaseEntity(\StructType\BaseEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaseEntity) {
            throw new \InvalidArgumentException(sprintf('The BaseEntity property can only contain items of type \StructType\BaseEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaseEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BaseEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BaseEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BaseEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BaseEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BaseEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BaseEntity
     */
    public function getAttributeName()
    {
        return 'BaseEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBaseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
